/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.csm.config;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.tydic.nicc.dc.csm.mapper"}, sqlSessionTemplateRef="niccCsmSqlSessionTemplate")
public class NiccCsmDatasourceConfigure {
    @Bean(name={"niccCsmSource"})
    @ConfigurationProperties(prefix="nicc-dc-config.datasource.nicc-csm")
    public DataSource niccDdSourceBuild() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"niccCsmSqlSessionFactory"})
    public SqlSessionFactory testSqlSessionFactory(@Qualifier(value="niccCsmSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/dc/csm/*.xml"));
        return bean.getObject();
    }

    @Bean(name={"niccCsmTransactionManager"})
    public DataSourceTransactionManager testTransactionManager(@Qualifier(value="niccCsmSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"niccCsmSqlSessionTemplate"})
    public SqlSessionTemplate testSqlSessionTemplate(@Qualifier(value="niccCsmSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

