/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.csm.service.impl;

import com.tydic.nicc.dc.csm.mapper.RpCustServiceStateStatisticsMapper;
import com.tydic.nicc.dc.csm.mapper.po.RpCustServiceStateStatisticsPo;
import com.tydic.nicc.dc.csm.service.CsStateStatisticsService;
import com.tydic.nicc.dc.csm.service.bo.CsPieBo;
import com.tydic.nicc.dc.csm.service.bo.CsPieReqBo;
import com.tydic.nicc.dc.csm.service.bo.CsPieRspBo;
import com.tydic.nicc.dc.csm.service.bo.CsStateBo;
import com.tydic.nicc.dc.csm.service.bo.CsStateStatisticsReqBo;
import com.tydic.nicc.dc.csm.service.bo.CsStateStatisticsRspBo;
import com.tydic.nicc.dc.csm.service.bo.CsStatisticsBo;
import com.tydic.nicc.dc.csm.service.bo.CsStatusTrendReqBo;
import com.tydic.nicc.dc.csm.service.bo.CsStatusTrendRspBo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsStateStatisticsServiceImpl
implements CsStateStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(CsStateStatisticsServiceImpl.class);
    @Autowired
    private RpCustServiceStateStatisticsMapper rpCustServiceStateStatisticsMapper;

    @Override
    public CsStateStatisticsRspBo csStateDisribution(CsStateStatisticsReqBo csStateStatisticsReqBo) {
        log.info("\u8fdb\u5165\u5ba2\u670d\u72b6\u6001\u5206\u5e03\u7edf\u8ba1\u903b\u8f91\uff0c\u5165\u53c2CsStateStatisticsReqBo {}", (Object)csStateStatisticsReqBo.toString());
        CsStateStatisticsRspBo csStateStatisticsRspBo = new CsStateStatisticsRspBo();
        Integer isManager = csStateStatisticsReqBo.getIsManager();
        RpCustServiceStateStatisticsPo reqPo = new RpCustServiceStateStatisticsPo();
        if (StringUtils.isBlank((CharSequence)csStateStatisticsReqBo.getTenantCode())) {
            csStateStatisticsRspBo.setCode("9999");
            csStateStatisticsRspBo.setMessage("[TenantCode] cannot be null ");
            return csStateStatisticsRspBo;
        }
        if (csStateStatisticsReqBo.getIsManager() == null) {
            csStateStatisticsRspBo.setCode("9999");
            csStateStatisticsRspBo.setMessage("[IsManager] cannot be null");
            return csStateStatisticsRspBo;
        }
        if (StringUtils.isBlank((CharSequence)csStateStatisticsReqBo.getCsCode())) {
            csStateStatisticsRspBo.setCode("9999");
            csStateStatisticsRspBo.setMessage("[CsCode] cannot be null");
            return csStateStatisticsRspBo;
        }
        if (csStateStatisticsReqBo.getRpDate() == null) {
            csStateStatisticsRspBo.setCode("9999");
            csStateStatisticsRspBo.setMessage("[RpDate] cannot be null");
            return csStateStatisticsRspBo;
        }
        reqPo.setTenantCode(csStateStatisticsReqBo.getTenantCode());
        reqPo.setCsCode(csStateStatisticsReqBo.getCsCode());
        reqPo.setRpDate(csStateStatisticsReqBo.getRpDate());
        if (isManager == 0) {
            CsStateBo csStateBo = this.dealCsList(reqPo, csStateStatisticsReqBo.getCsCode());
            csStateStatisticsRspBo.setIsManager(isManager);
            csStateStatisticsRspBo.setAllCustOnlineTime(csStateBo.getAllOnlineTime());
        } else {
            List<String> list = this.rpCustServiceStateStatisticsMapper.selectCustServer(reqPo);
            ArrayList csStateBos = new ArrayList();
            Long allOnlineTime = 0L;
            if (list != null && list.size() > 0) {
                log.info("\u79df\u6237={}\u4e0b\u6709\u5ba2\u670d={}", (Object)csStateStatisticsReqBo.getTenantCode(), (Object)list.toString());
                for (String csCode : list) {
                    reqPo.setCsCode(csCode);
                    CsStateBo csStateBo = this.dealCsList(reqPo, csCode);
                    if (csStateBo.getAllOnlineTime() == null) continue;
                    allOnlineTime = allOnlineTime + csStateBo.getAllOnlineTime();
                }
            }
            log.info("\u6b64\u79df\u6237\u7684\u5728\u7ebf\u603b\u65f6\u957f\u4e3a={}", (Object)allOnlineTime);
            csStateStatisticsRspBo.setIsManager(isManager);
            csStateStatisticsRspBo.setAllCustOnlineTime(allOnlineTime);
        }
        csStateStatisticsRspBo.setCode("0000");
        csStateStatisticsRspBo.setMessage("success");
        log.info("\u5b8c\u6210\u5ba2\u670d\u72b6\u6001\u5206\u5e03\u7edf\u8ba1\u903b\u8f91\uff0c\u51fa\u53c2CsStateStatisticsRspBo {}", (Object)csStateStatisticsRspBo.toString());
        return csStateStatisticsRspBo;
    }

    @Override
    public CsStatusTrendRspBo getCsTrend(CsStatusTrendReqBo csStatusTrendReqBo) {
        CsStatusTrendRspBo rspBo = new CsStatusTrendRspBo();
        if (StringUtils.isBlank((CharSequence)csStatusTrendReqBo.getTenantCode())) {
            rspBo.setCode("9999");
            rspBo.setMessage("[TenantCode] cannot be null");
            return rspBo;
        }
        if (csStatusTrendReqBo.getIsManager() == null) {
            rspBo.setMessage("[IsManager] cannot be null");
            rspBo.setCode("9999");
            return rspBo;
        }
        if (csStatusTrendReqBo.getBeginRpDate() == null || csStatusTrendReqBo.getEndRpDate() == null) {
            rspBo.setCode("9999");
            rspBo.setMessage("[BeginRpDate] cannot be null");
            return rspBo;
        }
        Date beginRpDate = csStatusTrendReqBo.getBeginRpDate();
        Date endRpDate = csStatusTrendReqBo.getEndRpDate();
        RpCustServiceStateStatisticsPo statisticsPo = new RpCustServiceStateStatisticsPo();
        statisticsPo.setTenantCode(csStatusTrendReqBo.getTenantCode());
        List<Date> betweenDates = this.getBetweenDates(beginRpDate, endRpDate);
        if (csStatusTrendReqBo.getIsManager() == 0) {
            if (StringUtils.isBlank((CharSequence)csStatusTrendReqBo.getCsCode())) {
                rspBo.setMessage("[CsCode] cannot be null");
                rspBo.setCode("9999");
                return rspBo;
            }
            statisticsPo.setCsCode(csStatusTrendReqBo.getCsCode());
            List<RpCustServiceStateStatisticsPo> poList = this.rpCustServiceStateStatisticsMapper.selectByDate(statisticsPo, beginRpDate, endRpDate);
            ArrayList<CsStatisticsBo> list = new ArrayList<CsStatisticsBo>();
            for (Date betweenDate : betweenDates) {
                CsStatisticsBo bo = new CsStatisticsBo(this.getStringDate(betweenDate), 0L);
                list.add(bo);
            }
            if (poList != null && poList.size() > 0) {
                for (CsStatisticsBo bo : list) {
                    for (RpCustServiceStateStatisticsPo po : poList) {
                        if (!bo.getRpDate().equals(this.getStringDate(po.getRpDate()))) continue;
                        bo.setCsCode(csStatusTrendReqBo.getCsCode());
                        bo.setTotalOnline(po.getOnlineTime());
                    }
                }
            }
            rspBo.setCsStatisticsList(list);
        } else {
            statisticsPo.setCsCode(csStatusTrendReqBo.getCsCode());
            List<RpCustServiceStateStatisticsPo> poList = this.rpCustServiceStateStatisticsMapper.selectAllByDate(statisticsPo, beginRpDate, endRpDate);
            ArrayList<CsStatisticsBo> list = new ArrayList<CsStatisticsBo>();
            for (Date betweenDate : betweenDates) {
                CsStatisticsBo bo = new CsStatisticsBo(this.getStringDate(betweenDate), 0L);
                list.add(bo);
            }
            if (poList != null && poList.size() > 0) {
                for (CsStatisticsBo bo : list) {
                    for (RpCustServiceStateStatisticsPo po : poList) {
                        if (!bo.getRpDate().equals(this.getStringDate(po.getRpDate()))) continue;
                        bo.setCsCode(csStatusTrendReqBo.getCsCode());
                        bo.setTotalOnline(po.getOnlineTime());
                    }
                }
            }
            rspBo.setCsStatisticsList(list);
        }
        rspBo.setCode("0000");
        rspBo.setMessage("success");
        return rspBo;
    }

    private String getStringDate(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        return sdf.format(d);
    }

    private List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        if (tempStart.equals(tempEnd)) {
            result.add(start);
            return result;
        }
        result.add(start);
        tempStart.add(6, 1);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        result.add(end);
        return result;
    }

    @Override
    public CsPieRspBo getCsPie(CsPieReqBo csPieReqBo) {
        log.info("\u67e5\u8be2\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,\u5165\u53c2={}", (Object)csPieReqBo.toString());
        CsPieRspBo csPieRspBo = new CsPieRspBo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (StringUtils.isBlank((CharSequence)csPieReqBo.getTenantCode_IN())) {
            csPieRspBo.setCode("9999");
            csPieRspBo.setMessage("[TenantCode_IN] cannot be null");
            return csPieRspBo;
        }
        if (csPieReqBo.getIsManager() == null) {
            csPieRspBo.setMessage("[IsManager] cannot be null");
            csPieRspBo.setCode("9999");
            return csPieRspBo;
        }
        if (csPieReqBo.getRpDate() == null) {
            csPieRspBo.setCode("9999");
            csPieRspBo.setMessage("[RpDate] cannot be null");
            return csPieRspBo;
        }
        Date parse = null;
        try {
            parse = sdf.parse(csPieReqBo.getRpDate());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        RpCustServiceStateStatisticsPo reqPo = new RpCustServiceStateStatisticsPo();
        reqPo.setRpDate(parse);
        reqPo.setTenantCode(csPieReqBo.getTenantCode_IN());
        if (csPieReqBo.getIsManager() == 0) {
            reqPo.setCsCode(csPieReqBo.getUserId_IN());
            log.info("\u67e5\u8be2\u5355\u5ba2\u670d\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,po\u5165\u53c2={}", (Object)reqPo.toString());
            List<RpCustServiceStateStatisticsPo> pos = this.rpCustServiceStateStatisticsMapper.selectByCsCode(reqPo);
            List<CsPieBo> list = Arrays.asList(new CsPieBo(1, 0L), new CsPieBo(2, 0L), new CsPieBo(3, 0L), new CsPieBo(4, 0L), new CsPieBo(5, 0L), new CsPieBo(6, 0L));
            if (pos != null && pos.size() > 0) {
                log.info("\u67e5\u8be2\u5355\u5ba2\u670d\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,po\u51fa\u53c2={}", (Object)pos.toString());
                for (CsPieBo csPieBo : list) {
                    for (RpCustServiceStateStatisticsPo po : pos) {
                        if (po.getCustState() != csPieBo.getStatus()) continue;
                        csPieBo.setOnlineTime(po.getOnlineTime());
                    }
                }
            }
            csPieRspBo.setCsPieBos(list);
        } else {
            log.info("\u67e5\u8be2\u79df\u6237\u4e0b\u5ba2\u670d\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,po\u5165\u53c2={}", (Object)reqPo.toString());
            List<RpCustServiceStateStatisticsPo> pos = this.rpCustServiceStateStatisticsMapper.selectPieStatus(reqPo);
            List<CsPieBo> list = Arrays.asList(new CsPieBo(1, 0L), new CsPieBo(2, 0L), new CsPieBo(3, 0L), new CsPieBo(4, 0L), new CsPieBo(5, 0L), new CsPieBo(6, 0L));
            if (pos != null && pos.size() > 0) {
                log.info("\u67e5\u8be2\u79df\u6237\u4e0b\u5ba2\u670d\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,po\u51fa\u53c2={}", (Object)pos.toString());
                for (CsPieBo csPieBo : list) {
                    for (RpCustServiceStateStatisticsPo po : pos) {
                        if (po.getCustState() != csPieBo.getStatus()) continue;
                        csPieBo.setOnlineTime(po.getOnlineTime());
                    }
                }
            }
            csPieRspBo.setCsPieBos(list);
        }
        csPieRspBo.setRpDate(csPieReqBo.getRpDate());
        csPieRspBo.setCode("0000");
        csPieRspBo.setMessage("success");
        log.info("\u67e5\u8be2\u4e00\u5929\u5185\u5404\u4e2a\u72b6\u6001\u7684\u65f6\u957f,\u51fa\u53c2={}", (Object)csPieRspBo.toString());
        return csPieRspBo;
    }

    private CsStateBo dealCsList(RpCustServiceStateStatisticsPo reqPo, String csCode) {
        log.info("\u67e5\u8be2\u5ba2\u670d={}\u7684\u5165\u53c2po={}", (Object)csCode, (Object)reqPo);
        List<RpCustServiceStateStatisticsPo> rpCustServiceStateStatisticsPoList = this.rpCustServiceStateStatisticsMapper.selectByCsCode(reqPo);
        CsStateBo csStateBo = new CsStateBo();
        log.info("\u67e5\u8be2\u5ba2\u670d={}\u7684\u51fa\u53c2po={}", (Object)csCode, (Object)reqPo);
        if (null != rpCustServiceStateStatisticsPoList && !rpCustServiceStateStatisticsPoList.isEmpty()) {
            ArrayList list = new ArrayList();
            Long allOnlineTime = 0L;
            for (RpCustServiceStateStatisticsPo rpCustServiceStateStatisticsPo : rpCustServiceStateStatisticsPoList) {
                if (rpCustServiceStateStatisticsPo.getCustState() == 6 || rpCustServiceStateStatisticsPo.getCustState() == 4 || rpCustServiceStateStatisticsPo.getCustState() == 2) continue;
                allOnlineTime = allOnlineTime + rpCustServiceStateStatisticsPo.getOnlineTime();
                log.info("{}\u7684\u5728\u7ebf\u603b\u65f6\u957f\u4e3a={}", (Object)csCode, (Object)allOnlineTime);
            }
            csStateBo.setAllOnlineTime(allOnlineTime);
            log.info("\u67e5\u8be2\u5ba2\u670d={}\u7684\u72b6\u6001\u65f6\u957f,csStateBo={}", (Object)csCode, (Object)csStateBo.toString());
        }
        return csStateBo;
    }
}

