/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.csm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.dc.base.bo.DcRsp;
import com.tydic.nicc.dc.base.bo.maxwell.MaxwellBO;
import com.tydic.nicc.dc.boot.starter.redis.RedisLuaLockComponent;
import com.tydic.nicc.dc.boot.starter.util.DcRspUtils;
import com.tydic.nicc.dc.csm.mapper.CsStatusRecordMapper;
import com.tydic.nicc.dc.csm.mapper.RpCustServiceStateStatisticsMapper;
import com.tydic.nicc.dc.csm.mapper.po.RpCustServiceStateStatisticsPo;
import com.tydic.nicc.dc.csm.service.CsStatusChangeService;
import com.tydic.nicc.dc.csm.service.bo.CsStatusChangeReqBo;
import com.tydic.nicc.dc.csm.service.bo.CsStatusChangeRspBo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@Component
public class CsStatusChangeServiceImpl
implements CsStatusChangeService {
    private static final Logger log = LoggerFactory.getLogger(CsStatusChangeServiceImpl.class);
    @Autowired
    private CsStatusRecordMapper csStatusRecordMapper;
    @Autowired
    private RpCustServiceStateStatisticsMapper statisticsMapper;
    @Resource
    @Qualifier(value="redisLuaLockComponent")
    private RedisLuaLockComponent redisLuaLockComponent;
    public final String LOCK_KEY_PREFIX = "CsStatusChangeServiceImpl_GET_CUST_SERVICE_STATUS_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DcRsp getCsStatus(MaxwellBO maxwellBo) {
        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1maxwellBo={}", (Object)maxwellBo.toString());
        CsStatusChangeRspBo csStatusChangeRspBo = new CsStatusChangeRspBo();
        log.info("------------------------------------");
        CsStatusChangeReqBo reqBo = this.jsonParse(maxwellBo.getData());
        log.info("json\u8f6c\u6362\u5bf9\u8c61\uff0cCsStatusChangeReqBo={}", (Object)reqBo.toString());
        String customerId = reqBo.getTenantCode() + "_" + reqBo.getCsCode();
        String lockKey = this.redisLuaLockComponent.generateLockKey("CsStatusChangeServiceImpl_GET_CUST_SERVICE_STATUS_", customerId);
        if (this.redisLuaLockComponent.luaLock(lockKey, customerId, 5L)) {
            try {
                Date createTime = this.formatTime(reqBo.getCreateTime());
                Date endTime = this.countTime(reqBo.getCreateTime(), false);
                RpCustServiceStateStatisticsPo statisticsPo = new RpCustServiceStateStatisticsPo();
                statisticsPo.setTenantCode(reqBo.getTenantCode());
                statisticsPo.setCsCode(reqBo.getCsCode());
                statisticsPo.setRpDate(createTime);
                statisticsPo.setCustState(reqBo.getNowState());
                List<RpCustServiceStateStatisticsPo> countList = this.statisticsMapper.selectList(statisticsPo);
                log.info("\u67e5\u8be2\u7ed3\u679c\uff0ccountList = {}", (Object)countList.toString());
                if (CollectionUtils.isEmpty(countList)) {
                    statisticsPo.setCreateTime(new Date());
                    statisticsPo.setUserId(Long.valueOf(reqBo.getCsCode()));
                    statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), createTime));
                    if (endTime.getTime() < reqBo.getUpdateTime().getTime()) {
                        long yesterdayTime = endTime.getTime() - reqBo.getCreateTime().getTime();
                        statisticsPo.setOnlineTime(yesterdayTime / 1000L);
                        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u6628\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                        this.statisticsMapper.insertSelective(statisticsPo);
                        long todayTime = reqBo.getUpdateTime().getTime() - endTime.getTime();
                        Date updateTime = this.formatTime(reqBo.getUpdateTime());
                        statisticsPo.setOnlineTime(todayTime / 1000L);
                        statisticsPo.setRpDate(updateTime);
                        statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), updateTime));
                        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u4eca\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                        this.statisticsMapper.insertSelective(statisticsPo);
                    } else {
                        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                        statisticsPo.setOnlineTime(reqBo.getLastTime());
                        this.statisticsMapper.insertSelective(statisticsPo);
                    }
                } else {
                    for (RpCustServiceStateStatisticsPo count : countList) {
                        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1 count = {}", (Object)count.toString());
                        statisticsPo.setUpdateTime(new Date());
                        statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), createTime));
                        if (endTime.getTime() < reqBo.getUpdateTime().getTime()) {
                            long yesterdayTime = endTime.getTime() - reqBo.getCreateTime().getTime();
                            statisticsPo.setOnlineTime(count.getOnlineTime() + yesterdayTime / 1000L);
                            log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u6628\u5929\u66f4\u65b0\u7684statisticsPo={}", (Object)statisticsPo.toString());
                            this.statisticsMapper.updateByPrimaryKeySelective(statisticsPo);
                            long todayTime = reqBo.getUpdateTime().getTime() - endTime.getTime();
                            statisticsPo.setOnlineTime(todayTime / 1000L);
                            Date updateTime = this.formatTime(reqBo.getUpdateTime());
                            statisticsPo.setRpDate(updateTime);
                            statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), updateTime));
                            statisticsPo.setCreateTime(new Date());
                            statisticsPo.setUserId(Long.valueOf(reqBo.getCsCode()));
                            statisticsPo.setUpdateTime(null);
                            log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u4eca\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                            this.statisticsMapper.insertSelective(statisticsPo);
                            continue;
                        }
                        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u66f4\u65b0\u7684statisticsPo={}", (Object)statisticsPo.toString());
                        statisticsPo.setOnlineTime(reqBo.getLastTime() + count.getOnlineTime());
                        this.statisticsMapper.updateByPrimaryKeySelective(statisticsPo);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u66f4\u65b0\u9519\u8bef\uff1a{}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
            }
            finally {
                this.redisLuaLockComponent.luaUnLock(lockKey, customerId);
            }
        }
        return DcRspUtils.createSuccessRsp((Object)"\u67e5\u8be2\u6210\u529f\uff01");
    }

    private CsStatusChangeReqBo jsonParse(String data) {
        CsStatusChangeReqBo reqBo = new CsStatusChangeReqBo();
        JSONObject json = JSONObject.parseObject((String)data);
        String createTime = json.getString("create_time");
        String tenantCode = json.getString("tenant_code");
        String updateTime = json.getString("update_time");
        long lastTime = json.getLong("last_time");
        String csCode = json.getString("cs_code");
        int formerState = json.getInteger("former_state");
        int nowState = json.getInteger("now_state");
        Date createDate = null;
        Date updateDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            createDate = sdf.parse(createTime);
            updateDate = sdf.parse(updateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            log.error("json\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        reqBo.setCreateTime(createDate);
        reqBo.setUpdateTime(updateDate);
        reqBo.setCsCode(csCode);
        reqBo.setLastTime(lastTime);
        reqBo.setFormerState(formerState);
        reqBo.setNowState(nowState);
        reqBo.setTenantCode(tenantCode);
        return reqBo;
    }

    private Date formatTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            String format = sdf2.format(date);
            parse = sdf.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;
    }

    private Date countTime(Date date, Boolean isStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date todayStart = calendar.getTime();
        calendar.setTime(date);
        calendar.set(11, 24);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date todayEnd = calendar.getTime();
        if (isStart.booleanValue()) {
            return todayStart;
        }
        return todayEnd;
    }

    private String mixField(String tenantCode, String csCode, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String format = sdf.format(date);
        return tenantCode + "_" + csCode + "_" + format;
    }
}

