/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.csm.service.impl;

import com.tydic.nicc.dc.base.bo.DcRsp;
import com.tydic.nicc.dc.base.bo.maxwell.MaxwellBO;
import com.tydic.nicc.dc.boot.starter.util.DcRspUtils;
import com.tydic.nicc.dc.csm.mapper.CsStatusRecordMapper;
import com.tydic.nicc.dc.csm.mapper.RpCustServiceStateStatisticsMapper;
import com.tydic.nicc.dc.csm.mapper.po.RpCustServiceStateStatisticsPo;
import com.tydic.nicc.dc.csm.service.CsStatusChangeService;
import com.tydic.nicc.dc.csm.service.bo.CsStatusChangeReqBo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Service
@Component
public class CsStatusChangeServiceImpl
implements CsStatusChangeService {
    private static final Logger log = LoggerFactory.getLogger(CsStatusChangeServiceImpl.class);
    @Autowired
    private CsStatusRecordMapper csStatusRecordMapper;
    @Autowired
    private RpCustServiceStateStatisticsMapper statisticsMapper;

    @Override
    public DcRsp getCsStatus(MaxwellBO maxwellBo) {
        log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1maxwellBo={}", (Object)maxwellBo.toString());
        log.info("------------------------------------");
        CsStatusChangeReqBo reqBo = this.jsonParse(maxwellBo.getData());
        log.info("json\u8f6c\u6362\u5bf9\u8c61\uff0cCsStatusChangeReqBo={}", (Object)reqBo.toString());
        Date createTime = this.formatTime(reqBo.getCreateTime());
        Date endTime = this.countTime(reqBo.getCreateTime(), false);
        RpCustServiceStateStatisticsPo statisticsPo = new RpCustServiceStateStatisticsPo();
        statisticsPo.setTenantCode(reqBo.getTenantCode());
        statisticsPo.setCsCode(reqBo.getCsCode());
        statisticsPo.setRpDate(createTime);
        statisticsPo.setCustState(reqBo.getFormerState());
        RpCustServiceStateStatisticsPo count = this.statisticsMapper.selectCount(statisticsPo);
        if (count != null) {
            log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1count={}", (Object)count.toString());
            statisticsPo.setUpdateTime(new Date());
            statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), createTime));
            if (endTime.getTime() < reqBo.getUpdateTime().getTime()) {
                long yesterdayTime = endTime.getTime() - reqBo.getCreateTime().getTime();
                statisticsPo.setOnlineTime(count.getOnlineTime() + yesterdayTime / 1000L);
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u6628\u5929\u66f4\u65b0\u7684statisticsPo={}", (Object)statisticsPo.toString());
                this.statisticsMapper.updateByPrimaryKeySelective(statisticsPo);
                long todayTime = reqBo.getUpdateTime().getTime() - endTime.getTime();
                statisticsPo.setOnlineTime(todayTime / 1000L);
                Date updateTime = this.formatTime(reqBo.getUpdateTime());
                statisticsPo.setRpDate(updateTime);
                statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), updateTime));
                statisticsPo.setCreateTime(new Date());
                statisticsPo.setUserId(Long.valueOf(reqBo.getCsCode()));
                statisticsPo.setUpdateTime(null);
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u4eca\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                this.statisticsMapper.insertSelective(statisticsPo);
            } else {
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1\u5f53\u65e5\u5df2\u6709\u6570\u636e,\u66f4\u65b0\u7684statisticsPo={}", (Object)statisticsPo.toString());
                statisticsPo.setOnlineTime(reqBo.getLastTime() + count.getOnlineTime());
                this.statisticsMapper.updateByPrimaryKeySelective(statisticsPo);
            }
        } else {
            statisticsPo.setCreateTime(new Date());
            statisticsPo.setUserId(Long.valueOf(reqBo.getCsCode()));
            statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), createTime));
            if (endTime.getTime() < reqBo.getUpdateTime().getTime()) {
                long yesterdayTime = endTime.getTime() - reqBo.getCreateTime().getTime();
                statisticsPo.setOnlineTime(yesterdayTime / 1000L);
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u6628\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                this.statisticsMapper.insertSelective(statisticsPo);
                long todayTime = reqBo.getUpdateTime().getTime() - endTime.getTime();
                Date updateTime = this.formatTime(reqBo.getUpdateTime());
                statisticsPo.setOnlineTime(todayTime / 1000L);
                statisticsPo.setRpDate(updateTime);
                statisticsPo.setMixField(this.mixField(reqBo.getTenantCode(), reqBo.getCsCode(), updateTime));
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u4e14\u8de8\u96f6\u70b9,\u4eca\u5929\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                this.statisticsMapper.insertSelective(statisticsPo);
            } else {
                log.info("\u5ba2\u670d\u72b6\u6001\u7edf\u8ba1,\u5f53\u65e5\u6ca1\u6709\u6570\u636e,\u63d2\u5165\u7684statisticsPo={}", (Object)statisticsPo.toString());
                statisticsPo.setOnlineTime(reqBo.getLastTime());
                this.statisticsMapper.insertSelective(statisticsPo);
            }
        }
        return DcRspUtils.createSuccessRsp((Object)"\u67e5\u8be2\u6210\u529f\uff01");
    }

    private CsStatusChangeReqBo jsonParse(String data) {
        CsStatusChangeReqBo reqBo = new CsStatusChangeReqBo();
        JSONObject json = JSONObject.fromObject((Object)data);
        String createTime = json.getString("create_time");
        String tenantCode = json.getString("tenant_code");
        String updateTime = json.getString("update_time");
        long lastTime = json.getLong("last_time");
        String csCode = json.getString("cs_code");
        int formerState = json.getInt("former_state");
        int nowState = json.getInt("now_state");
        Date createDate = null;
        Date updateDate = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            createDate = sdf.parse(createTime);
            updateDate = sdf.parse(updateTime);
        }
        catch (ParseException e) {
            e.printStackTrace();
            log.error("json\u5904\u7406\u5f02\u5e38", (Throwable)e);
        }
        reqBo.setCreateTime(createDate);
        reqBo.setUpdateTime(updateDate);
        reqBo.setCsCode(csCode);
        reqBo.setLastTime(lastTime);
        reqBo.setFormerState(formerState);
        reqBo.setNowState(nowState);
        reqBo.setTenantCode(tenantCode);
        return reqBo;
    }

    private Date formatTime(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = null;
        try {
            String format = sdf2.format(date);
            parse = sdf.parse(format);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parse;
    }

    private Date countTime(Date date, Boolean isStart) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date todayStart = calendar.getTime();
        calendar.setTime(date);
        calendar.set(11, 24);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date todayEnd = calendar.getTime();
        if (isStart.booleanValue()) {
            return todayStart;
        }
        return todayEnd;
    }

    private String mixField(String tenantCode, String csCode, Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String format = sdf.format(date);
        return tenantCode + "_" + csCode + "_" + format;
    }
}

