/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.dc.session.config;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(basePackages={"com.tydic.nicc.dc.session.mapper"}, sqlSessionTemplateRef="niccSessionSqlSessionTemplate")
public class NiccSessionDatasourceConfigure {
    @Bean(name={"niccSessionSource"})
    @ConfigurationProperties(prefix="nicc-dc-config.datasource.nicc-session")
    public DataSource niccDdSourceBuild() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"niccSessionSqlSessionFactory"})
    public SqlSessionFactory testSqlSessionFactory(@Qualifier(value="niccSessionSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/dc/session/*.xml"));
        return bean.getObject();
    }

    @Bean(name={"niccSessionTransactionManager"})
    public DataSourceTransactionManager testTransactionManager(@Qualifier(value="niccSessionSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"niccSessionSqlSessionTemplate"})
    public SqlSessionTemplate testSqlSessionTemplate(@Qualifier(value="niccSessionSqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

