/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.config;

import com.tydic.nicc.framework.rocketmq.RocketMQProducer;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(prefix="rocketmq", value={"name-server"})
@Configuration
public class RocketMqProducerAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(RocketMqProducerAutoConfig.class);
    @Autowired(required=false)
    private RocketMQTemplate rocketMQTemplate;
    @Value(value="${rocketmq.producer.send-message-timeout:2000}")
    private Integer messageTimeOut;

    @Bean(name={"rocketMQProducer"})
    public RocketMQProducer createRocketMqProducer() {
        if (this.rocketMQTemplate == null) {
            log.error("RocketMqProducerAutoConfig.createRocketMqProducer() \u521d\u59cb\u5316\u5931\u8d25!");
        }
        return new RocketMQProducer(this.rocketMQTemplate, this.messageTimeOut);
    }
}

