/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.rocketmq;

import javax.annotation.PostConstruct;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.support.MessageBuilder;

public class RocketMQProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducer.class);
    private RocketMQTemplate rocketMQTemplate;
    private Integer messageTimeOut;

    public RocketMQProducer(RocketMQTemplate rocketMQTemplate, Integer messageTimeOut) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.messageTimeOut = messageTimeOut;
    }

    @PostConstruct
    public void init() {
        log.info("\u521d\u59cb\u5316 RocketMQ \u751f\u4ea7\u8005\u5b8c\u6210: messageTimeOut = {}", (Object)this.messageTimeOut);
    }

    public void sendAsyncMsg(String topic, String msgBody, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(topic, MessageBuilder.withPayload((Object)msgBody).build(), callback);
    }

    public void sendAsyncMsg(String topic, String tagName, String msgBody, SendCallback callback) {
        this.rocketMQTemplate.asyncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build(), callback);
    }

    public void sendDelayMsg(String topic, Object msgBody, Integer delayLevel) {
        this.rocketMQTemplate.syncSend(topic, MessageBuilder.withPayload((Object)msgBody).build(), (long)this.messageTimeOut.intValue(), delayLevel.intValue());
    }

    public SendResult sendDelayMsg(String topic, String tagName, Object msgBody, Integer delayLevel) {
        return this.rocketMQTemplate.syncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build(), (long)this.messageTimeOut.intValue(), delayLevel.intValue());
    }

    public void sendMsg(String topic, Object msgBody) {
        this.rocketMQTemplate.syncSend(topic, MessageBuilder.withPayload((Object)msgBody).build());
    }

    public void sendMsg(String topic, String tagName, String msgBody) {
        this.rocketMQTemplate.syncSend(String.format("%s:%s", topic, tagName), MessageBuilder.withPayload((Object)msgBody).build());
    }
}

