/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import java.math.BigDecimal;

public class AmountUtil {
    private AmountUtil() {
    }

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return AmountUtil.div(v1, v2, 2);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static boolean equal(double a, double b) {
        BigDecimal v2;
        BigDecimal v1 = BigDecimal.valueOf(a);
        return v1.compareTo(v2 = BigDecimal.valueOf(b)) == 0;
    }

    public static boolean greaterThanOrEqualTo(double a, double b) {
        BigDecimal v2;
        BigDecimal v1 = BigDecimal.valueOf(a);
        return v1.compareTo(v2 = BigDecimal.valueOf(b)) >= 0;
    }

    public static boolean bigger(double a, double b) {
        BigDecimal v2;
        BigDecimal v1 = BigDecimal.valueOf(a);
        return v1.compareTo(v2 = BigDecimal.valueOf(b)) == 1;
    }

    public static boolean lessThan(double a, double b) {
        BigDecimal v2;
        BigDecimal v1 = BigDecimal.valueOf(a);
        return v1.compareTo(v2 = BigDecimal.valueOf(b)) == -1;
    }

    public static double roundDown(double num) {
        return Double.valueOf(String.format("%.2f", num));
    }

    public static void main(String[] args) {
        Double a = 101.005;
        Double b = 0.0;
        Double s = AmountUtil.sub(a, b);
        System.out.println(AmountUtil.roundDown(s));
        System.out.println(AmountUtil.div(101.1, 1.0, 2));
    }
}

