/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class NiccCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(NiccCommonUtil.class);
    public static final String CHAT_KEY_PREFIX = "chat";
    public static final String GUEST_KEY = "guest_";
    public static final String GUEST_NAME = "\u6e38\u5ba2";
    private static int min = 10000000;
    private static int max = 99999999;
    private static Pattern humpPattern = Pattern.compile("[A-Z]");
    public static final String regex = "'|and|exec|execute|insert|select|delete|update|count|drop|\\*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|-|\\+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|\\*|chr|mid|master|truncate|char|declare|or|;|-|--|\\+|,|like|//|/|%|#";

    public static String filterSql(String param) {
        if (param == null) {
            return param;
        }
        return param.replaceAll("(?i)'|and|exec|execute|insert|select|delete|update|count|drop|\\*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|-|\\+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|\\*|chr|mid|master|truncate|char|declare|or|;|-|--|\\+|,|like|//|/|%|#", "");
    }

    public static String underline2Camel(String line, boolean smallCamel) {
        if (line == null || "".equals(line)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(smallCamel && matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String stringToMD5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2amd5\u7b97\u6cd5\uff01");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); ++i) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    public static String getIpAddress() {
        String host = "";
        try {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (StringUtils.isEmpty((CharSequence)host)) {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = allNetInterfaces.nextElement();
                    if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (ip == null || !(ip instanceof Inet4Address)) continue;
                        return ip.getHostAddress();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("IP\u5730\u5740\u83b7\u53d6\u5931\u8d25" + e.toString());
        }
        return host;
    }

    public static String getRealIP() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || !netInterface.getDisplayName().contains("Intel") && !netInterface.getDisplayName().contains("Realtek")) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    System.out.println("ipv4 = " + ip.getHostAddress());
                    return ip.getHostAddress();
                }
                break block2;
            }
        }
        catch (SocketException e) {
            System.err.println("Error when getting host ip address" + e.getMessage());
        }
        return "";
    }

    public static synchronized int generateRandomCode() {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String createGuestUID() {
        return GUEST_KEY + IdWorker.nextAutoId();
    }

    public static String createGuestNickName() {
        return GUEST_NAME + NiccCommonUtil.generateRandomCode();
    }

    public static String getC2cChatKey(String fromNo, String toNo) {
        if (toNo.startsWith(CHAT_KEY_PREFIX)) {
            return toNo;
        }
        Object[] userIds = new String[]{fromNo, toNo};
        Arrays.sort(userIds);
        String chatKey = (String)userIds[0] + (String)userIds[1];
        String chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5(chatKey);
        log.info("\u751f\u6210chatKey:{} - {}", (Object)chatKey, (Object)chatKeyMd5);
        return chatKeyMd5;
    }

    public static String getC2bChatKey(String tenantCode, String userId) {
        String chatKey = userId + tenantCode;
        String chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5(chatKey);
        log.info("\u751f\u6210chatKey:{} - {}", (Object)chatKey, (Object)chatKeyMd5);
        return chatKeyMd5;
    }

    public static String getC2bChatKey(String tenantCode, UserAuthInfo fromUser, String toNo) {
        if (toNo.startsWith(CHAT_KEY_PREFIX)) {
            return toNo;
        }
        String chatKeyMd5 = "";
        String chatKey = "";
        chatKey = toNo.equals(tenantCode) ? fromUser.getUserId() + tenantCode : (UserTypeField.COMP_USER.getCode().equals(fromUser.getUserType()) ? toNo + tenantCode : fromUser.getUserId() + tenantCode);
        chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5(chatKey);
        log.info("\u751f\u6210chatKey:{} - {}", (Object)chatKey, (Object)chatKeyMd5);
        return chatKeyMd5;
    }

    public static void copyList(List sourceList, List targetList, Class targetClass) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{sourceList, targetList})) {
            for (Object o : sourceList) {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtils.copyProperties(o, target);
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

