/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

public class NiccLinkedList<E> {
    private Node dummyHead = new Node(null, null);
    int size = 0;

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void addFirst(E e) {
        this.add(0, e);
    }

    public void add(int index, E e) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException("Add failed. Illegal index.");
        }
        Node prev = this.dummyHead;
        for (int i = 0; i < index; ++i) {
            prev = prev.next;
        }
        prev.next = new Node(e, prev.next);
        ++this.size;
    }

    public E romove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("remove failed. Illegal index.");
        }
        Node prev = this.dummyHead;
        for (int i = 0; i < index; ++i) {
            prev = prev.next;
        }
        Node retNode = prev.next;
        prev.next = retNode.next;
        retNode.next = null;
        --this.size;
        return retNode.e;
    }

    public E removeFirst() {
        return this.romove(0);
    }

    public E removeLast() {
        return this.romove(this.size - 1);
    }

    public E get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Get failed. Illegal index.");
        }
        Node cur = this.dummyHead.next;
        for (int i = 0; i < index; ++i) {
            cur = cur.next;
        }
        return cur.e;
    }

    public E getFirst() {
        return this.get(0);
    }

    public E getLast() {
        return this.get(this.size - 1);
    }

    public void set(int index, E e) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Set failed. Illegal index.");
        }
        Node cur = this.dummyHead.next;
        for (int i = 0; i < index; ++i) {
            cur = cur.next;
        }
        cur.e = e;
    }

    public boolean contains(E e) {
        Node cur = this.dummyHead.next;
        while (cur != null) {
            if (cur.e.equals(e)) {
                return true;
            }
            cur = cur.next;
        }
        return false;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        Node cur = this.dummyHead.next;
        while (cur != null) {
            res.append(cur + "->");
            cur = cur.next;
        }
        res.append("NULL");
        return res.toString();
    }

    private class Node {
        public E e;
        public Node next;

        public Node(E e, Node next) {
            this.e = e;
            this.next = next;
        }

        public Node(E e) {
            this(e, null);
        }

        public Node() {
            this(null, null);
        }

        public String toString() {
            return this.e.toString();
        }
    }
}

