/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.common.eums.FileUploadType;
import com.tydic.nicc.dc.boot.starter.ftp.SFTPHelper;
import com.tydic.nicc.dc.boot.starter.obs.ObsHelper;
import com.tydic.nicc.dc.boot.starter.oss.OssHelper;
import com.tydic.nicc.framework.config.FileManageConfigPropertiesBean;
import com.tydic.nicc.framework.exception.FileVerifyException;
import com.tydic.nicc.framework.utils.FileUtils;
import com.tydic.nicc.framework.utils.ImageUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileManagerHelper {
    private static final Logger log = LoggerFactory.getLogger(FileManagerHelper.class);
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private OssHelper ossHelper;
    @Autowired(required=false)
    private SFTPHelper sftpHelper;
    @Autowired(required=false)
    private ObsHelper obsHelper;
    @Resource
    private FileManageConfigPropertiesBean fileManageConfigProperties;

    public List<FileManageSaveBO> saveFiles(MultipartFile[] files, String month) throws Exception {
        return this.saveFiles(files, month, true);
    }

    public List<FileManageSaveBO> saveFiles(MultipartFile[] files, String month, boolean compress) throws Exception {
        File upDir;
        if (this.fileManageConfigProperties == null) {
            log.error("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38:\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e!");
            return new ArrayList<FileManageSaveBO>();
        }
        ArrayList fileSaveBOS = Lists.newArrayList();
        String uploadPath = "";
        if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType()) && !(upDir = new File(uploadPath = this.fileManageConfigProperties.getLocalPath() + month)).exists()) {
            upDir.mkdirs();
        }
        if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.sftpHelper = (SFTPHelper)this.context.getBean(SFTPHelper.class);
            this.sftpHelper.mkdir(month);
        }
        for (MultipartFile file : files) {
            this.checkFileAllowed(file);
            String fileNo = this.fileManageConfigProperties.createFileNo();
            String fileName = file.getOriginalFilename();
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            String absFilePath = uploadPath + File.separator + fileNo + fileType;
            String newFileName = fileNo + fileType;
            String relFilePath = month + File.separator + newFileName;
            FileManageSaveBO saveBO = new FileManageSaveBO();
            saveBO.setFileType(fileType);
            saveBO.setFileNo(fileNo);
            saveBO.setFileName(fileName);
            saveBO.setFilePath(relFilePath);
            saveBO.setAccessUrl(this.fileManageConfigProperties.getAccessUrlPrefix() + relFilePath);
            saveBO.setUploadType(this.fileManageConfigProperties.getUploadType());
            InputStream inputStream = file.getInputStream();
            long fileSize = file.getSize();
            if (compress && this.fileManageConfigProperties.getImageCompress().isCompress(file)) {
                byte[] resultByte = ImageUtils.compressPicForScale(file.getBytes(), this.fileManageConfigProperties.getImageCompress().getDestSize());
                inputStream = new ByteArrayInputStream(resultByte);
                fileSize = resultByte.length;
            }
            saveBO.setFileSize(Integer.valueOf(Math.toIntExact(fileSize)));
            if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u5230\u672c\u5730: fileName = {},path = {},size = {}", new Object[]{fileName, absFilePath, file.getSize()});
                if (compress && this.fileManageConfigProperties.getImageCompress().isCompress(file)) {
                    FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(absFilePath));
                } else {
                    file.transferTo(new File(absFilePath));
                }
            }
            if (FileUploadType.OSS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230oss: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.ossHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.OBS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230obs: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.obsHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230ftp: fileName = {},path = {},size = {}", (Object)fileName, (Object)relFilePath);
                boolean upload = this.sftpHelper.uploadFile(inputStream, relFilePath);
                if (!upload) {
                    log.error("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230sftp\u5931\u8d25: relPath = {}", (Object)relFilePath);
                }
                this.sftpHelper.close();
            }
            fileSaveBOS.add(saveBO);
        }
        log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u6210\u529f:{}", (Object)fileSaveBOS);
        return fileSaveBOS;
    }

    public InputStream downloadFile(String fileName) {
        InputStream is = null;
        if (FileUploadType.OSS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            is = this.ossHelper.downLoadToInputStream(fileName);
        }
        if (FileUploadType.OBS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            is = this.obsHelper.download(fileName).getObjectContent();
        }
        if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            is = this.sftpHelper.downloadFile(fileName);
        }
        return is;
    }

    private void checkFileAllowed(MultipartFile file) throws IOException {
        String fileName = file.getOriginalFilename();
        if (!this.checkConfigSuffix(fileName)) {
            log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: filename = " + fileName);
            throw new FileVerifyException(this.fileManageConfigProperties.getErrorFileMsg());
        }
        if (ImageUtils.checkImageSuffix(fileName)) {
            if (!ImageUtils.isImage(file)) {
                log.warn("\u6587\u4ef6\u4e0a\u4f20-\u56fe\u7247\u4e0a\u4f20\u5931\u8d25: filename = " + fileName);
                throw new FileVerifyException(this.fileManageConfigProperties.getErrorImgMsg());
            }
        } else {
            String headerType = FileUtils.getFileHeader(file.getInputStream());
            if (StringUtils.isBlank((CharSequence)FileUtils.getRealFileType(headerType))) {
                log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5: filename = " + fileName, (Object)(" headType = " + headerType));
                throw new FileVerifyException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5: " + fileName);
            }
        }
    }

    private boolean checkConfigSuffix(String fileName) {
        String[] suffixs;
        String suffix = this.fileManageConfigProperties.getSuffix();
        if (StringUtils.isEmpty((CharSequence)suffix) || suffix.equals("*")) {
            return true;
        }
        String name = fileName.toLowerCase();
        for (String s : suffixs = suffix.split(",")) {
            if (!name.endsWith(s)) continue;
            return true;
        }
        log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u540e\u7f00\u6821\u9a8c,\u53ea\u5141\u8bb8\u4e0a\u4f20:{} \u540e\u7f00\u7684\u6587\u4ef6:{}", (Object)suffix, (Object)fileName);
        return false;
    }
}

