/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.tydic.nicc.common.eums.sensitive.SensitiveEncryptType;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static final HashMap<String, String> FILE_HEADER_TYPES = new HashMap();

    public static File downloadFile(String urlPath, String downloadDir, String fileName) {
        String path = downloadDir + File.separatorChar + fileName;
        return FileUtils.downloadFile(urlPath, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File downloadFile(String urlPath, String fullPath) {
        File file = null;
        try {
            URL url = new URL(urlPath);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setConnectTimeout(5000);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.connect();
            int fileLength = httpURLConnection.getContentLength();
            log.info("\u6587\u4ef6\u4e0b\u8f7d-\u5f00\u59cb:fileSize = ", (Object)(fileLength / 0x100000 + "MB"));
            URLConnection con = url.openConnection();
            BufferedInputStream bin = new BufferedInputStream(httpURLConnection.getInputStream());
            file = new File(fullPath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(file);
            int size = 0;
            int len = 0;
            byte[] buf = new byte[2048];
            while ((size = bin.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, size);
                log.info("\u6587\u4ef6\u4e0b\u8f7d-\u8fdb\u5ea6--> ", (Object)((len += size) * 100 / fileLength));
            }
            bin.close();
            ((OutputStream)out).close();
            log.info("\u6587\u4ef6\u4e0b\u8f7d-\u6210\u529f: filePath = {}", (Object)file.getAbsoluteFile());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return file;
        }
    }

    public static String openFileFromUrl(String urlPath) {
        StringBuffer buffer;
        block17: {
            buffer = new StringBuffer();
            try {
                log.error("\u8bfb\u53d6\u7f51\u7edc\u6587\u4ef6-\u5f00\u59cb\u5efa\u7acb\u8fde\u63a5:urlPath = {}", (Object)urlPath);
                String encoding = "UTF-8";
                URL url = new URL(urlPath);
                URLConnection urlconn = url.openConnection();
                urlconn.connect();
                HttpURLConnection httpconn = (HttpURLConnection)urlconn;
                int HttpResult = httpconn.getResponseCode();
                if (HttpResult != 200) {
                    log.error("\u8bfb\u53d6\u7f51\u7edc\u6587\u4ef6-\u7f51\u7edc\u8fde\u63a5\u5931\u8d25:{},urlPath = {}", (Object)HttpResult, (Object)urlPath);
                    break block17;
                }
                try (InputStreamReader read = new InputStreamReader(urlconn.getInputStream(), encoding);){
                    String txt;
                    BufferedReader bufferedReader = new BufferedReader(read);
                    while ((txt = bufferedReader.readLine()) != null) {
                        buffer.append(txt);
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public static Set<String> readWordFromUrl(String fileUrl, String encrypt, String split) throws Exception {
        HashSet<String> set = new HashSet<String>();
        String encoding = "UTF-8";
        URL url = new URL(fileUrl);
        URLConnection urlConnection = url.openConnection();
        urlConnection.connect();
        HttpURLConnection httpconn = (HttpURLConnection)urlConnection;
        int status = httpconn.getResponseCode();
        String content = "";
        if (status == 200) {
            InputStreamReader read = new InputStreamReader(urlConnection.getInputStream(), encoding);
            Object object = null;
            try {
                String txt;
                set = new HashSet();
                BufferedReader bufferedReader = new BufferedReader(read);
                while ((txt = bufferedReader.readLine()) != null) {
                    txt = txt.trim();
                    if (SensitiveEncryptType.BASE64.matchCode(encrypt)) {
                        txt = NiccCommonUtil.decodeStr(txt).trim();
                    }
                    if (StringUtils.isEmpty((CharSequence)split)) {
                        set.add(txt);
                        continue;
                    }
                    content = content + txt;
                }
            }
            catch (Throwable bufferedReader) {
                object = bufferedReader;
                throw bufferedReader;
            }
            finally {
                if (read != null) {
                    if (object != null) {
                        try {
                            read.close();
                        }
                        catch (Throwable bufferedReader) {
                            ((Throwable)object).addSuppressed(bufferedReader);
                        }
                    } else {
                        read.close();
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)content)) {
                List<String> words = Arrays.asList(content.split(split));
                for (String word : words) {
                    if (SensitiveEncryptType.BASE64.matchCode(encrypt)) {
                        set.add(NiccCommonUtil.decodeStr(word).trim());
                        continue;
                    }
                    set.add(word);
                }
            }
        }
        return set;
    }

    public static boolean isAllowFile(InputStream stream) {
        boolean flag;
        String header = FileUtils.getFileHeader(stream);
        boolean bl = flag = FILE_HEADER_TYPES.get(header) != null;
        if (!flag) {
            log.warn("\u6587\u4ef6\u5934\u6807\u8bc6\u7b26\u975e\u6cd5:{}", (Object)header);
        }
        return flag;
    }

    public static String getRealFileType(String type) {
        return FILE_HEADER_TYPES.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileHeader(InputStream stream) {
        FileInputStream is = (FileInputStream)stream;
        String value = null;
        try {
            byte[] b = new byte[4];
            is.read(b, 0, b.length);
            value = FileUtils.bytesToHexString(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return value;
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder builder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (byte aSrc : src) {
            String hv = Integer.toHexString(aSrc & 0xFF).toUpperCase();
            if (hv.length() < 2) {
                builder.append(0);
            }
            builder.append(hv);
        }
        return builder.toString();
    }

    static {
        FILE_HEADER_TYPES.put("FFD8FF", "jpg");
        FILE_HEADER_TYPES.put("89504E47", "png");
        FILE_HEADER_TYPES.put("47494638", "gif");
        FILE_HEADER_TYPES.put("49492A00", "tif");
        FILE_HEADER_TYPES.put("424D", "bmp");
        FILE_HEADER_TYPES.put("38425053", "psd");
        FILE_HEADER_TYPES.put("7B5C727466", "rtf");
        FILE_HEADER_TYPES.put("3C3F786D6C", "xml");
        FILE_HEADER_TYPES.put("68746D6C3E", "html");
        FILE_HEADER_TYPES.put("44656C69766572792D646174653A", "eml");
        FILE_HEADER_TYPES.put("D0CF11E0", "doc");
        FILE_HEADER_TYPES.put("D0CF11E0", "ppt");
        FILE_HEADER_TYPES.put("D0CF11E0", "xls");
        FILE_HEADER_TYPES.put("5374616E64617264204A", "mdb");
        FILE_HEADER_TYPES.put("252150532D41646F6265", "ps");
        FILE_HEADER_TYPES.put("255044462D312E", "pdf");
        FILE_HEADER_TYPES.put("504B0304", "pptx");
        FILE_HEADER_TYPES.put("504B0304", "docx");
        FILE_HEADER_TYPES.put("504B0304", "xlsx");
        FILE_HEADER_TYPES.put("52617221", "rar");
        FILE_HEADER_TYPES.put("57415645", "wav");
        FILE_HEADER_TYPES.put("41564920", "avi");
        FILE_HEADER_TYPES.put("2E524D46", "rm");
        FILE_HEADER_TYPES.put("000001BA", "mpg");
        FILE_HEADER_TYPES.put("000001B3", "mpg");
        FILE_HEADER_TYPES.put("6D6F6F76", "mov");
        FILE_HEADER_TYPES.put("3026B2758E66CF11", "asf");
        FILE_HEADER_TYPES.put("4D546864", "mid");
        FILE_HEADER_TYPES.put("1F8B08", "gz");
    }
}

