/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.im.core.LastMessageRspBO;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.eums.CardMessageType;
import com.tydic.nicc.common.eums.event.EventCodeDefine;
import com.tydic.nicc.common.eums.im.ImMsgType;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.common.eums.im.MsgEventType;
import com.tydic.nicc.common.eums.im.MsgFormType;
import com.tydic.nicc.common.eums.im.MsgFromInType;
import com.tydic.nicc.common.msg.CardMessageInfo;
import com.tydic.nicc.common.msg.ImAlertMessageBody;
import com.tydic.nicc.common.msg.ImEventMessageBody;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImMessageCommon;
import com.tydic.nicc.common.msg.ImReceiptMessageBody;
import com.tydic.nicc.common.msg.ImSysMessageBody;
import com.tydic.nicc.common.msg.ImUserMessageBody;
import com.tydic.nicc.common.msg.event.EventCsStateChange;
import com.tydic.nicc.common.msg.event.EventMsgContent;
import com.tydic.nicc.common.msg.event.EventMsgRead;
import com.tydic.nicc.common.msg.event.EventSessionClose;
import com.tydic.nicc.common.msg.event.EventUserStateChange;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.exception.ImMsgParseException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ImMessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(ImMessageBuilder.class);

    public static ImMessage buildUserStatusNoticeMessage(String chatType, String fromNo, String toNo, String status) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.EVENT.getCode());
        message.setChatType(chatType);
        message.setFromNo(fromNo);
        message.setToNo(toNo);
        ImEventMessageBody sysMessageBody = new ImEventMessageBody();
        sysMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        sysMessageBody.setEventType(EventCodeDefine.USER_STATE_CHANGE.getCode());
        ArrayList<EventUserStateChange> userStateChanges = new ArrayList<EventUserStateChange>();
        userStateChanges.add(new EventUserStateChange(fromNo, status));
        EventMsgContent eventMsgContent = new EventMsgContent();
        eventMsgContent.setUserStateChanges(userStateChanges);
        sysMessageBody.setEventContent(eventMsgContent);
        message.setMsgBody((ImMessageBody)sysMessageBody);
        return message;
    }

    public static ImMessage buildCsStatusNoticeMessage(String chatType, String fromNo, String toNo, String status) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.EVENT.getCode());
        message.setChatType(chatType);
        message.setFromNo(fromNo);
        message.setToNo(toNo);
        ImEventMessageBody sysMessageBody = new ImEventMessageBody();
        sysMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        sysMessageBody.setEventType(EventCodeDefine.CS_STATE_CHANGE.getCode());
        EventCsStateChange eventMsgContent = new EventCsStateChange();
        eventMsgContent.setCsStateChange(new EventCsStateChange(fromNo, status));
        sysMessageBody.setEventContent((EventMsgContent)eventMsgContent);
        message.setMsgBody((ImMessageBody)sysMessageBody);
        return message;
    }

    public static ImMessage buildUserMediaMessage(String chatType, String fromNo, String toNo, String content) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.USER.getCode(), chatType);
        message.setFromNo(fromNo);
        message.setToNo(toNo);
        ImUserMessageBody messageBody = new ImUserMessageBody(MsgFormType.MEDIA_MSG.getCode(), content);
        message.setMsgBody((ImMessageBody)messageBody);
        return message;
    }

    public static ImMessage buildEventMessage(String chatType, String fromNo, String toNo, EventCodeDefine eventCode, EventMsgContent eventMsgContent) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.EVENT.getCode());
        message.setChatType(chatType);
        message.setFromNo(fromNo);
        message.setToNo(toNo);
        ImEventMessageBody sysMessageBody = new ImEventMessageBody();
        sysMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        sysMessageBody.setEventType(eventCode.getCode());
        sysMessageBody.setEventContent(eventMsgContent);
        message.setMsgBody((ImMessageBody)sysMessageBody);
        return message;
    }

    public static ImMessage buildSessionCloseMessage(String chatType, String fromNo, String toNo, EventSessionClose sessionClose) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.EVENT.getCode());
        message.setChatType(chatType);
        message.setFromNo(fromNo);
        message.setToNo(toNo);
        EventMsgContent eventMsgContent = new EventMsgContent();
        eventMsgContent.setSessionClose(sessionClose);
        ImEventMessageBody sysMessageBody = new ImEventMessageBody();
        sysMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        sysMessageBody.setEventType(EventCodeDefine.SESSION_CLOSE.getCode());
        sysMessageBody.setEventContent(eventMsgContent);
        message.setMsgBody((ImMessageBody)sysMessageBody);
        return message;
    }

    public static ImMessage buildNoWorkingTimeMessage(String tenantCode, String toNo, String alterContent) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.AUTO_REPLY.getCode());
        message.setTenantCode(tenantCode);
        message.setToNo(toNo);
        String fromNo = ImCoreConstants.getSystemUser((String)tenantCode);
        message.setFromNo(fromNo);
        CardMessageInfo cardMessageInfo = new CardMessageInfo(CardMessageType.LEAVE_MESSAGE, alterContent);
        ImUserMessageBody userMessageBody = new ImUserMessageBody(MsgFormType.CARD_MSG.getCode(), JSONObject.toJSONString((Object)cardMessageInfo));
        message.setMsgBody((ImMessageBody)userMessageBody);
        return message;
    }

    public static String buildFromSimpleTemplate(String fromNo, String toNo, String msgBody, String template) {
        String msg = template.replace("#MSG_ID", IdWorker.nextAutoIdStr()).replace("#MSG_TIME", String.valueOf(System.currentTimeMillis())).replace("#FROM_NO", fromNo).replace("#TO_NO", toNo);
        if (StringUtils.isNotEmpty((CharSequence)msgBody)) {
            msg.replace("#MSG_BODY", msgBody);
        }
        log.info("\u4ece\u6a21\u677f\u6784\u9020\u6d88\u606f: buildFromSimpleTemplate message = {}", (Object)msg);
        return msg;
    }

    public static ImMessage buildLastUserMessage(LastMessageRspBO lastMessageRspBO, String sessionId) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.USER.getCode());
        message.setMsgTime(Long.valueOf(lastMessageRspBO.getMsgTime().getTime()));
        message.setMsgId(lastMessageRspBO.getMsgId());
        message.setFromNo(lastMessageRspBO.getFromNo());
        message.setFromInType("0");
        message.setToNo(lastMessageRspBO.getFromNo());
        message.setChatType(lastMessageRspBO.getChatType());
        message.setSessionId(sessionId);
        try {
            ImUserMessageBody userMessageBody = new ImUserMessageBody();
            userMessageBody.setMsgForm(lastMessageRspBO.getMsgForm());
            userMessageBody.setMsgContent(lastMessageRspBO.getMsgContent());
            message.setMsgBody((ImMessageBody)userMessageBody);
            return message;
        }
        catch (JSONException e) {
            log.error("\u7528\u6237\u6d88\u606f\u6784\u5efa\u9519\u8bef:", (Throwable)e);
            return message;
        }
    }

    public static ImMessage buildUserMessage(ImMessage from, String chatType, String code, String status) {
        ImMessage receipt = ImMessageBuilder.buildBlankMessage(ImMsgType.USER.getCode());
        receipt.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        receipt.setMsgId(IdWorker.nextAutoIdStr());
        receipt.setFromNo(from.getToNo());
        receipt.setToNo(from.getFromNo());
        receipt.setChatType(chatType);
        receipt.setSessionId(from.getSessionId());
        ImReceiptMessageBody receiptMessageBody = (ImReceiptMessageBody)receipt.getMsgBody();
        receiptMessageBody.setCode(code);
        receiptMessageBody.setStatus(status);
        receipt.setMsgBody((ImMessageBody)receiptMessageBody);
        return receipt;
    }

    public static ImMessage buildUserMessage(String from, String to) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.USER.getCode());
        message.setFromNo(from);
        message.setToNo(to);
        return message;
    }

    public static ImMessage buildAutoReplyMessage(String from, String to) {
        ImMessage message = ImMessageBuilder.buildBlankMessage(ImMsgType.AUTO_REPLY.getCode());
        message.setFromNo(from);
        message.setToNo(to);
        return message;
    }

    public static ImMessage buildReceiptMessage(ImMessage from, String imMsgId, String code, String status) {
        ImMessage receipt = ImMessageBuilder.buildBlankMessage(ImMsgType.RECEIPT.getCode());
        receipt.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        receipt.setMsgId(from.getMsgId());
        receipt.setFromNo(from.getToNo());
        receipt.setToNo(from.getFromNo());
        receipt.setChatType(from.getChatType());
        receipt.setSessionId(from.getSessionId());
        ImReceiptMessageBody receiptMessageBody = (ImReceiptMessageBody)receipt.getMsgBody();
        receiptMessageBody.setCode(code);
        receiptMessageBody.setStatus(status);
        receiptMessageBody.setMsgId(imMsgId);
        receipt.setMsgBody((ImMessageBody)receiptMessageBody);
        return receipt;
    }

    public static ImMessage buildEventMessageReadByReceiptMsg(ImMessage from) {
        ImMessage event = ImMessageBuilder.buildBlankMessage(ImMsgType.EVENT.getCode());
        event.setTenantCode(from.getTenantCode());
        event.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        event.setMsgId(IdWorker.nextAutoIdStr());
        event.setFromNo(from.getFromNo());
        event.setToNo(from.getToNo());
        event.setChatType(from.getChatType());
        event.setSessionId(from.getSessionId());
        ImEventMessageBody eventMessageBody = (ImEventMessageBody)event.getMsgBody();
        eventMessageBody.setEventType(MsgEventType.MSG_READ.getCode());
        eventMessageBody.setEventTime(Long.valueOf(System.currentTimeMillis()));
        eventMessageBody.setEventContent(new EventMsgContent());
        EventMsgRead msgRead = new EventMsgRead();
        msgRead.setMsgId(from.getMsgId());
        msgRead.setTimestamp(from.getMsgTime());
        msgRead.setUserId(from.getFromNo());
        eventMessageBody.getEventContent().setMsgRead(msgRead);
        return event;
    }

    public static ImMessage buildBlankMessage(String msgType) {
        return ImMessageBuilder.buildBlankMessage(msgType, MsgChatType.C2B.getCode());
    }

    public static ImMessage buildBlankMessage(String msgType, String chatType) {
        ImMessage imMessage = new ImMessage();
        imMessage.setMsgId(IdWorker.nextAutoIdStr());
        imMessage.setMsgTime(Long.valueOf(System.currentTimeMillis()));
        imMessage.setMsgType(msgType);
        imMessage.setChatType(chatType);
        ImUserMessageBody messageBody = null;
        if (ImMsgType.USER.getCode().equals(msgType)) {
            messageBody = new ImUserMessageBody();
        }
        if (ImMsgType.ALERT.getCode().equals(msgType)) {
            messageBody = new ImAlertMessageBody();
        }
        if (ImMsgType.EVENT.getCode().equals(msgType)) {
            messageBody = new ImEventMessageBody();
        }
        if (ImMsgType.SYSTEM.getCode().equals(msgType)) {
            messageBody = new ImSysMessageBody();
        }
        if (ImMsgType.RECEIPT.getCode().equals(msgType)) {
            messageBody = new ImReceiptMessageBody();
        }
        imMessage.setFromInType(MsgFromInType.PC.getCode());
        imMessage.setMsgBody((ImMessageBody)messageBody);
        return imMessage;
    }

    public static ImMessage convertToObject(String msg) {
        ImMessageCommon msgCommon = (ImMessageCommon)JSONObject.parseObject((String)msg, ImMessageCommon.class);
        ImMessage imMessage = new ImMessage();
        BeanUtils.copyProperties((Object)msgCommon, (Object)imMessage);
        ImMessageBody messageBody = null;
        if (ImMsgType.ALERT.getCode().equals(msgCommon.getMsgType())) {
            messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImAlertMessageBody.class);
        }
        if (ImMsgType.EVENT.getCode().equals(msgCommon.getMsgType())) {
            messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImEventMessageBody.class);
        }
        if (ImMsgType.SYSTEM.getCode().equals(msgCommon.getMsgType())) {
            messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImSysMessageBody.class);
        }
        if (ImMsgType.RECEIPT.getCode().equals(msgCommon.getMsgType())) {
            messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImReceiptMessageBody.class);
        }
        if (ImMsgType.USER.getCode().equals(msgCommon.getMsgType()) || ImMsgType.AUTO_REPLY.getCode().equals(msgCommon.getMsgType())) {
            messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImUserMessageBody.class);
        }
        imMessage.setMsgBody(messageBody);
        return imMessage;
    }

    public static ImMessage MessageParse(String msg) {
        try {
            ImMessage imMessage = new ImMessage();
            ImMessageCommon msgCommon = (ImMessageCommon)JSONObject.parseObject((String)msg, ImMessageCommon.class);
            if (msgCommon != null) {
                if (StringUtils.isEmpty((CharSequence)ImMsgType.getNameByCode((String)msgCommon.getMsgType()))) {
                    throw new ImMsgParseException("\u6d88\u606f\u7c7b\u578b\u9519\u8bef:msgType = " + msgCommon.getMsgType());
                }
                if (StringUtils.isEmpty((CharSequence)MsgFromInType.getNameByCode((String)msgCommon.getFromInType()))) {
                    throw new ImMsgParseException("\u6d88\u606f\u63a5\u5165\u65b9\u5f0f\u9519\u8bef:fromInType = " + msgCommon.getFromInType());
                }
                if (StringUtils.isEmpty((CharSequence)MsgChatType.getNameByCode((String)msgCommon.getChatType()))) {
                    throw new ImMsgParseException("\u804a\u5929\u7c7b\u578b\u9519\u8bef:chatType = " + msgCommon.getChatType());
                }
                if (msgCommon.getMsgTime() == null) {
                    msgCommon.setMsgTime(Long.valueOf(System.currentTimeMillis()));
                }
                if (msgCommon.getFromNo() == null) {
                    throw new ImMsgParseException("\u5b57\u6bb5 fromNo \u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)msgCommon.getMsgId())) {
                    msgCommon.setMsgId(IdWorker.nextAutoIdStr());
                }
                if (StringUtils.isEmpty((CharSequence)msgCommon.getToNo())) {
                    throw new ImMsgParseException("\u5b57\u6bb5 toNo \u4e3a\u7a7a!");
                }
                if (msgCommon.getMsgBody() == null) {
                    throw new ImMsgParseException("\u5b57\u6bb5 msgBody \u4e3a\u7a7a!");
                }
                ImMessageBody messageBody = null;
                try {
                    if (ImMsgType.ALERT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImAlertMessageBody.class);
                    }
                    if (ImMsgType.EVENT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImEventMessageBody.class);
                    }
                    if (ImMsgType.SYSTEM.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImSysMessageBody.class);
                    }
                    if (ImMsgType.RECEIPT.getCode().equals(msgCommon.getMsgType())) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImReceiptMessageBody.class);
                    }
                    if (messageBody == null) {
                        messageBody = (ImMessageBody)JSONObject.parseObject((String)msgCommon.getMsgBody(), ImUserMessageBody.class);
                    }
                    imMessage.setTenantCode(msgCommon.getTenantCode());
                    imMessage.setMsgId(msgCommon.getMsgId());
                    imMessage.setSessionId(msgCommon.getSessionId());
                    imMessage.setMsgType(msgCommon.getMsgType());
                    imMessage.setChatType(msgCommon.getChatType());
                    imMessage.setFromNo(msgCommon.getFromNo());
                    imMessage.setFromInType(msgCommon.getFromInType());
                    imMessage.setMsgTime(Long.valueOf(System.currentTimeMillis()));
                    imMessage.setToNo(msgCommon.getToNo());
                    imMessage.setMsgBody(messageBody);
                }
                catch (JSONException e) {
                    throw new ImMsgParseException("\u6d88\u606f\u4f53\u89e3\u6790\u9519\u8bef:" + e.getMessage());
                }
                if (messageBody == null) {
                    throw new ImMsgParseException("\u6d88\u606f\u4f53\u4e0d\u5f97\u4e3a\u7a7a!");
                }
                return imMessage;
            }
            throw new ImMsgParseException("\u6d88\u606f\u4e0d\u5f97\u4e3a\u7a7a!");
        }
        catch (JSONException e) {
            log.info("\u6d88\u606f\u89e3\u6790\u5931\u8d25:{}", (Object)e.getMessage());
            throw new ImMsgParseException("\u6d88\u606f\u89e3\u6790\u5931\u8d25:" + e.getMessage());
        }
    }
}

