/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.LuaScriptLoader;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class ImMessageLuaCacheHelper {
    private static final Logger log = LoggerFactory.getLogger(ImMessageLuaCacheHelper.class);
    public static String MSG_APPEND_SCRIPT = "";
    public static String MSG_DEL_SCRIPT = "";
    public static String MSG_READ_SCRIPT = "";
    public static String MSG_UNREAD_COUNT_SCRIPT = "";
    public static String MSG_LIST_SCRIPT = "";
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private LuaScriptLoader luaScriptLoader;

    @PostConstruct
    public void init() {
        MSG_APPEND_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_append.lua");
        MSG_DEL_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_del.lua");
        MSG_READ_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_read.lua");
        MSG_UNREAD_COUNT_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_unread_count.lua");
        MSG_LIST_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_list.lua");
    }

    public String listMessage(String key) {
        return this.execLuaScript(MSG_LIST_SCRIPT, Collections.singletonList(key), new Object[0]);
    }

    public String appendMessage(String key, Object message, String tenantCode) {
        return this.execLuaScript(MSG_APPEND_SCRIPT, Collections.singletonList(key), JSONObject.toJSONString((Object)message), tenantCode);
    }

    public String removeHaveReadMessage(String key) {
        return this.execLuaScript(MSG_DEL_SCRIPT, Collections.singletonList(key), new Object[0]);
    }

    public String updateMessageRead(String key, String tenantCode, String userId, Long msgTime) {
        return this.execLuaScript(MSG_READ_SCRIPT, Collections.singletonList(key), tenantCode, userId, String.valueOf(msgTime));
    }

    public int countUnread(String chatKey, String tenantCode, String userId, String chatObj, String chatModel) {
        String key = "";
        if ("cs".equals(chatModel)) {
            key = RedisCacheKeyConstant.getImMsgListCacheKey((String)chatKey);
        } else {
            String c2cKey = NiccCommonUtil.getC2cChatKey(userId, chatObj);
            key = RedisCacheKeyConstant.getImMsgListCacheKey((String)c2cKey);
        }
        return this.countUnReadMessage(key, tenantCode, userId, "", "");
    }

    public int countUnReadMessage(String key, String tenantCode, String userId, String exMsgType1, String exMsgType2) {
        int unread = 0;
        try {
            String result = this.execLuaScript(MSG_UNREAD_COUNT_SCRIPT, Collections.singletonList(key), tenantCode, userId, exMsgType1, exMsgType2);
            unread = Integer.valueOf(result);
        }
        catch (Exception e) {
            log.error("\u672a\u8bfb\u6d88\u606f\u7edf\u8ba1\u5f02\u5e38:", (Throwable)e);
        }
        return unread;
    }

    public String execLuaScript(String script, List<String> keys, Object ... params) {
        log.info("\u6267\u884clua\u811a\u672c:{},keys:{},obj:{}", new Object[]{script, keys, params});
        DefaultRedisScript redisScript = new DefaultRedisScript(script, String.class);
        StringRedisSerializer serializer = new StringRedisSerializer();
        return this.redisHelper.execLuaResult((RedisScript)redisScript, serializer, keys, params);
    }
}

