
-- 追加消息+重排序
local key = KEYS[1]
local input = ARGV[1]
local tenant = ARGV[2]
local messages = cjson.decode("[]")
if redis.call("EXISTS", key) == 1 then
    local load = redis.call("GET", key)
    messages = cjson.decode(load)
end
local msg = cjson.decode(input)
-- 插入数据
table.insert(messages, msg)
-- 按消息时间排序
table.sort(messages, function(a, b) return a.msgTime < b.msgTime end)
local res = cjson.encode(messages)
-- 重新写入
redis.call("SET", key, res)
-- 未读消息数+1
if tenant ~= msg.toNo then
    local unreadKey = "im:user:unread-total:"..msg.toNo
    if redis.call("EXISTS", unreadKey) == 1 then
        redis.call("INCR",unreadKey)
    else
        redis.call("SET",unreadKey, "1", "EX", 3600 * 24 )
    end
end
return res