
-- 将消息标记为已读状态
local key = KEYS[1]
local tenant = ARGV[1]
local userId = ARGV[2]
local readTime = ARGV[3]
local readCount = 0
local unreadKey = "im:user:unread-total:"..userId
if redis.call("EXISTS", key) == 1 then
    local load = redis.call("GET", key)
    local messages = cjson.decode(load)
    for i, msg in ipairs(messages) do
        -- 处理发给我的消息，标记为已读
        if msg.toNo == userId and msg.msgTime <= tonumber(readTime) and msg.readStatus == "0" then
            msg.readStatus = "1"
            readCount = readCount + 1
            local res = redis.call("DECR",unreadKey)
            if tonumber(res) < 0 then
                redis.call("SET",unreadKey,"0","EX", 3600 * 24)
            end
        end
        -- 处理特殊情情况 如 用户发给租户的消息(假设当前为客服已读事件)
        if msg.userType == 1 and msg.toNo == tenant and msg.userId ~= userId and
                msg.msgTime <= tonumber(readTime) and msg.readStatus == "0" then
            msg.readStatus = "1"
            readCount = readCount + 1
        end
    end
    -- 重新写入
    if readCount > 0 then
        redis.call("SET", key, cjson.encode(messages))
    end
end
return tostring(readCount)
