
-- 统计未读消息
local key = KEYS[1]
local tenant = ARGV[1]
local userId = ARGV[2]
local exMsgType1 = ARGV[3]
local exMsgType2 = ARGV[4]

local unread = 0
if redis.call("EXISTS", key) == 1 then
    local load = redis.call("GET", key)
    local messages = cjson.decode(load)
    for i, msg in ipairs(messages) do
        repeat
            if(msg.msgForm == 15) then
                break
            end
            if(exMsgType1 ~= nil and exMsgType1 == msg.msgType) then
                break
            end
            if(exMsgType2 ~= nil and exMsgType2 == msg.msgType) then
                break
            end
            if msg.toNo == userId and msg.readStatus == "0" then
                unread = unread + 1
            end
            -- 处理特殊情情况 如 用户发给租户的消息(假设当前为客服已读事件)
            if msg.userType == 1 and msg.toNo == tenant and msg.userId ~= userId and msg.readStatus == "0" then
                unread = unread + 1
            end
        until true
    end
end
return tostring(unread)
