/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.file.FileManageSaveBO;
import com.tydic.nicc.common.eums.FileUploadType;
import com.tydic.nicc.dc.base.bo.mino.MultipartUploadCompleteRequest;
import com.tydic.nicc.dc.base.bo.mino.MultipartUploadCreateRequest;
import com.tydic.nicc.dc.base.bo.mino.MultipartUploadCreateResponse;
import com.tydic.nicc.dc.boot.starter.aws_s3.AwsS3Helper;
import com.tydic.nicc.dc.boot.starter.cos.CosHelper;
import com.tydic.nicc.dc.boot.starter.fastdfs.FastdfsHelper;
import com.tydic.nicc.dc.boot.starter.ftp.SFTPHelper;
import com.tydic.nicc.dc.boot.starter.minio.MinioHelper;
import com.tydic.nicc.dc.boot.starter.obs.ObsHelper;
import com.tydic.nicc.dc.boot.starter.oss.OssHelper;
import com.tydic.nicc.framework.config.FileManageConfigPropertiesBean;
import com.tydic.nicc.framework.exception.FileVerifyException;
import com.tydic.nicc.framework.utils.FileUtils;
import com.tydic.nicc.framework.utils.ImageUtils;
import com.tydic.nicc.framework.utils.MultipartFileUtil;
import com.ykrenz.fastdfs.model.fdfs.StorePath;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Component
public class FileManagerHelper {
    private static final Logger log = LoggerFactory.getLogger(FileManagerHelper.class);
    @Autowired
    private ApplicationContext context;
    @Autowired(required=false)
    private OssHelper ossHelper;
    @Autowired(required=false)
    private SFTPHelper sftpHelper;
    @Autowired(required=false)
    private ObsHelper obsHelper;
    @Autowired(required=false)
    private FastdfsHelper fastdfsHelper;
    @Autowired(required=false)
    private MinioHelper minioHelper;
    @Autowired(required=false)
    private CosHelper cosHelper;
    @Autowired(required=false)
    private AwsS3Helper awsS3Helper;
    @Resource
    private FileManageConfigPropertiesBean fileManageConfigProperties;

    public FileManageConfigPropertiesBean getFileConfig() {
        return this.fileManageConfigProperties;
    }

    public static MultipartFile parseToMultipartFile(String fileName, byte[] data) {
        DiskFileItem item = new DiskFileItem("files", "multipart/form-data", true, fileName, data.length, null);
        try {
            OutputStream os = item.getOutputStream();
            os.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile((FileItem)item);
    }

    public static MultipartFile parseToMultipartFile(File file) {
        DiskFileItem item = new DiskFileItem("files", "multipart/form-data", true, file.getName(), (int)file.length(), file.getParentFile());
        try {
            OutputStream os = item.getOutputStream();
            os.write(com.alibaba.excel.util.FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new CommonsMultipartFile((FileItem)item);
    }

    public List<FileManageSaveBO> saveFile(File file, String month) throws Exception {
        MultipartFile multipartFile = MultipartFileUtil.toMultipartFile(file);
        MultipartFile[] files = new MultipartFile[]{multipartFile};
        return this.saveFiles(files, month, true);
    }

    public List<FileManageSaveBO> saveFiles(MultipartFile[] files, String month) throws Exception {
        return this.saveFiles(files, month, true);
    }

    public List<FileManageSaveBO> saveFiles(MultipartFile[] files, String month, boolean compress) throws Exception {
        File upDir;
        if (this.fileManageConfigProperties == null) {
            log.error("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u5f02\u5e38:\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u914d\u7f6e!");
            return new ArrayList<FileManageSaveBO>();
        }
        ArrayList fileSaveBOS = Lists.newArrayList();
        String uploadPath = "";
        if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType()) && !(upDir = new File(uploadPath = this.fileManageConfigProperties.getLocalPath() + month)).exists()) {
            upDir.mkdirs();
        }
        if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.sftpHelper = (SFTPHelper)this.context.getBean(SFTPHelper.class);
            this.sftpHelper.mkdir(month);
        }
        for (MultipartFile file : files) {
            this.checkFileAllowed(file);
            String fileNo = this.fileManageConfigProperties.createFileNo();
            String fileName = file.getOriginalFilename();
            String fileType = fileName.substring(fileName.lastIndexOf("."));
            String absFilePath = uploadPath + File.separator + fileNo + fileType;
            String newFileName = fileNo + fileType;
            String relFilePath = month + File.separator + newFileName;
            FileManageSaveBO saveBO = new FileManageSaveBO();
            saveBO.setFileType(fileType);
            saveBO.setFileNo(fileNo);
            saveBO.setFileName(fileName);
            saveBO.setFilePath(relFilePath);
            saveBO.setAccessUrl(this.fileManageConfigProperties.getAccessUrlPrefix() + relFilePath);
            saveBO.setUploadType(this.fileManageConfigProperties.getUploadType());
            InputStream inputStream = file.getInputStream();
            long fileSize = file.getSize();
            if (compress && this.fileManageConfigProperties.getImageCompress().isCompress(file)) {
                byte[] resultByte = ImageUtils.compressPicForScale(file.getBytes(), this.fileManageConfigProperties.getImageCompress().getDestSize());
                inputStream = new ByteArrayInputStream(resultByte);
                fileSize = resultByte.length;
            }
            saveBO.setFileSize(Integer.valueOf(Math.toIntExact(fileSize)));
            if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u5230\u672c\u5730: fileName = {},path = {},size = {}", new Object[]{fileName, absFilePath, file.getSize()});
                if (compress && this.fileManageConfigProperties.getImageCompress().isCompress(file)) {
                    FileCopyUtils.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(absFilePath));
                } else {
                    file.transferTo(new File(absFilePath));
                }
            }
            if (FileUploadType.MINIO.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230minio: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.minioHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.OSS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230oss: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.ossHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.OBS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230obs: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.obsHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.COS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230cos: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.cosHelper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.AWS_S3.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230s3: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                this.awsS3Helper.upload(relFilePath, inputStream);
            }
            if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230ftp: fileName = {},path = {},size = {}", (Object)fileName, (Object)relFilePath);
                boolean upload = this.sftpHelper.uploadFile(inputStream, relFilePath);
                if (!upload) {
                    log.error("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230sftp\u5931\u8d25: relPath = {}", (Object)relFilePath);
                }
                this.sftpHelper.close();
            }
            if (FileUploadType.FDFS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5230fastdfs: fileName = {},path = {},size = {}", new Object[]{fileName, relFilePath, file.getSize()});
                StorePath storePath = this.fastdfsHelper.upload(file.getInputStream(), file.getSize(), fileType);
                saveBO.setFilePath(storePath.getPath());
                String accessUrl = this.fastdfsHelper.getAccessUrl(storePath.getPath());
                saveBO.setAccessUrl(accessUrl);
            }
            fileSaveBOS.add(saveBO);
        }
        log.info("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4fdd\u5b58\u6210\u529f:{}", (Object)fileSaveBOS);
        return fileSaveBOS;
    }

    public MultipartUploadCreateResponse createMultipartUpload(MultipartUploadCreateRequest request) {
        MultipartUploadCreateResponse response = null;
        if (StringUtils.isBlank((CharSequence)request.getAccessUrlPrefix())) {
            request.setAccessUrlPrefix(this.getFileConfig().getAccessUrlPrefix());
        }
        if (FileUploadType.MINIO.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            try {
                response = this.minioHelper.createMultipartUpload(request);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return response;
        }
        throw new RuntimeException("\u5206\u7247\u4e0a\u4f20-\u521b\u5efa\u4efb\u52a1-\u5f02\u5e38\uff1a\u5f53\u524d\u4ec5\u652f\u6301mino!");
    }

    public boolean completeMultipartUpload(MultipartUploadCompleteRequest request) {
        Assert.isNull((Object)request.getObjectName(), (String)"\u6587\u4ef6\u5bf9\u8c61\u4e0d\u5f97\u4e3a\u7a7a!");
        Assert.isNull((Object)request.getUploadId(), (String)"\u6587\u4ef6uploadId\u4e0d\u5f97\u4e3a\u7a7a!");
        if (FileUploadType.MINIO.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            return this.minioHelper.completeMultipartUpload(request.getObjectName(), request.getUploadId());
        }
        throw new RuntimeException("\u5206\u7247\u4e0a\u4f20-\u5408\u5e76\u4efb\u52a1-\u5f02\u5e38\uff1a\u5f53\u524d\u4ec5\u652f\u6301mino!");
    }

    public InputStream downloadFile(String fileName) {
        InputStream is = null;
        try {
            if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                try {
                    is = new FileInputStream(fileName);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (FileUploadType.MINIO.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.minioHelper.downloadFile(fileName);
            }
            if (FileUploadType.OSS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.ossHelper.downloadFile(fileName);
            }
            if (FileUploadType.OBS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.obsHelper.download(fileName).getObjectContent();
            }
            if (FileUploadType.COS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.cosHelper.download(fileName);
            }
            if (FileUploadType.AWS_S3.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.awsS3Helper.download(fileName);
            }
            if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.sftpHelper.downloadFile(fileName);
            }
            if (FileUploadType.FDFS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
                is = this.fastdfsHelper.downloadFile(fileName);
            }
            return is;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String filePath) throws Exception {
        File file;
        if (FileUploadType.LOCAL.getCode().equals(this.fileManageConfigProperties.getUploadType()) && (file = new File(filePath)).exists()) {
            file.delete();
        }
        if (FileUploadType.MINIO.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.minioHelper.delete(filePath);
        }
        if (FileUploadType.OSS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.ossHelper.deleteFile(filePath);
        }
        if (FileUploadType.OBS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.obsHelper.delete(filePath);
        }
        if (FileUploadType.COS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.cosHelper.delete(filePath);
        }
        if (FileUploadType.AWS_S3.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.awsS3Helper.delete(filePath);
        }
        if (FileUploadType.SFTP.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.sftpHelper.deleteFile(filePath);
        }
        if (FileUploadType.FDFS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.fastdfsHelper.deleteFile(filePath);
        }
        if (FileUploadType.FDFS.getCode().equals(this.fileManageConfigProperties.getUploadType())) {
            this.fastdfsHelper.deleteFile(filePath);
        }
    }

    public void checkFileAllowed(MultipartFile file) throws IOException {
        String headerType;
        String fileName = file.getOriginalFilename();
        if (!this.checkConfigSuffix(fileName)) {
            log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25: filename = " + fileName);
            throw new FileVerifyException(this.fileManageConfigProperties.getErrorFileMsg());
        }
        if (ImageUtils.checkImageSuffix(fileName)) {
            if (!ImageUtils.isImage(file)) {
                log.warn("\u6587\u4ef6\u4e0a\u4f20-\u56fe\u7247\u4e0a\u4f20\u5931\u8d25: filename = " + fileName);
                throw new FileVerifyException(this.fileManageConfigProperties.getErrorImgMsg());
            }
        } else if (this.fileManageConfigProperties.getFileCheckEnable().booleanValue() && StringUtils.isBlank((CharSequence)FileUtils.getRealFileType(headerType = FileUtils.getFileHeader(file.getInputStream())))) {
            log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5: filename = " + fileName + " headType = " + headerType);
            throw new FileVerifyException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5: " + fileName);
        }
    }

    public boolean checkConfigSuffix(String fileName) {
        String[] suffixs;
        String suffix = this.fileManageConfigProperties.getSuffix();
        if (StringUtils.isEmpty((CharSequence)suffix) || suffix.equals("*")) {
            return true;
        }
        String name = fileName.toLowerCase();
        for (String s : suffixs = suffix.split(",")) {
            if (!name.endsWith(s)) continue;
            return true;
        }
        log.warn("\u6587\u4ef6\u4e0a\u4f20-\u6587\u4ef6\u540e\u7f00\u6821\u9a8c,\u53ea\u5141\u8bb8\u4e0a\u4f20:{} \u540e\u7f00\u7684\u6587\u4ef6:{}", (Object)suffix, (Object)fileName);
        return false;
    }
}

