/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONObject;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
extends DefaultHttpClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientHelper.class);

    public static DefaultHttpClient getHttpClient(int connectTimout, int readTimout) {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)connectTimout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)readTimout);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
        return client;
    }

    public HttpClientHelper() throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLS");
        X509TrustManager tm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        ctx.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory ssf = new SSLSocketFactory(ctx, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        ClientConnectionManager ccm = this.getConnectionManager();
        SchemeRegistry sr = ccm.getSchemeRegistry();
        sr.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int readTimout) {
        return HttpClientHelper.doPost(url, headers, body, 1000, readTimout);
    }

    public static String doPost(String url, Map<String, String> headers, Object body) {
        return HttpClientHelper.doPost(url, headers, body, 1000, 10000);
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int connectTimout, int readTimout) {
        return HttpClientHelper.doPost(url, headers, body, connectTimout, readTimout, false);
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int connectTimout, int readTimout, boolean printLog) {
        String charset = "utf-8";
        DefaultHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String entity = "";
        try {
            HttpEntity resEntity;
            HttpResponse response;
            httpClient = HttpClientHelper.getHttpClient(connectTimout, readTimout);
            httpPost = new HttpPost(url);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Accept-Encoding", "UTF-8");
            httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
            if (headers != null) {
                for (Map.Entry<String, String> stringEntry : headers.entrySet()) {
                    httpPost.setHeader(stringEntry.getKey(), stringEntry.getValue());
                }
            }
            if (body != null) {
                entity = body instanceof String ? body.toString() : JSONObject.toJSONString((Object)body);
                StringEntity postEntity = new StringEntity(entity, "UTF-8");
                httpPost.setEntity((HttpEntity)postEntity);
            }
            if (printLog) {
                log.info("POST\u8bf7\u6c42:{}|{}|{}", new Object[]{url, headers, entity});
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception e) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38:{}|{}|{}", new Object[]{url, headers, entity, e});
        }
        if (printLog) {
            log.info("POST\u8bf7\u6c42\u7ed3\u679c:{}|{}|{}", new Object[]{url, headers, result});
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> headers, int readTimout) {
        return HttpClientHelper.doGet(url, headers, 1000, readTimout);
    }

    public static String doGet(String url, Map<String, String> headers) {
        return HttpClientHelper.doGet(url, headers, 1000, 10000);
    }

    public static String doGet(String url, Map<String, String> headers, int connectTimout, int readTimout) {
        String charset = "utf-8";
        DefaultHttpClient httpClient = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpClientHelper.getHttpClient(connectTimout, readTimout);
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                for (Map.Entry<String, String> stringEntry : headers.entrySet()) {
                    httpGet.setHeader(stringEntry.getKey(), stringEntry.getValue());
                }
            }
            log.info("GET\u8bf7\u6c42:{}|{}", (Object)url, headers);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception var8) {
            log.error("GET\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)var8);
        }
        return result;
    }
}

