/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class LuaScriptLoader {
    private static final Logger log = LoggerFactory.getLogger(LuaScriptLoader.class);
    private final ResourceLoader resourceLoader;
    private final RedisHelper redisHelper;

    public LuaScriptLoader(ResourceLoader resourceLoader, @Autowired(required=false) RedisHelper redisHelper) {
        this.resourceLoader = resourceLoader;
        this.redisHelper = redisHelper;
    }

    public Long getWorkId(String key) {
        String script = "local isExist = redis.call('exists', KEYS[1])\nif isExist == 1 then\n    local workerId = redis.call('get', KEYS[1])\n    workerId = (workerId + 1) % 32\n    redis.call('set', KEYS[1], workerId)\n    return tostring(workerId)\nelse\n    redis.call('set', KEYS[1], 0)\n    return tostring(0)\nend";
        Long workId = 0L;
        try {
            DefaultRedisScript redisScript = new DefaultRedisScript(script, String.class);
            StringRedisSerializer serializer = new StringRedisSerializer();
            String res = this.redisHelper.execLuaResult((RedisScript)redisScript, serializer, Collections.singletonList(key), new Object[0]);
            workId = Long.valueOf(res);
            log.info("\u83b7\u53d6workId:{}|{}", (Object)key, (Object)workId);
        }
        catch (Exception e) {
            workId = RandomUtils.nextLong((long)0L, (long)32L);
            log.error("\u83b7\u53d6workId-\u5f02\u5e38,\u968f\u673a\u751f\u6210:{}", (Object)workId, (Object)e);
        }
        return workId;
    }

    public String readLuaScriptContent(String scriptName) {
        Resource resource = this.resourceLoader.getResource("classpath:lua_script/" + scriptName);
        InputStream is = null;
        String content = "";
        try {
            is = resource.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String data = null;
            while ((data = br.readLine()) != null) {
                content = content + data + "\r\n";
            }
            br.close();
            isr.close();
            is.close();
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7dlua\u811a\u672c-\u8bfb\u53d6\u5f02\u5e38:{}", (Object)scriptName, (Object)e);
        }
        if (log.isTraceEnabled()) {
            log.info("\u52a0\u8f7dlua\u811a\u672c:{}", (Object)content);
        }
        return content;
    }
}

