/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.config;

import com.google.common.collect.Lists;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.config.ImageCompressProperties;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
@ConfigurationProperties(prefix="upload-file-manage")
public class FileManageConfigPropertiesBean {
    private String tmpPath = "/tmp";
    private String uploadType = "local";
    private String localPath = "/tmp";
    private String accessUrlPrefix = "http://localhost/";
    private Boolean fileIdMask = false;
    private Boolean fileCheckEnable = true;
    private String suffix = "*";
    private String errorFileMsg = "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25,\u6587\u4ef6\u7c7b\u578b\u9519\u8bef!";
    private String errorImgMsg = "\u56fe\u7247\u53d1\u9001\u5931\u8d25,\u7c7b\u578b\u9519\u8bef!";
    private List<String> allowReferers = Lists.newArrayList();
    private List<String> whiteList = Lists.newArrayList();
    private List<String> blackList = Lists.newArrayList();
    private ImageCompressProperties imageCompress;

    public boolean matchWhiteIp(String reqIp) {
        if (!this.whiteList.isEmpty()) {
            for (String whiteIp : this.whiteList) {
                if (!whiteIp.equals("*") && !whiteIp.equals(reqIp)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean matchBlackIp(String reqIp) {
        if (!this.blackList.isEmpty()) {
            for (String blackIp : this.blackList) {
                if (!blackIp.equals(reqIp)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchReferes(String reqRefere) {
        if (!this.allowReferers.isEmpty() && !StringUtils.isEmpty((CharSequence)reqRefere)) {
            for (String allowReferer : this.allowReferers) {
                if (!reqRefere.startsWith(allowReferer)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public String getAccessUrlPrefix() {
        if (!this.accessUrlPrefix.endsWith("/")) {
            return this.accessUrlPrefix + "/";
        }
        return this.accessUrlPrefix;
    }

    public String getTmpPath() {
        if (!this.tmpPath.endsWith("/")) {
            return this.tmpPath + "/";
        }
        return this.tmpPath;
    }

    public String getLocalPath() {
        if (!this.localPath.endsWith("/")) {
            return this.localPath + "/";
        }
        return this.localPath;
    }

    public String createFileNo() {
        String fileNo = IdWorker.nextAutoIdStr();
        if (this.fileIdMask.booleanValue()) {
            return DigestUtils.md5DigestAsHex((byte[])fileNo.getBytes(StandardCharsets.UTF_8));
        }
        return fileNo;
    }

    public String getUploadType() {
        return this.uploadType;
    }

    public Boolean getFileIdMask() {
        return this.fileIdMask;
    }

    public Boolean getFileCheckEnable() {
        return this.fileCheckEnable;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getErrorFileMsg() {
        return this.errorFileMsg;
    }

    public String getErrorImgMsg() {
        return this.errorImgMsg;
    }

    public List<String> getAllowReferers() {
        return this.allowReferers;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public List<String> getBlackList() {
        return this.blackList;
    }

    public ImageCompressProperties getImageCompress() {
        return this.imageCompress;
    }

    public void setTmpPath(String tmpPath) {
        this.tmpPath = tmpPath;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setAccessUrlPrefix(String accessUrlPrefix) {
        this.accessUrlPrefix = accessUrlPrefix;
    }

    public void setFileIdMask(Boolean fileIdMask) {
        this.fileIdMask = fileIdMask;
    }

    public void setFileCheckEnable(Boolean fileCheckEnable) {
        this.fileCheckEnable = fileCheckEnable;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setErrorFileMsg(String errorFileMsg) {
        this.errorFileMsg = errorFileMsg;
    }

    public void setErrorImgMsg(String errorImgMsg) {
        this.errorImgMsg = errorImgMsg;
    }

    public void setAllowReferers(List<String> allowReferers) {
        this.allowReferers = allowReferers;
    }

    public void setWhiteList(List<String> whiteList) {
        this.whiteList = whiteList;
    }

    public void setBlackList(List<String> blackList) {
        this.blackList = blackList;
    }

    public void setImageCompress(ImageCompressProperties imageCompress) {
        this.imageCompress = imageCompress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileManageConfigPropertiesBean)) {
            return false;
        }
        FileManageConfigPropertiesBean other = (FileManageConfigPropertiesBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$fileIdMask = this.getFileIdMask();
        Boolean other$fileIdMask = other.getFileIdMask();
        if (this$fileIdMask == null ? other$fileIdMask != null : !((Object)this$fileIdMask).equals(other$fileIdMask)) {
            return false;
        }
        Boolean this$fileCheckEnable = this.getFileCheckEnable();
        Boolean other$fileCheckEnable = other.getFileCheckEnable();
        if (this$fileCheckEnable == null ? other$fileCheckEnable != null : !((Object)this$fileCheckEnable).equals(other$fileCheckEnable)) {
            return false;
        }
        String this$tmpPath = this.getTmpPath();
        String other$tmpPath = other.getTmpPath();
        if (this$tmpPath == null ? other$tmpPath != null : !this$tmpPath.equals(other$tmpPath)) {
            return false;
        }
        String this$uploadType = this.getUploadType();
        String other$uploadType = other.getUploadType();
        if (this$uploadType == null ? other$uploadType != null : !this$uploadType.equals(other$uploadType)) {
            return false;
        }
        String this$localPath = this.getLocalPath();
        String other$localPath = other.getLocalPath();
        if (this$localPath == null ? other$localPath != null : !this$localPath.equals(other$localPath)) {
            return false;
        }
        String this$accessUrlPrefix = this.getAccessUrlPrefix();
        String other$accessUrlPrefix = other.getAccessUrlPrefix();
        if (this$accessUrlPrefix == null ? other$accessUrlPrefix != null : !this$accessUrlPrefix.equals(other$accessUrlPrefix)) {
            return false;
        }
        String this$suffix = this.getSuffix();
        String other$suffix = other.getSuffix();
        if (this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix)) {
            return false;
        }
        String this$errorFileMsg = this.getErrorFileMsg();
        String other$errorFileMsg = other.getErrorFileMsg();
        if (this$errorFileMsg == null ? other$errorFileMsg != null : !this$errorFileMsg.equals(other$errorFileMsg)) {
            return false;
        }
        String this$errorImgMsg = this.getErrorImgMsg();
        String other$errorImgMsg = other.getErrorImgMsg();
        if (this$errorImgMsg == null ? other$errorImgMsg != null : !this$errorImgMsg.equals(other$errorImgMsg)) {
            return false;
        }
        List<String> this$allowReferers = this.getAllowReferers();
        List<String> other$allowReferers = other.getAllowReferers();
        if (this$allowReferers == null ? other$allowReferers != null : !((Object)this$allowReferers).equals(other$allowReferers)) {
            return false;
        }
        List<String> this$whiteList = this.getWhiteList();
        List<String> other$whiteList = other.getWhiteList();
        if (this$whiteList == null ? other$whiteList != null : !((Object)this$whiteList).equals(other$whiteList)) {
            return false;
        }
        List<String> this$blackList = this.getBlackList();
        List<String> other$blackList = other.getBlackList();
        if (this$blackList == null ? other$blackList != null : !((Object)this$blackList).equals(other$blackList)) {
            return false;
        }
        ImageCompressProperties this$imageCompress = this.getImageCompress();
        ImageCompressProperties other$imageCompress = other.getImageCompress();
        return !(this$imageCompress == null ? other$imageCompress != null : !((Object)this$imageCompress).equals(other$imageCompress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileManageConfigPropertiesBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $fileIdMask = this.getFileIdMask();
        result = result * 59 + ($fileIdMask == null ? 43 : ((Object)$fileIdMask).hashCode());
        Boolean $fileCheckEnable = this.getFileCheckEnable();
        result = result * 59 + ($fileCheckEnable == null ? 43 : ((Object)$fileCheckEnable).hashCode());
        String $tmpPath = this.getTmpPath();
        result = result * 59 + ($tmpPath == null ? 43 : $tmpPath.hashCode());
        String $uploadType = this.getUploadType();
        result = result * 59 + ($uploadType == null ? 43 : $uploadType.hashCode());
        String $localPath = this.getLocalPath();
        result = result * 59 + ($localPath == null ? 43 : $localPath.hashCode());
        String $accessUrlPrefix = this.getAccessUrlPrefix();
        result = result * 59 + ($accessUrlPrefix == null ? 43 : $accessUrlPrefix.hashCode());
        String $suffix = this.getSuffix();
        result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
        String $errorFileMsg = this.getErrorFileMsg();
        result = result * 59 + ($errorFileMsg == null ? 43 : $errorFileMsg.hashCode());
        String $errorImgMsg = this.getErrorImgMsg();
        result = result * 59 + ($errorImgMsg == null ? 43 : $errorImgMsg.hashCode());
        List<String> $allowReferers = this.getAllowReferers();
        result = result * 59 + ($allowReferers == null ? 43 : ((Object)$allowReferers).hashCode());
        List<String> $whiteList = this.getWhiteList();
        result = result * 59 + ($whiteList == null ? 43 : ((Object)$whiteList).hashCode());
        List<String> $blackList = this.getBlackList();
        result = result * 59 + ($blackList == null ? 43 : ((Object)$blackList).hashCode());
        ImageCompressProperties $imageCompress = this.getImageCompress();
        result = result * 59 + ($imageCompress == null ? 43 : ((Object)$imageCompress).hashCode());
        return result;
    }

    public String toString() {
        return "FileManageConfigPropertiesBean(tmpPath=" + this.getTmpPath() + ", uploadType=" + this.getUploadType() + ", localPath=" + this.getLocalPath() + ", accessUrlPrefix=" + this.getAccessUrlPrefix() + ", fileIdMask=" + this.getFileIdMask() + ", fileCheckEnable=" + this.getFileCheckEnable() + ", suffix=" + this.getSuffix() + ", errorFileMsg=" + this.getErrorFileMsg() + ", errorImgMsg=" + this.getErrorImgMsg() + ", allowReferers=" + this.getAllowReferers() + ", whiteList=" + this.getWhiteList() + ", blackList=" + this.getBlackList() + ", imageCompress=" + this.getImageCompress() + ")";
    }
}

