/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.dubbo.monitor;

import com.tydic.nicc.framework.dubbo.monitor.DubboInfoStoreCenter;
import com.tydic.nicc.framework.dubbo.monitor.DubboThreadInfoContext;
import com.tydic.nicc.framework.dubbo.monitor.DubboThreadPoolCollector;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class DubboRecordFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(DubboRecordFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        int port = invoker.getUrl().getPort();
        ThreadPoolExecutor threadPoolExecutor = DubboThreadPoolCollector.getDubboThreadPoolExecutor(port);
        try {
            DubboThreadInfoContext context = DubboThreadInfoContext.builder().activePoolSize(threadPoolExecutor.getActiveCount()).time(System.currentTimeMillis()).queueLength(threadPoolExecutor.getQueue().size()).build();
            log.error("dubbo\u76d1\u63a7-update:{}", (Object)context);
            DubboInfoStoreCenter.update(invoker.getUrl().getPort(), context);
        }
        catch (Exception e) {
            log.error("dubbo\u76d1\u63a7-\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return invoker.invoke(invocation);
    }
}

