/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.permission;

import com.tydic.nicc.common.bo.premission.Logical;
import com.tydic.nicc.common.bo.premission.PermissionType;
import com.tydic.nicc.common.bo.premission.RequiresRole;
import com.tydic.nicc.common.bo.user.SysRole;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class RoleCheckAspect {
    private static final Logger log = LoggerFactory.getLogger(RoleCheckAspect.class);

    public static Field[] getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        block0: for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getName().equals("roles")) continue;
                fields.add(field);
                continue block0;
            }
        }
        return fields.toArray(new Field[0]);
    }

    @Around(value="@annotation(requiresRole)")
    public Object checkRequiresRole(ProceedingJoinPoint point, RequiresRole requiresRole) throws Throwable {
        Field[] declaredFields;
        Object[] requestParams = point.getArgs();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        String returnType = method.getReturnType().getTypeName();
        Object requestParam = requestParams[0];
        for (Field field : declaredFields = RoleCheckAspect.getAllFields(requestParam.getClass())) {
            List sysRoles;
            field.setAccessible(true);
            Object fieldObj = field.get(requestParam);
            String filedName = field.getName();
            if (!filedName.equals("roles") || (sysRoles = (List)fieldObj) == null) continue;
            List<String> roles = sysRoles.stream().map(SysRole::getRoleCode).collect(Collectors.toList());
            if (!this.checkRole(roles, requiresRole)) {
                return this.createErrorReturn(returnType, "\u64cd\u4f5c\u5931\u8d25\uff1a\u6743\u9650\u5f02\u5e38");
            }
            return point.proceed();
        }
        return this.createErrorReturn(returnType, "\u64cd\u4f5c\u5931\u8d25\uff1a\u6743\u9650\u5f02\u5e38");
    }

    private Object createErrorReturn(String returnType, String msg) {
        if (Rsp.class.getName().equals(returnType)) {
            return BaseRspUtils.createErrorRsp((String)"9999", (String)msg);
        }
        if (RspList.class.getName().equals(returnType)) {
            return BaseRspUtils.createErrorRspList((String)"9999", (String)msg);
        }
        throw new RuntimeException(msg);
    }

    private boolean checkRole(List<String> sysRoles, RequiresRole requiresRole) {
        if (requiresRole.permissionType().equals((Object)PermissionType.ACCESS)) {
            if (Logical.AND.name().equals(requiresRole.logical().name())) {
                for (String role : requiresRole.value()) {
                    if (sysRoles.contains(role)) continue;
                    return false;
                }
                return true;
            }
            boolean hasRole = false;
            for (String role : requiresRole.value()) {
                if (!sysRoles.contains(role)) continue;
                hasRole = true;
                break;
            }
            return hasRole;
        }
        if (Logical.AND.name().equals(requiresRole.logical().name())) {
            for (String role : requiresRole.value()) {
                if (!sysRoles.contains(role)) continue;
                return false;
            }
            return true;
        }
        boolean hasRole = false;
        for (String role : requiresRole.value()) {
            if (!sysRoles.contains(role)) continue;
            hasRole = true;
            break;
        }
        return !hasRole;
    }
}

