/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import org.apache.commons.lang3.StringUtils;

public class DesensitizationUtil {
    private static final int SIZE = 6;
    private static final String SYMBOL = "*";

    public static void main(String[] args) {
        String name = DesensitizationUtil.commonDisplay("\u8d75\u9547\u554a");
        String mobile = DesensitizationUtil.commonDisplay("13900000000");
        String mail = DesensitizationUtil.commonDisplay("admin@imooc.com");
        String address = DesensitizationUtil.commonDisplay("\u5317\u4eac\u5927\u8fd0\u6cb3\u4e1c\u8def888\u53f7");
        System.out.println(name);
        System.out.println(mobile);
        System.out.println(mail);
        System.out.println(address);
        System.out.println(DesensitizationUtil.markName("\u5f20\u4e09"));
        System.out.println(DesensitizationUtil.markName("\u5f20\u4e09\u5c14\u5c14"));
    }

    public static String markName(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value) && value.length() >= 2) {
            return DesensitizationUtil.replaceChar(value, 1, 2, SYMBOL);
        }
        return value;
    }

    public static String replaceChar(String value, int start, int end, String str) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            StringBuffer buffer = new StringBuffer(value);
            buffer.replace(start, end, str);
            return buffer.toString();
        }
        return value;
    }

    public static String commonDisplay(String value) {
        if (null == value || "".equals(value)) {
            return value;
        }
        int len = value.length();
        int pamaone = len / 2;
        int pamatwo = pamaone - 1;
        int pamathree = len % 2;
        StringBuilder stringBuilder = new StringBuilder();
        if (len <= 2) {
            if (pamathree == 1) {
                return SYMBOL;
            }
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.charAt(len - 1));
        } else if (pamatwo <= 0) {
            stringBuilder.append(value.substring(0, 1));
            stringBuilder.append(SYMBOL);
            stringBuilder.append(value.substring(len - 1, len));
        } else if (pamatwo >= 3 && 7 != len) {
            int pamafive = (len - 6) / 2;
            stringBuilder.append(value.substring(0, pamafive));
            for (int i = 0; i < 6; ++i) {
                stringBuilder.append(SYMBOL);
            }
            if (pamathree == 0) {
                // empty if block
            }
            if (pamathree != 0) {
                // empty if block
            }
            stringBuilder.append(value.substring(len - (pamafive + 1), len));
        } else {
            int pamafour = len - 2;
            stringBuilder.append(value.substring(0, 1));
            for (int i = 0; i < pamafour; ++i) {
                stringBuilder.append(SYMBOL);
            }
            stringBuilder.append(value.substring(len - 1, len));
        }
        return stringBuilder.toString();
    }

    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)1);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)SYMBOL);
    }

    public static String chineseName(String familyName, String givenName) {
        if (StringUtils.isBlank((CharSequence)familyName) || StringUtils.isBlank((CharSequence)givenName)) {
            return "";
        }
        if (familyName.length() > 1) {
            String name = StringUtils.left((String)familyName, (int)familyName.length());
            return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)(familyName + givenName)), (String)SYMBOL);
        }
        return DesensitizationUtil.chineseName(familyName + givenName);
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)SYMBOL);
    }

    public static String mobileEncrypt(String num, int index, int end) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.left((String)num, (int)index).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)end), (int)StringUtils.length((CharSequence)num), (String)SYMBOL), (String)"***"));
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)0), (int)6, (String)SYMBOL).concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String hideLeftNum(String cardNum, int hideDigit) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)cardNum);
        return StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)(length - hideDigit)), (int)length, (String)SYMBOL);
    }

    public static String hideRightNum(String cardNum, int hideDigit) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)cardNum);
        return StringUtils.rightPad((String)StringUtils.left((String)cardNum, (int)(length - hideDigit)), (int)length, (String)SYMBOL);
    }

    public static String hideCenterNum(String cardNum, int hideDigit) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)cardNum);
        int index = length - hideDigit >> 1;
        if (hideDigit % 2 == 0) {
            ++index;
        }
        return StringUtils.left((String)cardNum, (int)index).concat(StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)(length - index - hideDigit)), (int)(length - index), (String)SYMBOL));
    }

    public static String hideAllNum(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)cardNum);
        return StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)0), (int)length, (String)SYMBOL);
    }
}

