/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpClientHelper.class);

    public static void disableCertificateValidation() throws Exception {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HostnameVerifier allHostsValid = (hostname, session) -> true;
        HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
    }

    public static CloseableHttpClient getHttpClientWithDisabledSSL(int connectTimeout, int readTimeout) throws Exception {
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }}, new SecureRandom());
        return HttpClients.custom().setSSLContext(sc).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(readTimeout).build()).build();
    }

    public static CloseableHttpClient getHttpClient(int connectTimeout, int readTimeout) {
        try {
            return HttpClientHelper.getHttpClientWithDisabledSSL(connectTimeout, readTimeout);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5ba2\u6237\u7aef\u5f02\u5e38", (Throwable)e);
            return HttpClients.createDefault();
        }
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int readTimout) {
        return HttpClientHelper.doPost(url, headers, body, 1000, readTimout);
    }

    public static String doPost(String url, Map<String, String> headers, Object body) {
        return HttpClientHelper.doPost(url, headers, body, 1000, 10000);
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int connectTimout, int readTimout) {
        return HttpClientHelper.doPost(url, headers, body, connectTimout, readTimout, false);
    }

    public static String doPost(String url, Map<String, String> headers, Object body, int connectTimout, int readTimout, boolean printLog) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        String entity = "";
        try {
            HttpEntity resEntity;
            HttpResponse response;
            httpClient = HttpClientHelper.getHttpClient(connectTimout, readTimout);
            httpPost = new HttpPost(url);
            httpPost.addHeader("Accept", "application/json");
            httpPost.addHeader("Accept-Encoding", "UTF-8");
            httpPost.setHeader("Content-Type", "application/json; charset=utf-8");
            if (headers != null) {
                for (Map.Entry<String, String> stringEntry : headers.entrySet()) {
                    httpPost.setHeader(stringEntry.getKey(), stringEntry.getValue());
                }
            }
            if (body != null) {
                entity = body instanceof String ? body.toString() : JSONObject.toJSONString((Object)body);
                StringEntity postEntity = new StringEntity(entity, "UTF-8");
                httpPost.setEntity((HttpEntity)postEntity);
            }
            if (printLog) {
                log.info("POST\u8bf7\u6c42: {}|{}|{}", new Object[]{url, headers, entity});
            }
            if ((response = httpClient.execute((HttpUriRequest)httpPost)) != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception e) {
            log.error("POST\u8bf7\u6c42\u5f02\u5e38: {}|{}|{}", new Object[]{url, headers, entity, e});
        }
        if (printLog) {
            log.info("POST\u8bf7\u6c42\u7ed3\u679c: {}|{}|{}", new Object[]{url, headers, result});
        }
        return result;
    }

    public static String doGet(String url, Map<String, String> headers, int readTimout) {
        return HttpClientHelper.doGet(url, headers, 1000, readTimout);
    }

    public static String doGet(String url, Map<String, String> headers) {
        return HttpClientHelper.doGet(url, headers, 1000, 10000);
    }

    public static String doGet(String url, Map<String, String> headers, int connectTimout, int readTimout) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpClientHelper.getHttpClient(connectTimout, readTimout);
            HttpGet httpGet = new HttpGet(url);
            if (headers != null) {
                for (Map.Entry<String, String> stringEntry : headers.entrySet()) {
                    httpGet.setHeader(stringEntry.getKey(), stringEntry.getValue());
                }
            }
            log.info("GET\u8bf7\u6c42: {}|{}", (Object)url, headers);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception var8) {
            log.error("GET\u8bf7\u6c42\u5f02\u5e38: {}", (Object)url, (Object)var8);
        }
        return result;
    }

    public static HttpEntity buildMultipartEntity(String name, List<File> files, Map<String, String> formData) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        for (File file : files) {
            builder.addBinaryBody(name, file);
        }
        if (formData != null) {
            for (Map.Entry entry : formData.entrySet()) {
                builder.addTextBody((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return builder.build();
    }

    public static HttpEntity buildMultipartEntity(String name, InputStream stream, ContentType contentType, String filename, Map<String, String> formData) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        builder.setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody(name, stream, contentType, filename);
        if (formData != null) {
            for (Map.Entry<String, String> stringEntry : formData.entrySet()) {
                builder.addTextBody(stringEntry.getKey(), stringEntry.getValue());
            }
        }
        return builder.build();
    }

    public static String doPostFile(String url, Map<String, String> headers, HttpEntity multipartEntity) {
        return HttpClientHelper.doPostFile(url, headers, multipartEntity, 1000, 10000);
    }

    public static String doPostFile(String url, Map<String, String> headers, HttpEntity multipartEntity, int connectTimout, int readTimout) {
        String charset = "utf-8";
        CloseableHttpClient httpClient = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpClientHelper.getHttpClient(connectTimout, readTimout);
            HttpPost httpPost = new HttpPost(url);
            if (headers != null) {
                for (Map.Entry<String, String> stringEntry : headers.entrySet()) {
                    httpPost.setHeader(stringEntry.getKey(), stringEntry.getValue());
                }
            }
            httpPost.setEntity(multipartEntity);
            HttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)charset);
            }
        }
        catch (Exception var8) {
            log.error("Post\u8bf7\u6c42\u5f02\u5e38: {}", (Object)url, (Object)var8);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String res1 = HttpClientHelper.doGet("https://10.125.164.161:42103/", new HashMap<String, String>());
        System.out.println(res1);
    }
}

