/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONObject;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.tydic.nicc.common.bo.im.admin.ImCacheMsg;
import com.tydic.nicc.common.bo.im.admin.ImMsgBO;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.eums.im.MsgIdPolicyType;
import com.tydic.nicc.common.eums.user.UserTypeField;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.DigestUtils;

public class NiccCommonUtil {
    private static final Logger log = LoggerFactory.getLogger(NiccCommonUtil.class);
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final Base64.Decoder decoder = Base64.getDecoder();
    public static final int page_un_limit = 99999;
    public static final int cs_allot_limit = 10;
    public static final int page_es_default = 1000;
    public static final String CHAT_KEY_PREFIX = "chat";
    public static final String GUEST_KEY = "guest_";
    public static final String GUEST_NAME = "\u6e38\u5ba2";
    private static int min = 10000000;
    private static int max = 99999999;
    private static Pattern humpPattern = Pattern.compile("[A-Z]");
    public static final String regex = "'|and|exec|execute|insert|select|delete|update|count|drop|\\*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|\\+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|\\*|chr|mid|master|truncate|char|declare|or|;|--|\\+|,|like|//|/|%|#";

    public static final String getAllotLockKey(String skillGId) {
        return "csm_allot_" + skillGId;
    }

    public static <T> Map<String, ?> beanToMap(T bean) {
        return NiccCommonUtil.beanToMap(bean, "yyyy-MM-dd'T'HH:mm:ss.SSS");
    }

    public static <T> Map<String, ?> beanToMap(T bean, String dateFormat) {
        HashMap hashMap = new HashMap();
        if (ObjectUtils.anyNotNull((Object[])new Object[]{bean})) {
            BeanMap beanMap = BeanMap.create(bean);
            beanMap.forEach((key, val) -> {
                if (null != val) {
                    if (val instanceof Date) {
                        Date value = (Date)val;
                        hashMap.put(key, DateTimeUtil.getTimeShortString((Date)value, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS"));
                    } else {
                        hashMap.put(key, val);
                    }
                }
            });
        }
        return hashMap;
    }

    public static List<ImMsgBO> cacheList2Msgs(List<ImCacheMsg> msgs) {
        ArrayList list = Lists.newArrayList();
        for (ImCacheMsg msg : msgs) {
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getMsgId(), msg.getFromNo(), msg.getToNo(), msg.getChatType()})) continue;
            ImMsgBO msgBO = new ImMsgBO();
            BeanUtils.copyProperties((Object)msg, (Object)msgBO);
            msgBO.setMsgTime(Long.valueOf(msg.getMsgTime().getTime()));
            msgBO.setInfoSessionId(msg.getSessionId());
            msgBO.setUserId(msg.getFromNo());
            list.add(msgBO);
        }
        return list;
    }

    public static String parseTemplate(String template, String name, Map<String, Object> context) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)template)) {
            DefaultMustacheFactory mf = new DefaultMustacheFactory();
            Mustache mustache = mf.compile((Reader)new StringReader(template), name);
            StringWriter writer = new StringWriter();
            mustache.execute((Writer)writer, context).flush();
            return writer.toString();
        }
        return JSONObject.toJSONString(context);
    }

    public static Rsp parseRspTemplate(String template, String name, Map<String, Object> context) throws IOException {
        String rsp = NiccCommonUtil.parseTemplate(template, name, context);
        JSONObject object = JSONObject.parseObject((String)rsp);
        Rsp rsp1 = new Rsp();
        rsp1.setRspCode(object.getString("rspCode"));
        rsp1.setRspDesc(object.getString("rspDesc"));
        rsp1.setData((Object)object.getString("data"));
        return rsp1;
    }

    public static String parseTemplate(String template, Map<String, Object> context) throws IOException {
        return NiccCommonUtil.parseTemplate(template, "default", context);
    }

    public static String filterSql(String param) {
        if (param == null) {
            return param;
        }
        return param.replaceAll("(?i)'|and|exec|execute|insert|select|delete|update|count|drop|\\*|%|chr|mid|master|truncate|char|declare|sitename|net user|xp_cmdshell|;|or|\\+|,|like'|and|exec|execute|insert|create|drop|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|union|where|select|delete|update|order|by|count|\\*|chr|mid|master|truncate|char|declare|or|;|--|\\+|,|like|//|/|%|#", "");
    }

    public static String underline2Camel(String line, boolean smallCamel) {
        if (line == null || "".equals(line)) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile("([A-Za-z\\d]+)(_)?");
        Matcher matcher = pattern.matcher(line);
        while (matcher.find()) {
            String word = matcher.group();
            sb.append(smallCamel && matcher.start() == 0 ? Character.toLowerCase(word.charAt(0)) : Character.toUpperCase(word.charAt(0)));
            int index = word.lastIndexOf(95);
            if (index > 0) {
                sb.append(word.substring(1, index).toLowerCase());
                continue;
            }
            sb.append(word.substring(1).toLowerCase());
        }
        return sb.toString();
    }

    public static String humpToLine(String str) {
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String stringToMD5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2amd5\u7b97\u6cd5\uff01");
        }
        Object md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - ((String)md5code).length(); ++i) {
            md5code = "0" + (String)md5code;
        }
        return md5code;
    }

    public static String md5HashCode(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            int length = -1;
            while ((length = ((InputStream)fis).read(buffer, 0, 1024)) != -1) {
                md.update(buffer, 0, length);
            }
            ((InputStream)fis).close();
            byte[] md5Bytes = md.digest();
            BigInteger bigInt = new BigInteger(1, md5Bytes);
            return bigInt.toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getIpAddress() {
        String host = "";
        try {
            try {
                host = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (StringUtils.isEmpty((CharSequence)host)) {
                Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
                InetAddress ip = null;
                while (allNetInterfaces.hasMoreElements()) {
                    NetworkInterface netInterface = allNetInterfaces.nextElement();
                    if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp()) continue;
                    Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        ip = addresses.nextElement();
                        if (ip == null || !(ip instanceof Inet4Address)) continue;
                        return ip.getHostAddress();
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("IP\u5730\u5740\u83b7\u53d6\u5931\u8d25" + e.toString());
        }
        return host;
    }

    public static String getRealIP() {
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                if (netInterface.isLoopback() || netInterface.isVirtual() || !netInterface.isUp() || !netInterface.getDisplayName().contains("Intel") && !netInterface.getDisplayName().contains("Realtek")) continue;
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    System.out.println("ipv4 = " + ip.getHostAddress());
                    return ip.getHostAddress();
                }
                break block2;
            }
        }
        catch (SocketException e) {
            System.err.println("Error when getting host ip address" + e.getMessage());
        }
        return "";
    }

    public static synchronized int generateRandomCode() {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static synchronized int generateRandomCode(int min, int max) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String createGuestUID(boolean mask) {
        String uid = IdWorker.nextAutoIdStr();
        if (mask) {
            uid = DigestUtils.md5DigestAsHex((byte[])uid.getBytes(StandardCharsets.UTF_8)).substring(0, 25);
        }
        return GUEST_KEY + uid;
    }

    public static String createGuestNickName() {
        return GUEST_NAME + NiccCommonUtil.generateRandomCode();
    }

    public static synchronized String createImUserId(boolean mask) {
        String uid = IdWorker.nextAutoIdStr();
        if (mask) {
            uid = DigestUtils.md5DigestAsHex((byte[])uid.getBytes(StandardCharsets.UTF_8)).substring(0, 30);
        }
        return uid;
    }

    public static synchronized String maskImUserId(String uid) {
        return DigestUtils.md5DigestAsHex((byte[])uid.getBytes(StandardCharsets.UTF_8)).substring(0, 30);
    }

    public static String getC2cChatKey(String fromNo, String toNo) {
        if (toNo.startsWith(CHAT_KEY_PREFIX)) {
            return toNo;
        }
        Object[] userIds = new String[]{fromNo, toNo};
        Arrays.sort(userIds);
        String chatKey = (String)userIds[0] + (String)userIds[1];
        String chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5(chatKey);
        log.debug("\u751f\u6210chatKey:{} - {}", (Object)chatKey, (Object)chatKeyMd5);
        return chatKeyMd5;
    }

    public static String getC2bChatKey(String tenantCode, String userId) {
        String chatKey = userId + tenantCode;
        String chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5(chatKey);
        log.debug("\u751f\u6210chatKey:{} - {}", (Object)chatKey, (Object)chatKeyMd5);
        return chatKeyMd5;
    }

    public static String getC2bChatKey(String tenantCode, UserAuthInfo fromUser, String toNo) {
        if (toNo.startsWith(CHAT_KEY_PREFIX)) {
            return toNo;
        }
        Object chatKeyMd5 = "";
        Object chatKey = "";
        String sysUser = ImCoreConstants.getSystemUser((String)tenantCode);
        chatKey = fromUser.getUserId().equals(sysUser) ? toNo + tenantCode : (toNo.equals(tenantCode) ? fromUser.getUserId() + tenantCode : (UserTypeField.COMP_USER.getCode().equals(fromUser.getUserType()) || UserTypeField.SYSTEM.getCode().equals(fromUser.getUserType()) ? toNo + tenantCode : fromUser.getUserId() + tenantCode));
        chatKeyMd5 = CHAT_KEY_PREFIX + NiccCommonUtil.stringToMD5((String)chatKey);
        log.debug("\u751f\u6210chatKey:{} - {}", chatKey, chatKeyMd5);
        return chatKeyMd5;
    }

    public static void copyList(List sourceList, List targetList, Class targetClass) {
        if (ObjectUtils.anyNotNull((Object[])new Object[]{sourceList, targetList})) {
            for (Object o : sourceList) {
                try {
                    Object target = targetClass.newInstance();
                    BeanUtils.copyProperties(o, target);
                    targetList.add(target);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String encodeStr(String str) {
        try {
            return encoder.encodeToString(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String decodeStr(String str) {
        try {
            return new String(decoder.decode(str), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String createC2cSession() {
        return "C2C" + IdWorker.nextAutoIdStr();
    }

    public static String clearHtml(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static final String createMsgId() {
        return NiccCommonUtil.createMsgId(MsgIdPolicyType.ID_WORKER.getCode());
    }

    public static final String createMsgId(String type) {
        return NiccCommonUtil.createMsgId(type, 100000, 999999);
    }

    public static final synchronized String createMsgId(String type, int min, int max) {
        if (MsgIdPolicyType.UUID.getCode().equals(type)) {
            return UUID.randomUUID().toString();
        }
        if (MsgIdPolicyType.ID_WORKER_RANDOM.getCode().equals(type)) {
            String id = IdWorker.nextAutoIdStr();
            int random = NiccCommonUtil.getRandomNumber(min, max);
            return id + random;
        }
        return IdWorker.nextAutoIdStr();
    }

    public static final int getRandomNumber(int min, int max) {
        return (int)(Math.random() * (double)(max - min) + (double)min);
    }
}

