/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.aspect;

import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.annotitions.DistributedLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockAspect {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockAspect.class);
    @Autowired(required=false)
    private RedisHelper redisHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(distributedLock)")
    public Object around(ProceedingJoinPoint joinPoint, DistributedLock distributedLock) throws Throwable {
        if (this.redisHelper == null) {
            log.warn("redisHelper is null, distributed lock will not be applied.");
            return joinPoint.proceed();
        }
        String lockKey = distributedLock.lockKey();
        long timeout = distributedLock.timeout();
        long waitTime = distributedLock.waitTime();
        int retryCount = distributedLock.retryCount();
        boolean throwException = distributedLock.throwException();
        String requestId = String.valueOf(Thread.currentThread().getId());
        boolean locked = false;
        int attempts = 0;
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(requestId).build();
        while (!locked && attempts <= retryCount) {
            locked = this.redisHelper.lock(redisLockEntity, waitTime, timeout);
            if (locked) continue;
            if (++attempts > retryCount) {
                log.warn("\u83b7\u53d6\u9501\u5931\u8d25\uff0ckey: {}, \u5c1d\u8bd5\u6b21\u6570: {}", (Object)lockKey, (Object)attempts);
                if (throwException) {
                    throw new RuntimeException("\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                return null;
            }
            Thread.sleep(waitTime);
        }
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            this.redisHelper.unlock(redisLockEntity);
        }
    }
}

