/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.config;

import com.tydic.nicc.framework.utils.ImageUtils;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@ConfigurationProperties(prefix="upload-file-manage.image-compress")
public class ImageCompressProperties {
    private Boolean enable = false;
    private long overSize = 1024L;
    private long destSize = 1000L;

    public boolean isCompress(MultipartFile file) {
        return this.enable != false && this.isImage(file.getOriginalFilename().toLowerCase(Locale.ROOT)) && file.getSize() / 1024L >= this.overSize;
    }

    public boolean isImage(String fileName) {
        return StringUtils.isNotBlank((CharSequence)fileName) && ImageUtils.checkImageSuffix(fileName);
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public long getOverSize() {
        return this.overSize;
    }

    public long getDestSize() {
        return this.destSize;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setOverSize(long overSize) {
        this.overSize = overSize;
    }

    public void setDestSize(long destSize) {
        this.destSize = destSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageCompressProperties)) {
            return false;
        }
        ImageCompressProperties other = (ImageCompressProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOverSize() != other.getOverSize()) {
            return false;
        }
        if (this.getDestSize() != other.getDestSize()) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        return !(this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageCompressProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $overSize = this.getOverSize();
        result = result * 59 + (int)($overSize >>> 32 ^ $overSize);
        long $destSize = this.getDestSize();
        result = result * 59 + (int)($destSize >>> 32 ^ $destSize);
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        return result;
    }

    public String toString() {
        return "ImageCompressProperties(enable=" + this.getEnable() + ", overSize=" + this.getOverSize() + ", destSize=" + this.getDestSize() + ")";
    }
}

