/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.listener;

import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.NoIvGenerator;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class JasyptPreparedEnvListener
implements SmartApplicationListener,
Ordered {
    private String getSalt(ConfigurableEnvironment env) {
        String salt = env.getProperty("jasypt.encryptor.password");
        if (salt == null || salt.isBlank()) {
            return null;
        }
        return salt;
    }

    private String[] getConfigAllows(ConfigurableEnvironment env) {
        String rst = env.getProperty("jasypt.encryptor.property.config.allows");
        if (StringUtils.isBlank((CharSequence)rst)) {
            String[] rstArr = new String[]{"dubbo."};
            return rstArr;
        }
        String[] rstArr = (String[])Stream.of(rst.split(",")).map(val -> val + ".").toArray(String[]::new);
        return rstArr;
    }

    private String getConfigPrefix(ConfigurableEnvironment env) {
        String rst = env.getProperty("jasypt.encryptor.property.config.prefix");
        if (StringUtils.isBlank((CharSequence)rst)) {
            rst = env.getProperty("jasypt.encryptor.property.prefix");
        }
        if (StringUtils.isBlank((CharSequence)rst)) {
            return "ENC(";
        }
        return rst;
    }

    private String getConfigSuffix(ConfigurableEnvironment env) {
        String rst = env.getProperty("jasypt.encryptor.property.config.suffix");
        if (StringUtils.isBlank((CharSequence)rst)) {
            rst = env.getProperty("jasypt.encryptor.property.suffix");
        }
        if (StringUtils.isBlank((CharSequence)rst)) {
            return ")";
        }
        return rst;
    }

    private boolean shouldDecrypted(String[] allows, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        String trimValue = value.trim();
        boolean rst = false;
        for (String allow : allows) {
            if (!trimValue.startsWith(allow)) continue;
            rst = true;
            break;
        }
        return rst;
    }

    private boolean isEncrypted(String value, String prefix, String suffix) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        String trimValue = value.trim();
        return trimValue.startsWith(prefix) && trimValue.endsWith(suffix);
    }

    private String unwrapEncryptedValue(String value, String prefix, String suffix) {
        return value.substring(prefix.length(), value.length() - suffix.length());
    }

    private String getAlgorithm(ConfigurableEnvironment env) {
        String rst = env.getProperty("jasypt.encryptor.algorithm");
        if (rst == null || rst.isBlank()) {
            return "PBEWithHMACSHA512AndAES_256";
        }
        return rst;
    }

    private String decrypt(ConfigurableEnvironment env, String value) {
        String algorithm = this.getAlgorithm(env);
        StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
        encryptor.setPassword("nicc-salt_!@#");
        encryptor.setAlgorithm(algorithm);
        encryptor.setIvGenerator((IvGenerator)new NoIvGenerator());
        return encryptor.decrypt(value);
    }

    public void onApplicationEvent(@NotNull ApplicationEvent applicationEvent) {
        ConfigurableEnvironment env = ((ApplicationEnvironmentPreparedEvent)applicationEvent).getEnvironment();
        String configPrefix = this.getConfigPrefix(env);
        String configSuffix = this.getConfigSuffix(env);
        String[] configAllows = this.getConfigAllows(env);
        for (PropertySource source : env.getPropertySources()) {
            Object o = source.getSource();
            if (!(o instanceof Map)) continue;
            for (Map.Entry entry : ((Map)o).entrySet()) {
                String key = (String)entry.getKey();
                String value = env.getProperty(key);
                if (!this.shouldDecrypted(configAllows, key) || !this.isEncrypted(value, configPrefix, configSuffix)) continue;
                String newValue = this.decrypt(env, this.unwrapEncryptedValue(value, configPrefix, configSuffix));
                System.setProperty(key, newValue);
            }
        }
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> aClass) {
        return ApplicationEnvironmentPreparedEvent.class.isAssignableFrom(aClass);
    }

    public int getOrder() {
        return -2147483637;
    }
}

