/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.im.admin.ImCacheMsg;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.framework.utils.LuaScriptLoader;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ImMessageLuaCacheHelper {
    private static final Logger log = LoggerFactory.getLogger(ImMessageLuaCacheHelper.class);
    public static String MSG_APPEND_SCRIPT = "";
    public static String MSG_READ_SCRIPT = "";
    public static String MSG_UNREAD_COUNT_SCRIPT = "";
    public static String MSG_LIST_SCRIPT = "";
    @Autowired(required=false)
    private RedisHelper redisHelper;
    @Autowired(required=false)
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private LuaScriptLoader luaScriptLoader;
    static final int msgQueueMaxSize = 2000;

    @PostConstruct
    public void init() {
        MSG_APPEND_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_append.lua");
        MSG_READ_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_read.lua");
        MSG_UNREAD_COUNT_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_unread_count.lua");
        MSG_LIST_SCRIPT = this.luaScriptLoader.readLuaScriptContent("msg_list.lua");
    }

    public List<ImCacheMsg> getUnreadMsgList(String userId, String chatObj, String chatType) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a!");
        Assert.notNull((Object)chatObj, (String)"\u804a\u5929\u5bf9\u8c61ID\u4e0d\u5f97\u4e3a\u7a7a!");
        if (chatType == null) {
            chatType = "";
        }
        List<ImCacheMsg> listMy = this.listMessage(userId, chatObj, chatType);
        List<ImCacheMsg> listChatObj = this.listMessage(chatObj, userId, chatType);
        listMy.addAll(listChatObj);
        return listMy;
    }

    public List<ImCacheMsg> listMessage(String userId, String chatObj, String chatType) {
        return this.listMessage(userId, chatObj, chatType, null);
    }

    public List<ImCacheMsg> listMessage(String userId, String chatObj, String chatType, Long startTime) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a!");
        if (chatObj == null) {
            chatObj = "";
        }
        if (chatType == null) {
            chatType = "";
        }
        String time = startTime == null || startTime <= 0L ? "" : String.valueOf(startTime);
        String result = "";
        List cacheMsgs = Lists.newArrayList();
        try {
            String userMsgKey = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
            result = this.execLuaScript(MSG_LIST_SCRIPT, Collections.singletonList(userMsgKey), chatObj, chatType, time);
            if (log.isTraceEnabled()) {
                log.trace("\u6267\u884clua\u811a\u672c-listMessage:keys:{},result:{}", (Object)userMsgKey, (Object)result);
            }
            if (!"{}".equals(result)) {
                cacheMsgs = JSONArray.parseArray((String)result, ImCacheMsg.class);
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884clua\u811a\u672c-\u67e5\u8be2\u6d88\u606f-\u5f02\u5e38:{}", (Object)MSG_LIST_SCRIPT, (Object)e);
        }
        return cacheMsgs;
    }

    public boolean appendMessage(ImCacheMsg message) {
        try {
            String userMsgKey = "";
            userMsgKey = message.getToNo().equals(message.getTenantCode()) ? RedisCacheKeyConstant.getUserMsgCacheListKey((String)NiccCommonUtil.getC2bChatKey(message.getTenantCode(), message.getFromNo())) : RedisCacheKeyConstant.getUserMsgCacheListKey((String)message.getToNo());
            String val = JSONObject.toJSONString((Object)message);
            this.stringRedisTemplate.opsForList().rightPush((Object)userMsgKey, (Object)val);
            this.stringRedisTemplate.expire((Object)userMsgKey, TimeUnit.DAYS.toSeconds(30L), TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            log.error("\u6267\u884clua\u811a\u672c-\u7f13\u5b58\u6d88\u606f-\u5f02\u5e38:{}", (Object)message, (Object)e);
            return false;
        }
    }

    public boolean appendMessage(List<ImCacheMsg> messages) {
        try {
            String userMsgKey = "";
            ArrayList batchMsgs = Lists.newArrayList();
            if (messages != null && !messages.isEmpty()) {
                ImCacheMsg message = messages.get(0);
                userMsgKey = message.getToNo().equals(message.getTenantCode()) ? RedisCacheKeyConstant.getUserMsgCacheListKey((String)NiccCommonUtil.getC2bChatKey(message.getTenantCode(), message.getFromNo())) : RedisCacheKeyConstant.getUserMsgCacheListKey((String)message.getToNo());
                for (ImCacheMsg msg : messages) {
                    batchMsgs.add(JSONObject.toJSONString((Object)msg));
                }
                this.stringRedisTemplate.opsForList().rightPushAll((Object)userMsgKey, (Collection)batchMsgs);
                this.stringRedisTemplate.expire((Object)userMsgKey, TimeUnit.DAYS.toSeconds(30L), TimeUnit.SECONDS);
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u6267\u884clua\u811a\u672c-\u7f13\u5b58\u6d88\u606f-\u5f02\u5e38:{}", messages, (Object)e);
        }
        return false;
    }

    public void clearUnread(String userId) {
        String userMsgKey = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
        this.redisHelper.del(new String[]{userMsgKey});
    }

    public int readMessage(String userId, String chatObj, Long readTime, String chatType) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a!");
        try {
            String time = String.valueOf(readTime);
            if (chatObj == null) {
                chatObj = "";
            }
            if (chatType == null) {
                chatType = "";
            }
            if (readTime == null) {
                time = "";
            }
            String userMsgKey = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
            String readCount = this.execLuaScript(MSG_READ_SCRIPT, Arrays.asList(userMsgKey), chatObj, time, chatType);
            int read = Integer.valueOf(readCount);
            return read;
        }
        catch (Exception e) {
            log.error("\u6267\u884clua\u811a\u672c-\u7f13\u5b58\u6d88\u606f-\u5f02\u5e38:{}", (Object)MSG_READ_SCRIPT, (Object)e);
            return 0;
        }
    }

    public void incrUnreadTotal(String userId, int count) {
        String unreadTotalKey = "im:user-unread:" + userId;
        if (this.redisHelper.hasKey(unreadTotalKey)) {
            this.redisHelper.incr(unreadTotalKey, (long)count);
        } else {
            count = this.countUnreadLocal(userId, "", MsgChatType.C2B.getCode());
            this.redisHelper.set(unreadTotalKey, (Object)count, TimeUnit.MINUTES.toSeconds(30L));
        }
    }

    public int getUnreadTotal(String userId) {
        String unreadTotalKey = "im:user-unread:" + userId;
        Integer count = (Integer)this.redisHelper.get(unreadTotalKey);
        if (count != null) {
            if (count < 0) {
                return 0;
            }
            return count;
        }
        return -1;
    }

    public void cacheUnreadTotal(String userId, int count) {
        String unreadTotalKey = "im:user-unread:" + userId;
        this.redisHelper.set(unreadTotalKey, (Object)count, TimeUnit.MINUTES.toSeconds(30L));
    }

    public int readMessage(String userId, String chatObj, Long readTime) {
        return this.readMessage(userId, chatObj, readTime, MsgChatType.C2B.getCode());
    }

    public Map<String, Long> getUnreadMap(String userId, String chatType) {
        if (StringUtils.isBlank((CharSequence)chatType)) {
            chatType = MsgChatType.C2B.getCode();
        }
        try {
            String key = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
            List msgList = this.stringRedisTemplate.opsForList().range((Object)key, 0L, -1L);
            if (msgList != null) {
                ArrayList msgs = Lists.newArrayList();
                for (String s : msgList) {
                    ImCacheMsg msg = (ImCacheMsg)JSONObject.parseObject((String)s, ImCacheMsg.class);
                    if (msg.getMsgTime() == null || !chatType.equals(msg.getChatType()) || msg.getMsgForm() == 15) continue;
                    msgs.add(msg);
                }
                Map<String, Long> result = msgs.stream().collect(Collectors.groupingBy(ImCacheMsg::getFromNo, Collectors.counting()));
                return result;
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u672a\u8bfbmap-\u5f02\u5e38:", (Throwable)e);
        }
        return new HashedMap();
    }

    public int countUnreadLocal(String userId, String chatObj, String chatType) {
        String key = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
        int unread = 0;
        try {
            log.info("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u6570-\u67e5\u8be2\u7f13\u5b58:{}|{}|{}", new Object[]{userId, chatObj, chatType});
            List msgList = this.stringRedisTemplate.opsForList().range((Object)key, 0L, -1L);
            if (msgList != null) {
                log.info("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u6570-\u67e5\u8be2\u7ed3\u679c:{}|{}|{}", new Object[]{userId, chatObj, msgList.size()});
                if (msgList.size() > 1000) {
                    log.error("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u6570-\u6570\u91cf\u5f02\u5e38:{}|{}|{}", new Object[]{userId, chatObj, msgList.size()});
                }
                if (msgList.size() > 2000) {
                    this.stringRedisTemplate.opsForList().trim((Object)key, (long)(msgList.size() - 2000), (long)msgList.size());
                }
                for (String s : msgList) {
                    ImCacheMsg msg = (ImCacheMsg)JSONObject.parseObject((String)s, ImCacheMsg.class);
                    if (msg.getMsgTime() == null || msg.getMsgForm() == null || msg.getMsgForm() == 15) continue;
                    if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{chatObj, chatType})) {
                        ++unread;
                        continue;
                    }
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{chatObj, chatType}) && chatObj.equals(msg.getFromNo()) && chatType.equals(msg.getChatType())) {
                        ++unread;
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)chatObj) && chatObj.equals(msg.getFromNo()) && StringUtils.isBlank((CharSequence)chatType)) {
                        ++unread;
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)chatType) || !chatType.equals(msg.getChatType()) || !StringUtils.isBlank((CharSequence)chatObj)) continue;
                    ++unread;
                }
            }
        }
        catch (Exception e) {
            log.error("\u672a\u8bfb\u6d88\u606f\u7edf\u8ba1\u5f02\u5e38:", (Throwable)e);
        }
        return unread;
    }

    public List<ImCacheMsg> listMessageLocal(String userId, String chatObj, String chatType, Long startTime) {
        String key = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
        ArrayList cacheMsgs = Lists.newArrayList();
        try {
            log.info("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u5217\u8868-\u67e5\u8be2\u7f13\u5b58:{}|{}|{}", new Object[]{userId, chatObj, chatType});
            List msgList = this.stringRedisTemplate.opsForList().range((Object)key, 0L, -1L);
            if (msgList != null) {
                log.info("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u5217\u8868-\u67e5\u8be2\u7ed3\u679c:{}|{}|{}", new Object[]{userId, chatObj, msgList.size()});
                if (msgList.size() > 1000) {
                    log.error("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u5217\u8868-\u6570\u91cf\u5f02\u5e38:{}|{}|{}", new Object[]{userId, chatObj, msgList.size()});
                }
                if (msgList.size() > 2000) {
                    this.stringRedisTemplate.opsForList().trim((Object)key, (long)(msgList.size() - 2000), (long)msgList.size());
                }
                for (String s : msgList) {
                    ImCacheMsg msg = (ImCacheMsg)JSONObject.parseObject((String)s, ImCacheMsg.class);
                    if (msg.getMsgTime() == null || msg.getMsgForm() == null || msg.getMsgForm() == 15 || ObjectUtils.allNotNull((Object[])new Object[]{startTime, msg.getMsgTime()}) && msg.getMsgTime().getTime() < startTime) continue;
                    if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{chatObj, chatType})) {
                        cacheMsgs.add(msg);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)chatType) && chatType.equals(msg.getChatType()) && StringUtils.isBlank((CharSequence)chatObj)) {
                        cacheMsgs.add(msg);
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)chatObj) && chatObj.equals(msg.getFromNo()) && StringUtils.isBlank((CharSequence)chatType)) {
                        cacheMsgs.add(msg);
                        continue;
                    }
                    if (!chatObj.equals(msg.getFromNo()) || !chatType.equals(msg.getChatType())) continue;
                    cacheMsgs.add(msg);
                }
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u672a\u8bfb\u6d88\u606f\u5217\u8868-\u5f02\u5e38:", (Throwable)e);
        }
        return cacheMsgs;
    }

    public long countUnread(String userId, String chatObj, String chatType) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u5f97\u4e3a\u7a7a!");
        if (chatObj == null) {
            chatObj = "";
        }
        if (chatType == null) {
            chatType = "";
        }
        String key = RedisCacheKeyConstant.getUserMsgCacheListKey((String)userId);
        Long unread = 0L;
        try {
            String result = this.execLuaScript(MSG_UNREAD_COUNT_SCRIPT, Collections.singletonList(key), chatObj, chatType);
            unread = Long.valueOf(result);
        }
        catch (Exception e) {
            log.error("\u6267\u884clua\u811a\u672c-\u672a\u8bfb\u6d88\u606f\u7edf\u8ba1-\u5f02\u5e38:", (Throwable)e);
        }
        return unread;
    }

    public String execLuaScript(String script, List<String> keys, Object ... params) {
        if (log.isTraceEnabled()) {
            log.info("\u6267\u884clua\u811a\u672c:{},keys:{},obj:{}", new Object[]{script, keys, params});
        }
        DefaultRedisScript redisScript = new DefaultRedisScript(script, String.class);
        StringRedisSerializer serializer = new StringRedisSerializer();
        return this.redisHelper.execLuaResult((RedisScript)redisScript, serializer, keys, params);
    }
}

