/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtils {
    private static final Logger log = LoggerFactory.getLogger(ImageUtils.class);
    public static final List<String> COMMON_IMAGES = Lists.newArrayList((Object[])new String[]{"gif", "jpg", "jpeg", "png", "icon", "webp", "bmp"});
    private static final Integer ZERO = 0;
    private static final Integer ONE_ZERO_TWO_FOUR = 1024;
    private static final Integer NINE_ZERO_ZERO = 900;
    private static final Integer THREE_TWO_SEVEN_FIVE = 3275;
    private static final Integer TWO_ZERO_FOUR_SEVEN = 2047;
    private static final Double ZERO_EIGHT_FIVE = 0.85;
    private static final Double ZERO_SIX = 0.6;
    private static final Double ZERO_FOUR_FOUR = 0.44;
    private static final Double ZERO_FOUR = 0.4;

    public static byte[] compressPicForScale(byte[] imageBytes, long desFileSize) {
        if (imageBytes == null || imageBytes.length <= ZERO || (long)imageBytes.length < desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
            return imageBytes;
        }
        long srcSize = imageBytes.length;
        double accuracy = ImageUtils.getAccuracy(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue());
        try {
            while ((long)imageBytes.length > desFileSize * (long)ONE_ZERO_TWO_FOUR.intValue()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream(imageBytes.length);
                Thumbnails.of((InputStream[])new InputStream[]{inputStream}).scale(accuracy).outputQuality(accuracy).toOutputStream((OutputStream)outputStream);
                imageBytes = outputStream.toByteArray();
            }
            log.info("\u56fe\u7247\u538b\u7f29-\u56fe\u7247\u5927\u5c0f: {} kb > {} kb", (Object)(srcSize / (long)ONE_ZERO_TWO_FOUR.intValue()), (Object)(imageBytes.length / ONE_ZERO_TWO_FOUR));
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u538b\u7f29-\u5f02\u5e38:", (Throwable)e);
        }
        return imageBytes;
    }

    private static double getAccuracy(long size) {
        double accuracy = size < (long)NINE_ZERO_ZERO.intValue() ? ZERO_EIGHT_FIVE : (size < (long)TWO_ZERO_FOUR_SEVEN.intValue() ? ZERO_SIX : (size < (long)THREE_TWO_SEVEN_FIVE.intValue() ? ZERO_FOUR_FOUR.doubleValue() : ZERO_FOUR.doubleValue()));
        return accuracy;
    }

    public static boolean checkImageSuffix(String fileName) {
        for (String image : COMMON_IMAGES) {
            if (!fileName.endsWith(image.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isImage(MultipartFile file) throws IOException {
        if (file.getOriginalFilename().endsWith(".webp")) {
            return true;
        }
        return ImageUtils.isImage(file.getInputStream());
    }

    public static boolean isImage(InputStream stream) {
        try {
            BufferedImage bufferedImage = ImageIO.read(stream);
            if (bufferedImage != null) {
                Integer width = bufferedImage.getWidth();
                Integer height = bufferedImage.getHeight();
                if (width > 0 && height > 0) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("\u56fe\u7247\u6821\u9a8c\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        return false;
    }
}

