/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class MultipartFileUtil {
    private static final Logger log = LoggerFactory.getLogger(MultipartFileUtil.class);

    private MultipartFileUtil() {
    }

    public static MultipartFile toMultipartFile(File file) throws FileNotFoundException {
        FileItem fileItem = MultipartFileUtil.createFileItem(new FileInputStream(file), file.getName());
        return new CommonsMultipartFile(fileItem);
    }

    public static MultipartFile toMultipartFile(byte[] bytes, String fileName) {
        FileItem fileItem = MultipartFileUtil.createFileItem(new ByteArrayInputStream(bytes), fileName);
        return new CommonsMultipartFile(fileItem);
    }

    private static FileItem createFileItem(InputStream is, String fileName) {
        return MultipartFileUtil.createFileItem(is, "file", fileName);
    }

    private static FileItem createFileItem(InputStream is, String fieldName, String fileName) {
        OutputStream fileItemOutStream;
        DiskFileItemFactory fac = new DiskFileItemFactory(10240, null);
        FileItem fileItem = fac.createItem(fieldName, "multipart/form-data", true, fileName);
        try {
            fileItemOutStream = fileItem.getOutputStream();
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6FileItem\u8f93\u51fa\u6d41\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        try {
            IOUtils.copy((InputStream)is, (OutputStream)fileItemOutStream);
        }
        catch (IOException e) {
            log.error("\u5199\u5165FileItem\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return fileItem;
    }
}

