/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.framework.vaidation;

import com.tydic.nicc.common.nbchat.exception.CommonBusiException;
import com.tydic.nicc.common.nbchat.exception.ParamVerifyException;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Rsp<String>> validationBodyException(MethodArgumentNotValidException e) {
        String err = Objects.requireNonNull(e.getFieldError()).getDefaultMessage();
        if (StringUtils.isBlank((CharSequence)err)) {
            err = "\u53c2\u6570\u6821\u9a8c\u5f02\u5e38";
        }
        Rsp resp = BaseRspUtils.createErrorRsp((String)err);
        log.debug("\u53c2\u6570\u6821\u9a8c\u5f02\u5e38: {}", (Object)err, (Object)e);
        return new ResponseEntity((Object)resp, HttpStatus.OK);
    }

    @ExceptionHandler(value={ParamVerifyException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Rsp<String> handleParamException(ParamVerifyException e) {
        log.warn("\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38: ", (Throwable)e);
        return BaseRspUtils.createErrorRsp((String)e.getMessage());
    }

    @ExceptionHandler(value={CommonBusiException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Rsp<String> handleCommonException(CommonBusiException e) {
        log.warn("\u4e1a\u52a1\u5904\u7406\u5f02\u5e38: ", (Throwable)e);
        return BaseRspUtils.createErrorRsp((String)e.getMessage());
    }

    @ExceptionHandler(value={NullPointerException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Rsp<String> handleGeneralException(NullPointerException e) {
        log.error("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef[\u7a7a\u6307\u9488]: ", (Throwable)e);
        e.printStackTrace();
        return BaseRspUtils.createErrorRsp((String)"Internal Server Error!");
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.OK)
    public Rsp<String> handleGeneralException(Exception e) {
        log.error("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef: ", (Throwable)e);
        return BaseRspUtils.createErrorRsp((String)"\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ResponseEntity<String> handleMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        log.warn("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301: {}", (Object)e.getMessage());
        return new ResponseEntity((Object)"Method Not Supported!", HttpStatus.METHOD_NOT_ALLOWED);
    }
}

