/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.tools.sensitiveWords;

import com.tydic.nicc.tools.eum.EndType;
import com.tydic.nicc.tools.sensitiveWords.WordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordContext {
    private static final Logger log = LoggerFactory.getLogger(WordContext.class);
    private final Set<String> blackWordSet = new LinkedHashSet<String>();
    private final Set<String> whiteWordSet = new LinkedHashSet<String>();
    private final Map wordMap = new HashMap(1024);
    private boolean init = false;
    private final String blackList;
    private final String whiteList;

    public WordContext() {
        this.blackList = "/blacklist.txt";
        this.whiteList = "/whitelist.txt";
        this.initKeyWord();
    }

    public WordContext(boolean loadDefault, String blackList, String whiteList) {
        this.blackList = blackList;
        this.whiteList = whiteList;
        if (loadDefault) {
            this.initKeyWord();
        }
    }

    public static void main(String[] args) {
        WordContext wordContext = new WordContext(true, "/blacklist.txt", "/whitelist.txt");
    }

    public WordContext(String blackList, String whiteList) {
        this.blackList = blackList;
        this.whiteList = whiteList;
        this.initKeyWord();
    }

    public WordContext(File blackList, File whiteList, boolean loadDefault) {
        try {
            this.blackList = "/blacklist.txt";
            this.whiteList = "/whitelist.txt";
            if (loadDefault) {
                this.initKeyWord();
            }
            this.addWord(this.readWordFile(blackList), WordType.BLACK);
            this.addWord(this.readWordFile(whiteList), WordType.WHITE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map getWordMap() {
        return this.wordMap;
    }

    private synchronized void initKeyWord() {
        try {
            if (!this.init) {
                Set<String> black = this.readWordFile(this.blackList);
                log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u8bcd\u5e93-blackList = {}, words = {}", (Object)this.blackList, black);
                this.addWord(black, WordType.BLACK);
                Set<String> white = this.readWordFile(this.whiteList);
                log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u8bcd\u5e93-whiteList = {}, words = {}", (Object)this.whiteList, black);
                this.addWord(white, WordType.WHITE);
            }
            this.init = true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addWord(Iterable<String> wordList, WordType wordType) {
        for (String key : wordList) {
            if (WordType.BLACK.equals((Object)wordType)) {
                this.blackWordSet.add(key);
            } else {
                this.whiteWordSet.add(key);
            }
            HashMap<Object, Object> nowMap = this.wordMap;
            for (int i = 0; i < key.length(); ++i) {
                char keyChar = key.charAt(i);
                Object wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (Map)wordMap;
                } else {
                    HashMap<Object, Object> newWorMap = new HashMap<Object, Object>(4);
                    newWorMap.put("isEnd", String.valueOf(EndType.HAS_NEXT.ordinal()));
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key.length() - 1) continue;
                nowMap.put("isEnd", String.valueOf(EndType.IS_END.ordinal()));
                nowMap.put("isWhiteWord", String.valueOf(wordType.ordinal()));
            }
        }
    }

    public void removeWord(Iterable<String> wordList, WordType wordType) {
        for (String key : wordList) {
            if (WordType.BLACK.equals((Object)wordType)) {
                this.blackWordSet.remove(key);
            } else {
                this.whiteWordSet.remove(key);
            }
            ArrayList<Map> cacheList = new ArrayList<Map>();
            Map nowMap = this.wordMap;
            for (int i = 0; i < key.length(); ++i) {
                char keyChar = key.charAt(i);
                Object map = nowMap.get(Character.valueOf(keyChar));
                if (map == null) {
                    return;
                }
                nowMap = (Map)map;
                cacheList.add(nowMap);
                if (i != key.length() - 1) continue;
                char[] keys = key.toCharArray();
                boolean cleanable = false;
                char lastChar = '\u0000';
                for (int j = cacheList.size() - 1; j >= 0; --j) {
                    Map cacheMap = (Map)cacheList.get(j);
                    if (j == cacheList.size() - 1) {
                        if (String.valueOf(WordType.BLACK.ordinal()).equals(cacheMap.get("isWhiteWord")) && wordType == WordType.WHITE) {
                            return;
                        }
                        if (String.valueOf(WordType.WHITE.ordinal()).equals(cacheMap.get("isWhiteWord")) && wordType == WordType.BLACK) {
                            return;
                        }
                        cacheMap.remove("isWhiteWord");
                        cacheMap.remove("isEnd");
                        if (cacheMap.size() == 0) {
                            cleanable = true;
                            continue;
                        }
                    }
                    if (cleanable) {
                        Object isEnd = cacheMap.get("isEnd");
                        if (String.valueOf(EndType.IS_END.ordinal()).equals(isEnd)) {
                            cleanable = false;
                        }
                        cacheMap.remove(Character.valueOf(lastChar));
                    }
                    lastChar = keys[j];
                }
                if (!cleanable) continue;
                this.wordMap.remove(Character.valueOf(lastChar));
            }
        }
    }

    public Set<String> readWordFile(String file) throws Exception {
        HashSet<String> set = new HashSet<String>();
        String encoding = "UTF-8";
        if (file != null && file.trim().length() > 0) {
            try (InputStreamReader read = new InputStreamReader(this.getClass().getResourceAsStream(file), encoding);){
                String txt;
                set = new HashSet();
                BufferedReader bufferedReader = new BufferedReader(read);
                while ((txt = bufferedReader.readLine()) != null) {
                    set.add(txt);
                }
            }
        }
        return set;
    }

    public Set<String> readWordFile(File file) throws Exception {
        HashSet<String> set;
        String encoding = "UTF-8";
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
            String txt;
            set = new HashSet<String>();
            BufferedReader bufferedReader = new BufferedReader(read);
            while ((txt = bufferedReader.readLine()) != null) {
                set.add(txt.trim());
            }
        }
        return set;
    }

    public Set<String> getWordSet(WordType wordType) {
        if (WordType.BLACK.equals((Object)wordType)) {
            return this.blackWordSet;
        }
        return this.whiteWordSet;
    }
}

