/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.tools.sensitiveWords;

import com.tydic.nicc.tools.sensitiveWords.FlagIndex;
import com.tydic.nicc.tools.sensitiveWords.WordContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WordFilter {
    private final Map wordMap;

    public WordFilter(WordContext context) {
        this.wordMap = context.getWordMap();
    }

    public String replace(String text) {
        return this.replace(text, 0, '*');
    }

    public String replace(String text, char symbol) {
        return this.replace(text, 0, symbol);
    }

    public String replace(String text, int skip, char symbol) {
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (!fi.isWhiteWord()) {
                for (int j : fi.getIndex()) {
                    charset[j] = symbol;
                }
                continue;
            }
            i += fi.getIndex().size() - 1;
        }
        return new String(charset);
    }

    public boolean include(String text) {
        return this.include(text, 0);
    }

    public boolean include(String text, int skip) {
        boolean include = false;
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            include = true;
            break;
        }
        return include;
    }

    public int wordCount(String text) {
        return this.wordCount(text, 0);
    }

    public int wordCount(String text, int skip) {
        int count = 0;
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            ++count;
        }
        return count;
    }

    public List<String> wordList(String text) {
        return this.wordList(text, 0);
    }

    public List<String> wordList(String text, int skip) {
        ArrayList<String> wordList = new ArrayList<String>();
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int j : fi.getIndex()) {
                char word = text.charAt(j);
                builder.append(word);
            }
            wordList.add(builder.toString());
        }
        return wordList;
    }

    private FlagIndex getFlagIndex(char[] charset, int begin, int skip) {
        FlagIndex fi = new FlagIndex();
        Map current = this.wordMap;
        boolean flag = false;
        int count = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (int i = begin; i < charset.length; ++i) {
            char word = charset[i];
            Map mapTree = (Map)current.get(Character.valueOf(word));
            if (count > skip || i == begin && Objects.isNull(mapTree)) break;
            if (Objects.nonNull(mapTree)) {
                current = mapTree;
                count = 0;
                index.add(i);
            } else if (flag && ++count > skip) break;
            if ("1".equals(current.get("isEnd"))) {
                flag = true;
            }
            if (!"1".equals(current.get("isWhiteWord"))) continue;
            fi.setWhiteWord(true);
            break;
        }
        fi.setFlag(flag);
        fi.setIndex(index);
        return fi;
    }
}

