/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.tools.sensitiveWords;

import com.tydic.nicc.tools.eum.EndType;
import com.tydic.nicc.tools.sensitiveWords.WordType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordContext {
    private static final Logger log = LoggerFactory.getLogger(WordContext.class);
    private final Set<String> blackWordSet = new LinkedHashSet<String>();
    private final Set<String> blackRegSet = new LinkedHashSet<String>();
    private final Set<String> whiteWordSet = new LinkedHashSet<String>();
    private final Map wordMap = new HashMap(1024);
    private boolean init = false;
    private final String blackList;
    private final String blackRegList;
    private final String whiteList;

    public WordContext() {
        this.blackList = "/blacklist.txt";
        this.blackRegList = "/blackReglist.txt";
        this.whiteList = "/whitelist.txt";
        this.initKeyWord();
    }

    public WordContext(boolean loadDefault, String blackList, String whiteList) {
        this.blackList = blackList;
        this.whiteList = whiteList;
        this.blackRegList = "";
        if (loadDefault) {
            this.initKeyWord();
        }
    }

    public WordContext(boolean loadDefault, String blackList, String blackRegList, String whiteList) {
        this.blackList = blackList;
        this.blackRegList = blackRegList;
        this.whiteList = whiteList;
        if (loadDefault) {
            this.initKeyWord();
        }
    }

    public WordContext(String blackList, String blackReglist, String whiteList) {
        this.blackList = blackList;
        this.whiteList = whiteList;
        this.blackRegList = blackReglist;
        this.initKeyWord();
    }

    public Map getWordMap() {
        return this.wordMap;
    }

    public Set<String> getBlackRegSet() {
        return this.blackRegSet;
    }

    private synchronized void initKeyWord() {
        if (!this.init) {
            Set<String> black = this.readWordFile(this.blackList);
            log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u8bcd\u5e93-blackList = {}, words = {}", (Object)this.blackList, black);
            this.addWord(black, WordType.BLACK);
            Set<String> blackReg = this.readWordFile(this.blackRegList);
            log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u8bcd\u5e93-blackRegList = {}, words = {}", (Object)this.blackRegList, blackReg);
            this.addWord(blackReg, WordType.BLACK_REG);
            Set<String> white = this.readWordFile(this.whiteList);
            log.info("\u521d\u59cb\u5316\u9ed8\u8ba4\u8bcd\u5e93-whiteList = {}, words = {}", (Object)this.whiteList, white);
            this.addWord(white, WordType.WHITE);
        }
        this.init = true;
    }

    public void addWord(Iterable<String> wordList, WordType wordType) {
        for (String key : wordList) {
            if (WordType.BLACK.equals((Object)wordType)) {
                this.blackWordSet.add(key);
            } else {
                if (WordType.BLACK_REG.equals((Object)wordType)) {
                    this.blackRegSet.add(key);
                    continue;
                }
                this.whiteWordSet.add(key);
            }
            HashMap<Object, Object> nowMap = this.wordMap;
            for (int i = 0; i < key.length(); ++i) {
                char keyChar = key.charAt(i);
                Object wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (Map)wordMap;
                } else {
                    HashMap<Object, Object> newWorMap = new HashMap<Object, Object>(4);
                    newWorMap.put("isEnd", String.valueOf(EndType.HAS_NEXT.ordinal()));
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key.length() - 1) continue;
                nowMap.put("isEnd", String.valueOf(EndType.IS_END.ordinal()));
                nowMap.put("isWhiteWord", String.valueOf(wordType.ordinal()));
            }
        }
    }

    public void removeWord(Iterable<String> wordList, WordType wordType) {
        for (String key : wordList) {
            if (WordType.BLACK.equals((Object)wordType)) {
                this.blackWordSet.remove(key);
            } else {
                if (WordType.BLACK_REG.equals((Object)wordType)) {
                    this.blackRegSet.remove(key);
                    continue;
                }
                this.whiteWordSet.remove(key);
            }
            ArrayList<Map> cacheList = new ArrayList<Map>();
            Map nowMap = this.wordMap;
            for (int i = 0; i < key.length(); ++i) {
                char keyChar = key.charAt(i);
                Object map = nowMap.get(Character.valueOf(keyChar));
                if (map == null) {
                    return;
                }
                nowMap = (Map)map;
                cacheList.add(nowMap);
                if (i != key.length() - 1) continue;
                char[] keys = key.toCharArray();
                boolean cleanable = false;
                char lastChar = '\u0000';
                for (int j = cacheList.size() - 1; j >= 0; --j) {
                    Map cacheMap = (Map)cacheList.get(j);
                    if (j == cacheList.size() - 1) {
                        if (String.valueOf(WordType.BLACK.ordinal()).equals(cacheMap.get("isWhiteWord")) && wordType == WordType.WHITE) {
                            return;
                        }
                        if (String.valueOf(WordType.WHITE.ordinal()).equals(cacheMap.get("isWhiteWord")) && wordType == WordType.BLACK) {
                            return;
                        }
                        cacheMap.remove("isWhiteWord");
                        cacheMap.remove("isEnd");
                        if (cacheMap.size() == 0) {
                            cleanable = true;
                            continue;
                        }
                    }
                    if (cleanable) {
                        Object isEnd = cacheMap.get("isEnd");
                        if (String.valueOf(EndType.IS_END.ordinal()).equals(isEnd)) {
                            cleanable = false;
                        }
                        cacheMap.remove(Character.valueOf(lastChar));
                    }
                    lastChar = keys[j];
                }
                if (!cleanable) continue;
                this.wordMap.remove(Character.valueOf(lastChar));
            }
        }
    }

    public Set<String> readWordFile(String file) {
        HashSet<String> set;
        block8: {
            set = new HashSet<String>();
            try {
                String encoding = "UTF-8";
                if (file == null || file.trim().length() <= 0) break block8;
                try (InputStreamReader read = new InputStreamReader(this.getClass().getResourceAsStream(file), encoding);){
                    String txt;
                    set = new HashSet();
                    BufferedReader bufferedReader = new BufferedReader(read);
                    while ((txt = bufferedReader.readLine()) != null) {
                        set.add(txt);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u8bfb\u53d6\u672c\u5730\u654f\u611f\u8bcd\u5e93\u6587\u4ef6-\u5f02\u5e38:", (Throwable)e);
            }
        }
        return set;
    }

    public Set<String> readWordFile(File file) {
        HashSet set = new LinkedHashSet<String>();
        try {
            String encoding = "UTF-8";
            try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(file), encoding);){
                String txt;
                set = new HashSet();
                BufferedReader bufferedReader = new BufferedReader(read);
                while ((txt = bufferedReader.readLine()) != null) {
                    set.add((String)txt.trim());
                }
            }
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u672c\u5730\u654f\u611f\u8bcd\u5e93\u6587\u4ef6-\u5f02\u5e38:", (Throwable)e);
        }
        return set;
    }

    public Set<String> getWordSet(WordType wordType) {
        if (WordType.BLACK.equals((Object)wordType)) {
            return this.blackWordSet;
        }
        if (WordType.BLACK_REG.equals((Object)wordType)) {
            return this.blackRegSet;
        }
        return this.whiteWordSet;
    }
}

