/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.tools.sensitiveWords;

import com.tydic.nicc.tools.sensitiveWords.FlagIndex;
import com.tydic.nicc.tools.sensitiveWords.WordContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordFilter {
    private static final Logger logger = LoggerFactory.getLogger(WordFilter.class);
    private final Map wordMap;
    private final Set<String> blackRegSet;

    public WordFilter(WordContext context) {
        this.wordMap = context.getWordMap();
        this.blackRegSet = context.getBlackRegSet();
    }

    public String replace(String text) {
        return this.replace(text, 0, '*');
    }

    public String replace(String text, char symbol) {
        return this.replace(text, 0, symbol);
    }

    public String replace(String text, int skip, char symbol) {
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (!fi.isWhiteWord()) {
                for (int j : fi.getIndex()) {
                    charset[j] = symbol;
                }
                continue;
            }
            i += fi.getIndex().size() - 1;
        }
        String content = new String(charset);
        if (!this.blackRegSet.isEmpty()) {
            return this.replaceByReg(content, symbol);
        }
        return content;
    }

    private String replaceByReg(String text, char symbol) {
        String content = text;
        try {
            for (String reg : this.blackRegSet) {
                Matcher matcher = Pattern.compile(reg, 10).matcher(content);
                if (!matcher.find()) continue;
                content = matcher.replaceAll(String.valueOf(symbol) + symbol);
            }
        }
        catch (Exception e) {
            logger.error("\u6b63\u5219\u5339\u914d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f:{}", this.blackRegSet, (Object)e);
        }
        return content;
    }

    private boolean includeByReg(String text) {
        String content = text;
        try {
            for (String reg : this.blackRegSet) {
                Matcher matcher = Pattern.compile(reg, 10).matcher(content);
                if (!matcher.find()) continue;
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u6b63\u5219\u5339\u914d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f:{}", this.blackRegSet, (Object)e);
        }
        return false;
    }

    private int countByReg(String text) {
        int count = 0;
        try {
            for (String reg : this.blackRegSet) {
                Matcher matcher = Pattern.compile(reg, 10).matcher(text);
                if (!matcher.find()) continue;
                ++count;
            }
        }
        catch (Exception e) {
            logger.error("\u6b63\u5219\u5339\u914d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f:{}", this.blackRegSet, (Object)e);
        }
        return count;
    }

    private List<String> listByReg(String text) {
        ArrayList<String> groups = new ArrayList<String>();
        try {
            for (String reg : this.blackRegSet) {
                Matcher matcher = Pattern.compile(reg, 10).matcher(text);
                if (!matcher.find()) continue;
                groups.add(matcher.group());
            }
        }
        catch (Exception e) {
            logger.error("\u6b63\u5219\u5339\u914d\u5f02\u5e38,\u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f:{}", this.blackRegSet, (Object)e);
        }
        return groups;
    }

    public boolean include(String text) {
        return this.include(text, 0);
    }

    public boolean include(String text, int skip) {
        boolean include = false;
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            include = true;
            break;
        }
        if (!include && !this.blackRegSet.isEmpty()) {
            return this.includeByReg(text);
        }
        return include;
    }

    public int wordCount(String text) {
        return this.wordCount(text, 0);
    }

    public int wordCount(String text, int skip) {
        int count = 0;
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            ++count;
        }
        if (count == 0 && !this.blackRegSet.isEmpty()) {
            return count + this.countByReg(text);
        }
        return count;
    }

    public List<String> wordList(String text) {
        return this.wordList(text, 0);
    }

    public List<String> wordList(String text, int skip) {
        ArrayList<String> wordList = new ArrayList<String>();
        char[] charset = text.toCharArray();
        for (int i = 0; i < charset.length; ++i) {
            FlagIndex fi = this.getFlagIndex(charset, i, skip);
            if (!fi.isFlag()) continue;
            if (fi.isWhiteWord()) {
                i += fi.getIndex().size() - 1;
                continue;
            }
            StringBuilder builder = new StringBuilder();
            for (int j : fi.getIndex()) {
                char word = text.charAt(j);
                builder.append(word);
            }
            wordList.add(builder.toString());
        }
        if (!this.blackRegSet.isEmpty()) {
            wordList.addAll(this.listByReg(text));
        }
        return wordList;
    }

    private FlagIndex getFlagIndex(char[] charset, int begin, int skip) {
        FlagIndex fi = new FlagIndex();
        Map current = this.wordMap;
        boolean flag = false;
        int count = 0;
        ArrayList<Integer> index = new ArrayList<Integer>();
        for (int i = begin; i < charset.length; ++i) {
            char word = charset[i];
            Map mapTree = (Map)current.get(Character.valueOf(word));
            if (count > skip || i == begin && Objects.isNull(mapTree)) break;
            if (Objects.nonNull(mapTree)) {
                current = mapTree;
                count = 0;
                index.add(i);
            } else if (flag && ++count > skip) break;
            if ("1".equals(current.get("isEnd"))) {
                flag = true;
            }
            if (!"1".equals(current.get("isWhiteWord"))) continue;
            fi.setWhiteWord(true);
            break;
        }
        fi.setFlag(flag);
        fi.setIndex(index);
        return fi;
    }
}

