/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsScheduleType;
import com.tydic.nicc.common.eums.csm.CsWorkScheduleLevel;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheck;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleCheckResult;
import com.tydic.nicc.csm.busi.CsWorkScheduleCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.exception.CsNoWorkingException;
import com.tydic.nicc.csm.mapper.CsWorkScheduleMapper;
import com.tydic.nicc.csm.mapper.po.CsWorkScheduleQueryCondition;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@DS(value="nicc-csm")
@Service
public class CsWorkScheduleCommonServiceImpl
implements CsWorkScheduleCommonService {
    private static final Logger log = LoggerFactory.getLogger(CsWorkScheduleCommonServiceImpl.class);
    @Resource
    private CsWorkScheduleMapper csWorkScheduleMapper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;

    @Override
    public List<CsWorkScheduleBO> getCsWorkScheduleList(String tenantCode) {
        ArrayList list = Lists.newArrayList();
        CsWorkScheduleQueryCondition condition = new CsWorkScheduleQueryCondition();
        condition.setTenantCode(tenantCode);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        List csWorkSchedules = this.csWorkScheduleMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)csWorkSchedules, (List)list, CsWorkScheduleBO.class);
        log.info("\u67e5\u8be2\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e:{} \u6761", (Object)list.size());
        return list;
    }

    @Override
    public CsWorkScheduleCheckResult checkCsWorkSchedule(CsWorkScheduleCheck scheduleCheck) {
        log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5f00\u59cb:{}", (Object)scheduleCheck);
        CsWorkScheduleCheckResult checkResult = CsWorkScheduleCheckResult.builder().match(false).build();
        List<CsWorkScheduleBO> schedules = this.getCsWorkScheduleList(scheduleCheck.getTenantCode());
        if (!schedules.isEmpty()) {
            try {
                checkResult = this.checkNormalType(schedules, scheduleCheck);
            }
            catch (CsNoWorkingException e) {
                log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5f00\u59cb:{}", (Object)scheduleCheck);
                return this.buildNoWorkingResult();
            }
        }
        if (!checkResult.isMatch()) {
            return this.buildNoWorkingResult();
        }
        log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u7ed3\u679c:{}", (Object)checkResult);
        return checkResult;
    }

    private CsWorkScheduleCheckResult checkNormalType(List<CsWorkScheduleBO> normalList, CsWorkScheduleCheck scheduleCheck) {
        CsWorkScheduleCheckResult checkResult = CsWorkScheduleCheckResult.builder().match(false).build();
        if (!normalList.isEmpty()) {
            List<CsWorkScheduleBO> skillSchedules;
            List<CsWorkScheduleBO> csSchedules;
            if (StringUtils.isNotEmpty((CharSequence)scheduleCheck.getCsId()) && (csSchedules = normalList.parallelStream().filter(obj -> CsWorkScheduleLevel.CS_TYPE.getCode().equals(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(scheduleCheck.getCsId())).collect(Collectors.toList())) != null && !csSchedules.isEmpty()) {
                log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5339\u914d\u5230\u5750\u5e2d\u914d\u7f6e:{}", csSchedules);
                this.checkIsHoliday(csSchedules);
                for (CsWorkScheduleBO scheduleBO : csSchedules) {
                    boolean checkInNormal = this.checkIsWork(scheduleBO);
                    if (!checkInNormal) continue;
                    checkResult.setMatch(true);
                    checkResult.setSchedule(scheduleBO);
                    return checkResult;
                }
                return CsWorkScheduleCheckResult.builder().match(false).build();
            }
            if (StringUtils.isNotEmpty((CharSequence)scheduleCheck.getSkillGid()) && (skillSchedules = normalList.parallelStream().filter(obj -> CsWorkScheduleLevel.SKILL_GROUP.getCode().equals(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(scheduleCheck.getSkillGid())).collect(Collectors.toList())) != null && !skillSchedules.isEmpty()) {
                log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5339\u914d\u5230\u6280\u80fd\u7ec4\u914d\u7f6e:{}", skillSchedules);
                this.checkIsHoliday(skillSchedules);
                for (CsWorkScheduleBO scheduleBO : skillSchedules) {
                    boolean checkInNormal = this.checkIsWork(scheduleBO);
                    if (!checkInNormal) continue;
                    checkResult.setMatch(true);
                    checkResult.setSchedule(scheduleBO);
                    return checkResult;
                }
                return CsWorkScheduleCheckResult.builder().match(false).build();
            }
            List<CsWorkScheduleBO> tenantSchedules = normalList.parallelStream().filter(obj -> CsWorkScheduleLevel.TENANT.getCode().equals(obj.getConfigLevel()) && obj.getConfigLevelVal().equals(scheduleCheck.getTenantCode())).collect(Collectors.toList());
            if (tenantSchedules != null && !tenantSchedules.isEmpty()) {
                log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5339\u914d\u5230\u79df\u6237\u914d\u7f6e:{}", tenantSchedules);
                this.checkIsHoliday(tenantSchedules);
                for (CsWorkScheduleBO scheduleBO : tenantSchedules) {
                    boolean checkInNormal = this.checkIsWork(scheduleBO);
                    if (!checkInNormal) continue;
                    checkResult.setMatch(true);
                    checkResult.setSchedule(scheduleBO);
                    return checkResult;
                }
                return CsWorkScheduleCheckResult.builder().match(false).build();
            }
        }
        return CsWorkScheduleCheckResult.builder().match(true).build();
    }

    private CsWorkScheduleCheckResult buildNoWorkingResult() {
        this.niccCsmConfigProperties.getNoWorkingTimeLeaveMsg();
        return CsWorkScheduleCheckResult.builder().isLeaveMsg(this.niccCsmConfigProperties.getNoWorkingTimeLeaveMsg().booleanValue()).alertContent(this.niccCsmConfigProperties.getNoWorkingTimeContent()).match(false).build();
    }

    private void checkIsHoliday(List<CsWorkScheduleBO> schedules) {
        for (CsWorkScheduleBO schedule : schedules) {
            if (!CsScheduleType.UNIQUE.getCode().equals(schedule.getScheduleType()) || !"\u4f11\u606f\u65e5".equals(schedule.getRemark()) || !CsWorkScheduleCommonServiceImpl.checkInDayRange(schedule)) continue;
            log.info("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u5339\u914d\u5230\u8282\u5047\u65e5:{}", (Object)schedule);
            throw new CsNoWorkingException("\u975e\u5de5\u4f5c\u65f6\u95f4:" + schedule.getWorkDays() + "-" + schedule.getWorkStartTimes() + "," + schedule.getWorkEndTimes());
        }
    }

    private boolean checkIsWork(CsWorkScheduleBO scheduleBO) {
        if (CsScheduleType.NORMAL.getCode().equals(scheduleBO.getScheduleType())) {
            return this.checkInWeek(scheduleBO);
        }
        if (CsScheduleType.UNIQUE.getCode().equals(scheduleBO.getScheduleType()) && "\u5de5\u4f5c\u65e5".equals(scheduleBO.getRemark())) {
            return CsWorkScheduleCommonServiceImpl.checkInDayRange(scheduleBO);
        }
        return false;
    }

    private static boolean checkInDayRange(CsWorkScheduleBO scheduleBO) {
        try {
            boolean inDay;
            LocalDateTime localDateTime = LocalDateTime.now();
            String startDate = scheduleBO.getWorkDays().split("\\|")[0];
            String endDate = scheduleBO.getWorkDays().split("\\|")[1];
            LocalDate start = LocalDate.parse(startDate);
            LocalDate end = LocalDate.parse(endDate);
            LocalDate now = LocalDate.now();
            boolean bl = inDay = now.isEqual(start) || now.isEqual(end) || now.isAfter(start) && now.isBefore(end);
            if (inDay) {
                return CsWorkScheduleCommonServiceImpl.checkInTime(scheduleBO.getWorkStartTimes(), scheduleBO.getWorkEndTimes(), localDateTime);
            }
        }
        catch (Exception e) {
            log.error("\u5de5\u4f5c\u65f6\u95f4\u5339\u914d-\u65e5\u671f\u683c\u5f0f\u5f02\u5e38:{}", (Object)scheduleBO, (Object)e);
        }
        return false;
    }

    private boolean checkInWeek(CsWorkScheduleBO scheduleBO) {
        LocalDateTime localDateTime = LocalDateTime.now();
        String today = "w" + localDateTime.getDayOfWeek().getValue();
        if (StringUtils.isNotEmpty((CharSequence)scheduleBO.getWorkDays()) && scheduleBO.getWorkDays().contains(today)) {
            return CsWorkScheduleCommonServiceImpl.checkInTime(scheduleBO.getWorkStartTimes(), scheduleBO.getWorkEndTimes(), localDateTime);
        }
        return false;
    }

    private static boolean checkInTime(String workStartTimes, String workEndTimes, LocalDateTime localDateTime) {
        Integer hour = localDateTime.getHour();
        Integer minute = localDateTime.getMinute();
        String[] workStartTimesArr = workStartTimes.split("\\||,");
        String[] workEndTimesArr = workEndTimes.split("\\||,");
        for (int i = 0; i < workStartTimesArr.length; ++i) {
            String startTime = workStartTimesArr[i];
            String endTime = workEndTimesArr[i];
            boolean isInTime = CsWorkScheduleCommonServiceImpl.isTimeRange(startTime, endTime, hour, minute);
            if (!isInTime) continue;
            return true;
        }
        return false;
    }

    public static boolean isTimeRange(String startTime, String endTime, int nowHour, int nowMinute) {
        LocalTime nowTime = LocalTime.of(nowHour, nowMinute);
        int startHour = CsWorkScheduleCommonServiceImpl.getHourOrMinute(startTime, true);
        int startMinute = CsWorkScheduleCommonServiceImpl.getHourOrMinute(startTime, false);
        LocalTime startTimeLocal = LocalTime.of(startHour, startMinute);
        int endHour = CsWorkScheduleCommonServiceImpl.getHourOrMinute(endTime, true);
        int endMinute = CsWorkScheduleCommonServiceImpl.getHourOrMinute(endTime, false);
        LocalTime endTimeLocal = LocalTime.of(endHour, endMinute);
        if (nowTime.isAfter(startTimeLocal) && endTimeLocal.isAfter(nowTime)) {
            return true;
        }
        return nowTime.equals(startTimeLocal) || endTimeLocal.equals(nowTime);
    }

    private static int getHourOrMinute(String time, boolean hour) {
        if (hour) {
            return Integer.parseInt(time.substring(0, time.indexOf(":")));
        }
        return Integer.parseInt(time.substring(time.indexOf(":") + 1));
    }
}

