/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.api.ChatSessionService;
import com.tydic.nicc.common.bo.session.GetUserActiveSessionReqBO;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsChannelType;
import com.tydic.nicc.csm.api.bo.channel.CsChannelBO;
import com.tydic.nicc.csm.api.bo.channel.CsChannelQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotStrategyBO;
import com.tydic.nicc.csm.api.bo.cs.CsAllotTransferRecordBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsInfoQueryReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsItemCacheBO;
import com.tydic.nicc.csm.api.bo.cs.CsStrategyReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleBO;
import com.tydic.nicc.csm.api.bo.cs.CsWorkScheduleQueryReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupBO;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupReqBO;
import com.tydic.nicc.csm.api.bo.skill.CsStatusExtendBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsAllotRecordMapper;
import com.tydic.nicc.csm.mapper.CsAllotStrategyMapper;
import com.tydic.nicc.csm.mapper.CsAllotTransferRecordMapper;
import com.tydic.nicc.csm.mapper.CsAutoReplyConfigMapper;
import com.tydic.nicc.csm.mapper.CsChannelMapper;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.CsLabelRelMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.CsStatusExtendMapper;
import com.tydic.nicc.csm.mapper.CsWorkScheduleMapper;
import com.tydic.nicc.csm.mapper.po.CsAllotRecord;
import com.tydic.nicc.csm.mapper.po.CsAllotStrategyQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsAllotTransferRecord;
import com.tydic.nicc.csm.mapper.po.CsAutoReplyConfig;
import com.tydic.nicc.csm.mapper.po.CsAutoReplyConfigQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsChannel;
import com.tydic.nicc.csm.mapper.po.CsChannelQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.csm.mapper.po.CsSkillGroupQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsStatusExtend;
import com.tydic.nicc.csm.mapper.po.CsWorkSchedule;
import com.tydic.nicc.csm.mapper.po.CsWorkScheduleQueryCondition;
import com.tydic.nicc.csm.utils.LocalCacheSyncHelper;
import com.tydic.nicc.csm.utils.LocalCacheUtil;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsmCommonServiceImpl
implements CsmCommonService {
    private static final Logger log = LoggerFactory.getLogger(CsmCommonServiceImpl.class);
    @Resource
    private CsSkillGroupMapper csSkillGroupMapper;
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private CsLabelRelMapper csLabelRelMapper;
    @Resource
    private CsAllotStrategyMapper csAllotStrategyMapper;
    @Resource
    private CsStatusExtendMapper csStatusExtendMapper;
    @Resource
    private CsWorkScheduleMapper csWorkScheduleMapper;
    @Resource
    private CsChannelMapper csChannelMapper;
    @Resource
    private CsAutoReplyConfigMapper csAutoReplyConfigMapper;
    @Resource
    private CsAllotTransferRecordMapper csAllotTransferRecordMapper;
    @Resource
    private CsAllotRecordMapper csAllotRecordMapper;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private LocalCacheSyncHelper localCacheSyncHelper;
    @Resource
    private CsmItemCountService csmItemCountService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionService chatSessionService;

    @Override
    public List<CsInfo> getOnlineCsList() {
        return this.csInfoMapper.selectOnlineList();
    }

    @Override
    public RspList getCsStatusList(String tenantCode) {
        List csStatusExtends = this.csStatusExtendMapper.selectByTenantCode(tenantCode);
        ArrayList list = Lists.newArrayList();
        NiccCommonUtil.copyList((List)csStatusExtends, (List)list, CsStatusExtendBO.class);
        return BaseRspUtils.createSuccessRspList((List)csStatusExtends, (long)list.size());
    }

    @Override
    public List<String> getCsIdsByLabel(String tenantCode, String labelId) {
        return this.csLabelRelMapper.selectCsIdsByLabel(tenantCode, labelId);
    }

    @Override
    public List<CsAutoReplyConfigBO> getAutoReplyConfig(String tenantCode, String replyType) {
        log.info("\u67e5\u8be2\u81ea\u52a8\u56de\u590d\u914d\u7f6e: tenantCode = {}, replyType = {}", (Object)tenantCode, (Object)replyType);
        String key = RedisCacheKeyConstant.getCsmAutoReplyConfigKey((String)tenantCode, (String)replyType);
        List configBOS = LocalCacheUtil.AUTO_REPLY.get(key);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{configBOS}) && !configBOS.isEmpty()) {
            return configBOS;
        }
        CsAutoReplyConfigQueryReqBO queryReqBO = new CsAutoReplyConfigQueryReqBO();
        queryReqBO.setTenantCode(tenantCode);
        queryReqBO.setReplyType(replyType);
        queryReqBO.setLimit(9999);
        queryReqBO.setIsValid(EntityValidType.NORMAL.getCode());
        RspList<CsAutoReplyConfigBO> configBORspList = this.getCsAutoReplyConfigs(queryReqBO);
        if (configBORspList.getCount() > 0L) {
            LocalCacheUtil.AUTO_REPLY.put(key, configBORspList.getRows());
        }
        configBOS = configBORspList.getRows();
        log.info("\u67e5\u8be2\u81ea\u52a8\u56de\u590d\u914d\u7f6e: {} \u6761", (Object)configBOS.size());
        return configBOS;
    }

    @Override
    @MethodParamVerifyEnable
    @Transactional
    public void updateCsAllotServiceEnd(CsAllotRecordUpdateReqBO updateReqBO) {
        log.info("\u66f4\u65b0\u5750\u5e2d\u670d\u52a1\u7ed3\u675f\u65f6\u95f4:{}", (Object)updateReqBO);
        try {
            CsAllotRecord record;
            String skillGid = updateReqBO.getSkillGid();
            if (StringUtils.isEmpty((CharSequence)updateReqBO.getSkillGid()) && (record = this.csAllotRecordMapper.selectBySessionId(updateReqBO.getTenantCode(), updateReqBO.getSessionId())) != null) {
                skillGid = record.getAllotSkillGid();
            }
            record = new CsAllotRecord();
            BeanUtils.copyProperties((Object)updateReqBO, (Object)record);
            int i = this.csAllotRecordMapper.updateBySessionId(record);
            if (i == 0) {
                CsAllotTransferRecord transferRecord = new CsAllotTransferRecord();
                BeanUtils.copyProperties((Object)updateReqBO, (Object)transferRecord);
                this.csAllotTransferRecordMapper.updateBySessionId(transferRecord);
            }
            this.csmItemCountService.skillServiceEnd(updateReqBO.getTenantCode(), skillGid, updateReqBO.getSessionId());
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u5750\u5e2d\u670d\u52a1\u65f6\u95f4\u5f02\u5e38: sessionId = {}", (Object)updateReqBO.getSessionId(), (Object)e);
        }
    }

    @Override
    @MethodParamVerifyEnable
    @Transactional
    public void saveCsAllotRecord(CsAllotRecordBO csAllotRecordBO) {
        CsAllotRecord record = new CsAllotRecord();
        BeanUtils.copyProperties((Object)csAllotRecordBO, (Object)record);
        this.csAllotRecordMapper.insertSelective(record);
    }

    @Override
    public int countRecentlyAllot(String tenantCode, String csId, String userId, int minutes) {
        Date startTime = DateTimeUtil.DateAddMinute((int)(-minutes));
        return this.csAllotRecordMapper.countReceivedByStartTime(tenantCode, "", csId, userId, startTime);
    }

    @Override
    public String getRecentlyServiceCsId(String tenantCode, String skillGid, String userId, int minutes) {
        Date startTime = DateTimeUtil.DateAddMinute((int)(-minutes));
        return this.csAllotRecordMapper.selectLeastReceivedCsIdByStartTime(tenantCode, skillGid, userId, startTime);
    }

    @Override
    @MethodParamVerifyEnable
    @Transactional
    public void saveCsAllotTransferRecord(CsAllotTransferRecordBO transferRecordBO) {
        CsAllotTransferRecord record = new CsAllotTransferRecord();
        BeanUtils.copyProperties((Object)transferRecordBO, (Object)record);
        this.csAllotTransferRecordMapper.insertSelective(record);
    }

    @Override
    public CsStatusExtendBO getCsExtendStatus(String tenantCode, String statusCode) {
        CsStatusExtend extend = this.csStatusExtendMapper.selectByTenantCodeAndStatus(tenantCode, statusCode);
        if (extend != null) {
            CsStatusExtendBO extendBO = new CsStatusExtendBO();
            BeanUtils.copyProperties((Object)extend, (Object)extendBO);
            return extendBO;
        }
        return null;
    }

    @Override
    public List<CsSkillGroupInfo> getCsSkillGidList(String tenantCode, String csId, boolean cache) {
        Rsp csItemRsp;
        List list = Lists.newArrayList();
        if (cache && (csItemRsp = this.csmItemCountService.getCsAllotItem(tenantCode, csId)).isSuccess()) {
            list = ((CsItemCacheBO)csItemRsp.getData()).getCsSkillGroups();
        }
        if (list == null || list.isEmpty()) {
            List groups = this.csInfoMapper.selectCsGids(tenantCode, csId);
            NiccCommonUtil.copyList((List)groups, (List)list, CsSkillGroupInfo.class);
            log.info("\u67e5\u8be2\u5ba2\u670d\u6240\u5c5e\u6280\u80fd\u7ec4:{},{},{}", new Object[]{tenantCode, csId, list});
        }
        return list;
    }

    @Override
    public int countOnlineCs(String tenantCode, String skillGid) {
        return this.csInfoMapper.countOnlineBySkill(tenantCode, skillGid);
    }

    @Override
    public Integer receivedCount(String tenantCode, String skillGid, String csId, boolean queryToday) {
        if (queryToday) {
            int allotReceived = this.csAllotRecordMapper.countReceivedToday(tenantCode, skillGid, csId, Boolean.valueOf(false));
            int transferReceived = this.csAllotTransferRecordMapper.countReceivedToday(tenantCode, skillGid, csId, Boolean.valueOf(false));
            return allotReceived + transferReceived;
        }
        int allotReceived = this.csAllotRecordMapper.countReceived(tenantCode, skillGid, csId, null, null, Boolean.valueOf(false));
        int transferReceived = this.csAllotTransferRecordMapper.countReceived(tenantCode, skillGid, csId, null, null, Boolean.valueOf(false));
        return allotReceived + transferReceived;
    }

    @Override
    public Integer receivedCount(String tenantCode, String skillGid, String csId, Date startDate, Date endDate) {
        int allotReceived = this.csAllotRecordMapper.countReceived(tenantCode, skillGid, csId, startDate, endDate, Boolean.valueOf(false));
        int transferReceived = this.csAllotTransferRecordMapper.countReceived(tenantCode, skillGid, csId, startDate, endDate, Boolean.valueOf(false));
        return allotReceived + transferReceived;
    }

    @Override
    public Integer skillReceivingCount(String tenantCode, String skillGid) {
        int allotReceived = this.csAllotRecordMapper.countReceivedToday(tenantCode, skillGid, null, Boolean.valueOf(true));
        int transferReceived = this.csAllotTransferRecordMapper.countReceivedToday(tenantCode, skillGid, null, Boolean.valueOf(true));
        return allotReceived + transferReceived;
    }

    @Override
    public Integer skillReceivedCount(String tenantCode, String skillGid, boolean queryToday) {
        if (queryToday) {
            int allotReceived = this.csAllotRecordMapper.countSkillReceivedToday(tenantCode, skillGid);
            int transferReceived = this.csAllotTransferRecordMapper.countSkillReceivedToday(tenantCode, skillGid);
            return allotReceived + transferReceived;
        }
        int allotReceived = this.csAllotRecordMapper.countSkillReceived(tenantCode, skillGid, null, null);
        int transferReceived = this.csAllotTransferRecordMapper.countSkillReceived(tenantCode, skillGid, null, null);
        return allotReceived + transferReceived;
    }

    @Override
    public Integer skillReceivedCount(String tenantCode, String skillGid, Date startDate, Date endDate) {
        int allotReceived = this.csAllotRecordMapper.countSkillReceived(tenantCode, skillGid, startDate, endDate);
        int transferReceived = this.csAllotTransferRecordMapper.countSkillReceived(tenantCode, skillGid, startDate, endDate);
        return allotReceived + transferReceived;
    }

    @Override
    public Integer receivingCount(String tenantCode, String csId) {
        return this.receivingSessions(tenantCode, csId).size();
    }

    @Override
    public Integer receivingCount(String tenantCode, String csId, boolean cache) {
        if (cache) {
            return this.receivingSessions(tenantCode, csId).size();
        }
        int allotReceived = this.csAllotRecordMapper.countReceivedToday(tenantCode, null, csId, Boolean.valueOf(true));
        int transferReceived = this.csAllotTransferRecordMapper.countReceivedToday(tenantCode, null, csId, Boolean.valueOf(true));
        return allotReceived + transferReceived;
    }

    @Override
    public List<String> receivingSessions(String tenantCode, String csId) {
        GetUserActiveSessionReqBO sessionReqBO = new GetUserActiveSessionReqBO(tenantCode, csId, false);
        try {
            Set sessions = (Set)this.chatSessionService.getUserActiveSessions(sessionReqBO).getData();
            if (ObjectUtils.anyNotNull((Object[])new Object[]{sessions})) {
                log.info("\u67e5\u8be2\u5ba2\u670d\u6d3b\u52a8\u4f1a\u8bdd-\u6b63\u5728\u63a5\u5f85\u7684\u4f1a\u8bdd\u6570:{}-{}", (Object)csId, (Object)sessions.size());
                return sessions.stream().map(Object::toString).collect(Collectors.toList());
            }
            return new ArrayList<String>();
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u670d\u6d3b\u52a8\u4f1a\u8bdd-\u5f02\u5e38:", (Throwable)e);
            throw new RuntimeException("\u67e5\u8be2\u5ba2\u670d\u6d3b\u52a8\u4f1a\u8bdd\u5f02\u5e38");
        }
    }

    @Override
    public List<CsAllotStrategyBO> getCsAllotStrategyList(CsStrategyReqBO csStrategyReqBO) {
        CsAllotStrategyQueryCondition condition = new CsAllotStrategyQueryCondition();
        condition.setTenantCode(csStrategyReqBO.getTenantCode());
        condition.setChannelCode(csStrategyReqBO.getChannelCode());
        log.info("\u6761\u4ef6\u67e5\u8be2\u5ba2\u670d\u5206\u914d\u7b56\u7565:{}", (Object)condition);
        List csAllotStrategies = this.csAllotStrategyMapper.selectByCondition(condition);
        ArrayList strategyBOS = Lists.newArrayList();
        NiccCommonUtil.copyList((List)csAllotStrategies, (List)strategyBOS, CsAllotStrategyBO.class);
        return strategyBOS;
    }

    @Override
    public CsInfoBO getCsInfo(String csId) {
        log.info("\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f:{}", (Object)csId);
        CsInfo csInfo = this.csInfoMapper.selectByPrimaryKey(csId);
        if (csInfo != null) {
            CsInfoBO csInfoBO = new CsInfoBO();
            BeanUtils.copyProperties((Object)csInfo, (Object)csInfoBO);
            List csStatusExtends = this.csStatusExtendMapper.selectByTenantCode(csInfo.getTenantCode());
            if (csStatusExtends == null || csStatusExtends.isEmpty()) {
                log.error("\u672a\u67e5\u8be2\u5230\u79df\u6237\u5ba2\u670d\u5728\u7ebf\u72b6\u6001\u914d\u7f6e:tenantCode = ", (Object)csInfo.getTenantCode());
            }
            ArrayList extendBOs = Lists.newArrayList();
            NiccCommonUtil.copyList((List)csStatusExtends, (List)extendBOs, CsStatusExtendBO.class);
            csInfoBO.setCsStatusList((List)extendBOs);
            int receiving = this.receivingCount(csInfo.getTenantCode(), csInfo.getCsId());
            csInfoBO.setReceivingCount(receiving);
            return csInfoBO;
        }
        return null;
    }

    @Override
    public List<CsInfoBO> getCsListBySkillId(CsInfoQueryReqBO csInfoReqBO) {
        ArrayList csInfoBOS = Lists.newArrayList();
        List csInfos = this.csInfoMapper.selectBySkillGid(csInfoReqBO.getTenantCode(), csInfoReqBO.getSkillGid(), csInfoReqBO.getLiveOnlineStatus());
        NiccCommonUtil.copyList((List)csInfos, (List)csInfoBOS, CsInfoBO.class);
        return csInfoBOS;
    }

    @Override
    public CsSkillGroupBO getSkillGroupInfo(String skillGid) {
        CsSkillGroup skillGroup = this.csSkillGroupMapper.selectByPrimaryKey(skillGid);
        if (skillGroup != null) {
            CsSkillGroupBO groupBO = new CsSkillGroupBO();
            BeanUtils.copyProperties((Object)skillGroup, (Object)groupBO);
            return groupBO;
        }
        return null;
    }

    @Override
    public List<CsSkillGroupBO> getSkillGroups(CsSkillGroupReqBO skillGroupReqBO) {
        ArrayList list = Lists.newArrayList();
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        BeanUtils.copyProperties((Object)skillGroupReqBO, (Object)condition);
        log.info("\u6761\u4ef6\u67e5\u8be2\u6280\u80fd\u7ec4:{}", (Object)condition);
        List csSkillGroups = this.csSkillGroupMapper.selectByCondition(condition);
        NiccCommonUtil.copyList((List)csSkillGroups, (List)list, CsSkillGroupBO.class);
        return list;
    }

    @Override
    @Transactional
    public void saveCsWorkSchedule(List<CsWorkScheduleBO> csWorkScheduleBOS) {
        log.info("\u4fdd\u5b58\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e:{}", csWorkScheduleBOS);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{csWorkScheduleBOS})) {
            for (CsWorkScheduleBO csWorkScheduleBO : csWorkScheduleBOS) {
                if (StringUtils.isEmpty((CharSequence)csWorkScheduleBO.getTenantCode()) || StringUtils.isEmpty((CharSequence)csWorkScheduleBO.getConfigLevel()) || StringUtils.isEmpty((CharSequence)csWorkScheduleBO.getConfigLevelVal()) || StringUtils.isEmpty((CharSequence)csWorkScheduleBO.getScheduleType())) {
                    log.warn("\u4fdd\u5b58\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e\uff0c\u53c2\u6570\u9519\u8bef:{}", (Object)csWorkScheduleBO);
                    continue;
                }
                this.csWorkScheduleMapper.deleteByLevelAndVal(csWorkScheduleBO.getTenantCode(), csWorkScheduleBO.getConfigLevel(), csWorkScheduleBO.getConfigLevelVal());
            }
            for (CsWorkScheduleBO csWorkScheduleBO : csWorkScheduleBOS) {
                csWorkScheduleBO.setUpdateTime(new Date());
                CsWorkSchedule schedule = new CsWorkSchedule();
                BeanUtils.copyProperties((Object)csWorkScheduleBO, (Object)schedule);
                schedule.setId("" + IdWorker.nextAutoId());
                this.csWorkScheduleMapper.insertSelective(schedule);
            }
        }
    }

    @Override
    public RspList<CsWorkScheduleBO> getCsWorkSchedules(CsWorkScheduleQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u5ba2\u670d\u5de5\u4f5c\u65f6\u95f4\u914d\u7f6e:{}", (Object)queryReqBO);
        ArrayList workScheduleBOS = Lists.newArrayList();
        CsWorkScheduleQueryCondition queryCondition = new CsWorkScheduleQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)queryCondition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csWorkScheduleMapper.selectByCondition(queryCondition);
        NiccCommonUtil.copyList((List)page.getResult(), (List)workScheduleBOS, CsWorkScheduleBO.class);
        return BaseRspUtils.createSuccessRspList((List)workScheduleBOS, (long)page.getTotal());
    }

    @Override
    public void saveCsAutoReplyConfigs(List<CsAutoReplyConfigBO> autoReplyConfigBOS) {
        log.info("\u4fdd\u5b58\u81ea\u52a8\u5e94\u7b54\u914d\u7f6e:{}", autoReplyConfigBOS);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{autoReplyConfigBOS})) {
            for (CsAutoReplyConfigBO configBO : autoReplyConfigBOS) {
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{configBO.getTenantCode(), configBO.getConfigLevelVal(), configBO.getReplyType()})) {
                    log.warn("\u4fdd\u5b58\u81ea\u52a8\u5e94\u7b54\u914d\u7f6e\u5f02\u5e38\uff0c\u53c2\u6570\u9519\u8bef:{}", (Object)configBO);
                    continue;
                }
                String key = RedisCacheKeyConstant.getCsmAutoReplyConfigKey((String)configBO.getTenantCode(), (String)configBO.getReplyType());
                LocalCacheUtil.AUTO_REPLY.remove(key);
                this.csAutoReplyConfigMapper.deleteByLevelAndVal(configBO.getTenantCode(), configBO.getReplyType(), configBO.getConfigLevelVal());
                this.localCacheSyncHelper.clearAutoReplyCache(configBO.getTenantCode(), key);
                if (!EntityValidType.NORMAL.getCode().equals(configBO.getIsValid()) || !StringUtils.isNotBlank((CharSequence)configBO.getReplyContent())) continue;
                configBO.setUpdateTime(new Date());
                CsAutoReplyConfig autoReplyConfig = new CsAutoReplyConfig();
                BeanUtils.copyProperties((Object)configBO, (Object)autoReplyConfig);
                autoReplyConfig.setId(Long.valueOf(IdWorker.nextAutoId()));
                this.csAutoReplyConfigMapper.insertSelective(autoReplyConfig);
            }
        }
    }

    @Override
    public RspList<CsAutoReplyConfigBO> getCsAutoReplyConfigs(CsAutoReplyConfigQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u81ea\u52a8\u5e94\u7b54\u914d\u7f6e\u5217\u8868:{}", (Object)queryReqBO);
        ArrayList replyConfigBOS = Lists.newArrayList();
        CsAutoReplyConfigQueryCondition queryCondition = new CsAutoReplyConfigQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)queryCondition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csAutoReplyConfigMapper.selectByCondition(queryCondition);
        NiccCommonUtil.copyList((List)page.getResult(), (List)replyConfigBOS, CsAutoReplyConfigBO.class);
        return BaseRspUtils.createSuccessRspList((List)replyConfigBOS, (long)page.getTotal());
    }

    @Override
    public RspList<CsChannelBO> getChannelList(CsChannelQueryReqBO queryReqBO) {
        log.info("\u67e5\u8be2\u6e20\u9053\u5217\u8868:{}", (Object)queryReqBO);
        ArrayList channelBOS = Lists.newArrayList();
        CsChannelQueryCondition queryCondition = new CsChannelQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)queryCondition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csChannelMapper.selectByCondition(queryCondition);
        NiccCommonUtil.copyList((List)page.getResult(), (List)channelBOS, CsChannelBO.class);
        return BaseRspUtils.createSuccessRspList((List)channelBOS, (long)page.getTotal());
    }

    @Override
    public void saveTwoDefaultChannel(CsSkillGroup skillGroup) {
        if (StringUtils.isNotEmpty((CharSequence)skillGroup.getSkillGroupTag())) {
            CsChannel csChannel = new CsChannel();
            csChannel.setId(Long.valueOf(IdWorker.nextAutoId()));
            String channelH5Code = CsChannelType.H5.getCode() + skillGroup.getSkillGid();
            this.csChannelMapper.deleteByChannelCode(skillGroup.getTenantCode(), channelH5Code);
            String accessH5Url = "";
            try {
                URIBuilder uriBuilder = new URIBuilder(this.niccCsmConfigProperties.getImAccessPrefix());
                uriBuilder.addParameter("channelCode", channelH5Code);
                accessH5Url = uriBuilder.toString();
            }
            catch (URISyntaxException e) {
                log.error("\u6e20\u9053PC\u8bbf\u95ee\u94fe\u63a5\u6784\u9020\u9519\u8bef:", (Throwable)e);
            }
            csChannel.setTenantCode(skillGroup.getTenantCode());
            csChannel.setChannelCode(channelH5Code);
            csChannel.setAccessUrl(accessH5Url);
            csChannel.setChannelType(CsChannelType.H5.getCode());
            csChannel.setChannelName(channelH5Code);
            csChannel.setUpdateTime(new Date());
            csChannel.setIsValid(EntityValidType.NORMAL.getCode());
            CsChannel csChannel2 = new CsChannel();
            BeanUtils.copyProperties((Object)csChannel, (Object)csChannel2);
            String channelPCCode = CsChannelType.PC.getCode() + skillGroup.getSkillGid();
            this.csChannelMapper.deleteByChannelCode(skillGroup.getTenantCode(), channelPCCode);
            String accessPCUrl = "";
            try {
                URIBuilder uriBuilder = new URIBuilder(this.niccCsmConfigProperties.getImAccessPrefix());
                uriBuilder.addParameter("channelCode", channelPCCode);
                accessPCUrl = uriBuilder.toString();
            }
            catch (URISyntaxException e) {
                log.error("\u6e20\u9053H5\u8bbf\u95ee\u94fe\u63a5\u6784\u9020\u9519\u8bef:", (Throwable)e);
            }
            csChannel2.setId(Long.valueOf(IdWorker.nextAutoId()));
            csChannel2.setChannelCode(channelPCCode);
            csChannel2.setAccessUrl(accessPCUrl);
            csChannel2.setChannelType(CsChannelType.PC.getCode());
            csChannel2.setChannelName(channelPCCode);
            csChannel2.setUpdateTime(new Date());
            this.csChannelMapper.insertSelective(csChannel);
            this.csChannelMapper.insertSelective(csChannel2);
        }
    }

    @Override
    public CsChannelBO getChannelByCode(String tenantCode, String channelCode) {
        CsChannel csChannel = this.csChannelMapper.selectByChannelCode(tenantCode, channelCode);
        if (csChannel != null) {
            CsChannelBO csChannelBO = new CsChannelBO();
            BeanUtils.copyProperties((Object)csChannel, (Object)csChannelBO);
            return csChannelBO;
        }
        return null;
    }

    @Override
    public Map<String, Object> loadFormDataByRequestId(String requestId) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String cacheKey = RedisCacheKeyConstant.getImRequestFormDataCacheKey((String)requestId);
        Map formData = this.redisHelper.hmget(cacheKey);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{formData})) {
            for (Map.Entry obj : formData.entrySet()) {
                retMap.put((String)obj.getKey(), obj.getValue());
            }
        }
        return retMap;
    }

    @Override
    public void delFormDataByRequestId(String requestId) {
        String cacheKey = RedisCacheKeyConstant.getImRequestFormDataCacheKey((String)requestId);
        this.redisHelper.del(new String[]{cacheKey});
    }

    @Override
    public void delFormDataByUserId(String userId) {
        String cacheKey = RedisCacheKeyConstant.getImUserRequestIdCacheKey((String)userId);
        String requestId = (String)this.redisHelper.get(cacheKey);
        if (StringUtils.isNotEmpty((CharSequence)requestId)) {
            this.delFormDataByRequestId(requestId);
            this.redisHelper.del(new String[]{cacheKey});
        }
    }
}

