/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.api.ChatSessionAdminService;
import com.tydic.nicc.common.constants.RedisCacheKeyConstant;
import com.tydic.nicc.common.eums.EntityValidType;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.csm.CsState;
import com.tydic.nicc.csm.api.bo.cs.CsItemCacheBO;
import com.tydic.nicc.csm.api.bo.cs.CsmOnlineItemsReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsmWorkItemsReqBO;
import com.tydic.nicc.csm.api.bo.eum.CsWorkItemsType;
import com.tydic.nicc.csm.api.bo.skill.CsSkillGroupInfo;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmItemCountService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupMapper;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.csm.mapper.po.CsInfoQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsSkillGroup;
import com.tydic.nicc.csm.mapper.po.CsSkillGroupQueryCondition;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@DS(value="nicc-csm")
@Service
public class CsmItemCountServiceImpl
implements CsmItemCountService {
    private static final Logger log = LoggerFactory.getLogger(CsmItemCountServiceImpl.class);
    private CsmCommonService csmCommonService;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsSkillGroupMapper csSkillGroupMapper;
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private RedisHelper redisHelper;
    private CsmCsAllotHelper csmCsAllotHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ChatSessionAdminService chatSessionAdminService;

    @Lazy
    @Autowired
    public void setCsmCommonService(CsmCommonService csmCommonService) {
        this.csmCommonService = csmCommonService;
    }

    @Lazy
    @Autowired
    public void setCsmCsAllotHelper(CsmCsAllotHelper csmCsAllotHelper) {
        this.csmCsAllotHelper = csmCsAllotHelper;
    }

    @Override
    public Iterable<String> reloadSkillReceivedTodayCache(String tenantCode, Iterable<String> skillGids) {
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u5df2\u63a5\u5f85\u6570\u7f13\u5b58-\u5f00\u59cb:tenantCode = {},skillGids = {}", (Object)tenantCode, skillGids);
        long start = System.currentTimeMillis();
        if (skillGids == null || !skillGids.iterator().hasNext()) {
            skillGids = this.loadSkillGids(tenantCode);
        }
        for (String skillId : skillGids) {
            String today = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
            String key = RedisCacheKeyConstant.getCsmItemSkillTodayReceivedKey((String)today, (String)skillId);
            Integer count = this.csmCommonService.skillReceivedCount(tenantCode, skillId, true);
            this.redisHelper.set(key, (Object)count, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
            log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u5df2\u63a5\u5f85\u6570\u7f13\u5b58: {}->{}", (Object)skillId, (Object)count);
        }
        long end = System.currentTimeMillis();
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u5df2\u63a5\u5f85\u6570\u7f13\u5b58-\u5b8c\u6210:tenantCode = {},skillGids = {}, {} ms", new Object[]{tenantCode, skillGids, end - start});
        return skillGids;
    }

    @Override
    public Iterable<String> reloadSkillReceivingCache(String tenantCode, Iterable<String> skillGids) {
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u4f1a\u8bdd\u7f13\u5b58-\u5f00\u59cb:tenantCode = {},skillGids = {}", (Object)tenantCode, skillGids);
        long start = System.currentTimeMillis();
        if (skillGids == null || !skillGids.iterator().hasNext()) {
            skillGids = this.loadSkillGids(tenantCode);
        }
        for (String skillGid : skillGids) {
            Rsp rsp = this.chatSessionAdminService.reloadSkillSessionActiveCache(tenantCode, skillGid);
            log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u4f1a\u8bdd\u7f13\u5b58: {}->{}", (Object)skillGid, rsp.getData());
        }
        long end = System.currentTimeMillis();
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u6280\u80fd\u7ec4\u4f1a\u8bdd\u7f13\u5b58-\u5b8c\u6210:tenantCode = {},skillGids = {}, {} ms", new Object[]{tenantCode, skillGids, end - start});
        return skillGids;
    }

    private Iterable<String> loadSkillGids(String tenantCode) {
        Iterable<String> skillGids = new ArrayList<String>();
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        condition.setTenantCode(tenantCode);
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        try {
            List csSkillGroups = this.csSkillGroupMapper.selectByCondition(condition);
            skillGids = csSkillGroups.stream().map(CsSkillGroup::getSkillGid).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u67e5\u8be2\u6280\u80fd\u7ec4\u5f02\u5e38:", (Throwable)e);
        }
        return skillGids;
    }

    @Override
    public Iterable<String> reloadCsReceivingCache(String tenantCode, Iterable<String> csIds) {
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u5ba2\u670d\u4f1a\u8bdd\u7f13\u5b58-\u5f00\u59cb:tenantCode = {},csIds = {}", (Object)tenantCode, csIds);
        long start = System.currentTimeMillis();
        List<CsInfo> csInfos = this.getCsList(tenantCode, csIds);
        for (CsInfo csInfo : csInfos) {
            Rsp rsp = this.chatSessionAdminService.reloadCsSessionActiveCache(tenantCode, csInfo.getCsId());
            log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u5ba2\u670d\u4f1a\u8bdd\u7f13\u5b58: {}->{}", (Object)csInfo.getCsId(), rsp.getData());
        }
        long end = System.currentTimeMillis();
        log.info("\u6307\u6807\u7edf\u8ba1-\u91cd\u5efa\u7f13\u5b58-\u5ba2\u670d\u4f1a\u8bdd\u7f13\u5b58-\u5b8c\u6210:tenantCode = {},csIds = {}, {} ms", new Object[]{tenantCode, csIds, end - start});
        return csIds;
    }

    private List<CsInfo> getCsList(String tenantCode, Iterable<String> csIds) {
        List<Object> csInfos = new ArrayList<CsInfo>();
        if (csIds != null && csIds.iterator().hasNext()) {
            for (String csId : csIds) {
                CsInfo csInfo = this.csInfoMapper.selectByPrimaryKey(csId);
                if (csInfo == null) continue;
                csInfos.add(csInfo);
            }
        } else {
            CsInfoQueryCondition condition = new CsInfoQueryCondition();
            condition.setCsState(CsState.NORMAL.getCode());
            condition.setTenantCode(tenantCode);
            Date countDay = DateTimeUtil.DateAddDayOfYear((int)-5);
            Date endTime = DateTimeUtil.createTime((Date)countDay, (int)0, (int)0, (int)0);
            condition.setStateStartTime(endTime);
            csInfos = this.csInfoMapper.selectByCondition(condition);
        }
        log.info("\u6307\u6807\u7edf\u8ba1-\u67e5\u8be2\u5230\u5ba2\u670d\u4fe1\u606f:tenantCode = {},size = {}", (Object)tenantCode, (Object)csInfos.size());
        return csInfos;
    }

    @Override
    public void countAllCsAllotItems(String tenantCode, Iterable<String> csIds) {
        this.countAllCsAllotItems(tenantCode, csIds, false);
    }

    @Override
    public void countAllCsAllotItems(String tenantCode, Iterable<String> csIds, boolean updateReceived) {
        log.info("\u6307\u6807\u7edf\u8ba1-\u5ba2\u670d\u63a5\u5f85\u6570-\u5f00\u59cb:tenantCode = {},csIds = {}", (Object)tenantCode, csIds);
        long start = System.currentTimeMillis();
        List<CsInfo> csInfos = this.getCsList(tenantCode, csIds);
        Date lastDate = DateTimeUtil.getStartTimeOfDay();
        for (CsInfo csInfo : csInfos) {
            CsItemCacheBO csItemCacheBO = null;
            String key = RedisCacheKeyConstant.getCsmItemCsReceivedKey((String)csInfo.getCsId());
            try {
                csItemCacheBO = (CsItemCacheBO)this.redisHelper.get(key);
            }
            catch (Exception e) {
                log.error("\u6307\u6807\u7edf\u8ba1-\u5ba2\u670d\u63a5\u5f85\u6570-\u5f02\u5e38:csId = {}", (Object)csInfo.getCsId(), (Object)e);
            }
            if (csItemCacheBO == null) {
                csItemCacheBO = new CsItemCacheBO();
            }
            ArrayList csSkillGroups = new ArrayList();
            List groups = this.csInfoMapper.selectCsGids(csInfo.getTenantCode(), csInfo.getCsId());
            NiccCommonUtil.copyList((List)groups, csSkillGroups, CsSkillGroupInfo.class);
            BeanUtils.copyProperties((Object)csInfo, (Object)csItemCacheBO);
            csItemCacheBO.setCsSkillGroups(csSkillGroups);
            if (updateReceived) {
                int receivedCountTotal = this.csmCommonService.receivedCount(csInfo.getTenantCode(), "", csInfo.getCsId(), null, lastDate);
                csItemCacheBO.setReceivedCountTotal(receivedCountTotal);
            }
            log.info("\u6307\u6807\u7edf\u8ba1-\u5ba2\u670d\u63a5\u5f85\u6570:{}", (Object)csItemCacheBO);
            this.redisHelper.set(key, (Object)csItemCacheBO);
        }
        long end = System.currentTimeMillis();
        log.info("\u6307\u6807\u7edf\u8ba1-\u5ba2\u670d\u63a5\u5f85\u6570-\u5b8c\u6210:{} \u6761, \u8017\u65f6 {} ms", (Object)csInfos.size(), (Object)(end - start));
    }

    @Override
    public void delAllotItem(String tenantCode, String csId) {
        String key = RedisCacheKeyConstant.getCsmItemCsReceivedKey((String)csId);
        this.redisHelper.del(new String[]{key});
    }

    @Override
    public Rsp getCsAllotItem(String tenantCode, String csId) {
        String key = RedisCacheKeyConstant.getCsmItemCsReceivedKey((String)csId);
        try {
            CsItemCacheBO csItemCacheBO = (CsItemCacheBO)this.redisHelper.get(key);
            if (csItemCacheBO == null) {
                this.countAllCsAllotItems(tenantCode, Collections.singletonList(csId));
                csItemCacheBO = (CsItemCacheBO)this.redisHelper.get(key);
            }
            return BaseRspUtils.createSuccessRsp((Object)csItemCacheBO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u5ba2\u670d\u63a5\u5f85\u6307\u6807-\u5f02\u5e38:{}", (Object)e.getMessage());
            return BaseRspUtils.createErrorRsp((String)e.getMessage());
        }
    }

    @Override
    public void countAllSkillReceivedTotal() {
        CsSkillGroupQueryCondition condition = new CsSkillGroupQueryCondition();
        condition.setIsValid(EntityValidType.NORMAL.getCode());
        log.info("\u6307\u6807\u7edf\u8ba1-\u6280\u80fd\u7ec4\u63a5\u5f85\u6570-\u5f00\u59cb:{}", (Object)condition);
        try {
            List csSkillGroups = this.csSkillGroupMapper.selectByCondition(condition);
            for (CsSkillGroup group : csSkillGroups) {
                Date endTime = DateTimeUtil.getStartTimeOfDay();
                int receivedCountTotal = this.csmCommonService.skillReceivedCount(group.getTenantCode(), group.getSkillGid(), null, endTime);
                String key = RedisCacheKeyConstant.getCsmItemSkillReceivedKey((String)group.getSkillGid());
                this.redisHelper.set(key, (Object)receivedCountTotal);
            }
            log.info("\u6307\u6807\u7edf\u8ba1-\u6280\u80fd\u7ec4\u63a5\u5f85\u6570-\u5b8c\u6210:{} \u6761", (Object)csSkillGroups.size());
        }
        catch (Exception e) {
            log.info("\u6307\u6807\u7edf\u8ba1-\u6280\u80fd\u7ec4\u63a5\u5f85\u6570-\u5f02\u5e38:", (Throwable)e);
        }
    }

    @Override
    public int getSkillReceivedTotal(String tenantCode, String skillId) {
        String key = RedisCacheKeyConstant.getCsmItemSkillReceivedKey((String)skillId);
        Integer historyTotal = (Integer)this.redisHelper.get(key);
        String today = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        String key2 = RedisCacheKeyConstant.getCsmItemSkillTodayReceivedKey((String)today, (String)skillId);
        Integer todayTotal = (Integer)this.redisHelper.get(key2);
        if (historyTotal == null) {
            historyTotal = 0;
        }
        if (todayTotal == null) {
            todayTotal = 0;
        }
        return todayTotal + historyTotal;
    }

    @Override
    public int getSkillReceivedToday(String tenantCode, String skillId, boolean includeReceiving) {
        String today = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        String key = RedisCacheKeyConstant.getCsmItemSkillTodayReceivedKey((String)today, (String)skillId);
        Integer todayTotal = (Integer)this.redisHelper.get(key);
        if (todayTotal == null) {
            todayTotal = this.csmCommonService.skillReceivedCount(tenantCode, skillId, true);
            this.redisHelper.set(key, (Object)todayTotal, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
        }
        if (includeReceiving) {
            long receiving = this.getSkillReceivingCount(skillId);
            todayTotal = todayTotal + Integer.valueOf("" + receiving);
        }
        return todayTotal;
    }

    @Override
    public long getSkillReceivingCount(String skillId) {
        String receivingKey = RedisCacheKeyConstant.getCsmItemSkillTodayReceivingKey((String)skillId);
        return this.redisHelper.sGetSetSize(receivingKey);
    }

    @Override
    @MethodParamVerifyEnable
    public Rsp getCsWorkItems(CsmWorkItemsReqBO reqBO) {
        List csSkillGroups;
        HashMap<String, Integer> itemVals = new HashMap<String, Integer>();
        String tenantCode = reqBO.getTenantCode();
        String csId = reqBO.getCsId();
        long start = System.currentTimeMillis();
        Rsp csItemCacheBO = this.getCsAllotItem(tenantCode, csId);
        int receivedAllCount = 0;
        log.info("\u5ba2\u670d\u5de5\u4f5c\u53f0\u6307\u6807\u67e5\u8be2-\u5f00\u59cb:{}", (Object)reqBO);
        if (csItemCacheBO.isSuccess() && csItemCacheBO.getData() != null) {
            csSkillGroups = ((CsItemCacheBO)csItemCacheBO.getData()).getCsSkillGroups();
            receivedAllCount = ((CsItemCacheBO)csItemCacheBO.getData()).getReceivedCountTotal();
        } else {
            csSkillGroups = this.csmCommonService.getCsSkillGidList(tenantCode, csId, false);
            log.info("\u5ba2\u670d\u5de5\u4f5c\u53f0\u6307\u6807\u67e5\u8be2-\u52a0\u8f7d\u6280\u80fd\u7ec4:{},{} ms", (Object)csSkillGroups.size(), (Object)(System.currentTimeMillis() - start));
        }
        for (String item : reqBO.getItems()) {
            int receivedCount;
            if (CsWorkItemsType.onlineDurationSec.matchCode(item)) {
                int signTimeSec = this.csmLogCommonService.countSignInTime(tenantCode, csId, CsOnlineStatus.CS_SIGN_IN.getCode());
                itemVals.put(CsWorkItemsType.onlineDurationSec.getCode(), signTimeSec);
                continue;
            }
            if (CsWorkItemsType.queueCount.matchCode(item)) {
                int queueCount = 0;
                for (CsSkillGroupInfo csSkillGroup : csSkillGroups) {
                    queueCount = (int)((long)queueCount + this.csmCsAllotHelper.getQueueCount(tenantCode, csSkillGroup.getSkillGid()));
                }
                itemVals.put(CsWorkItemsType.queueCount.getCode(), queueCount);
                continue;
            }
            if (CsWorkItemsType.receivingCount.matchCode(item)) {
                int receivingCount = this.csmCommonService.receivingCount(tenantCode, csId);
                itemVals.put(CsWorkItemsType.receivingCount.getCode(), receivingCount);
                continue;
            }
            if (CsWorkItemsType.receivedCount.matchCode(item)) {
                receivedCount = this.csmCommonService.receivedCount(tenantCode, null, csId, true);
                itemVals.put(CsWorkItemsType.receivedCount.getCode(), receivedCount);
                continue;
            }
            if (CsWorkItemsType.receivedAllCount.matchCode(item)) {
                receivedCount = this.csmCommonService.receivedCount(tenantCode, null, csId, true);
                itemVals.put(CsWorkItemsType.receivedAllCount.getCode(), receivedAllCount + receivedCount);
                continue;
            }
            if (CsWorkItemsType.receivingSkillCount.matchCode(item)) {
                int receivingSkillCount = 0;
                for (CsSkillGroupInfo group : csSkillGroups) {
                    receivingSkillCount = (int)((long)receivingSkillCount + this.getSkillReceivingCount(group.getSkillGid()));
                }
                itemVals.put(CsWorkItemsType.receivingSkillCount.getCode(), receivingSkillCount);
                continue;
            }
            if (CsWorkItemsType.receivedSkillCount.matchCode(item)) {
                int receivedSkillCount = 0;
                for (CsSkillGroupInfo group : csSkillGroups) {
                    receivedSkillCount += this.getSkillReceivedToday(tenantCode, group.getSkillGid(), false);
                }
                itemVals.put(CsWorkItemsType.receivedSkillCount.getCode(), receivedSkillCount);
                continue;
            }
            if (!CsWorkItemsType.receivedSkillAllCount.matchCode(item)) continue;
            int receivedSkillCountTotal = 0;
            for (CsSkillGroupInfo group : csSkillGroups) {
                receivedSkillCountTotal += this.getSkillReceivedTotal(tenantCode, group.getSkillGid());
            }
            itemVals.put(CsWorkItemsType.receivedSkillAllCount.getCode(), receivedSkillCountTotal);
        }
        long end = System.currentTimeMillis();
        log.info("\u5ba2\u670d\u5de5\u4f5c\u53f0\u6307\u6807\u67e5\u8be2-\u8017\u65f6:{} ms,{}", (Object)(end - start), itemVals);
        return BaseRspUtils.createSuccessRsp(itemVals, (String)(end - start + " ms"));
    }

    @Override
    public void skillAllotSuccess(String tenantCode, String skillId, String sessionId) {
        String receivingKey = RedisCacheKeyConstant.getCsmItemSkillTodayReceivingKey((String)skillId);
        this.redisHelper.sSetByExpire(receivingKey, (long)RedisCacheKeyConstant.ONE_DAY.intValue(), new Object[]{sessionId});
    }

    @Override
    public void skillServiceEnd(String tenantCode, String skillId, String sessionId) {
        String receivingKey = RedisCacheKeyConstant.getCsmItemSkillTodayReceivingKey((String)skillId);
        this.redisHelper.setRemove(receivingKey, new Object[]{sessionId});
        String today = DateTimeUtil.getTimeShortString((Date)new Date(), (String)"yyyyMMdd");
        String key = RedisCacheKeyConstant.getCsmItemSkillTodayReceivedKey((String)today, (String)skillId);
        if (this.redisHelper.hasKey(key)) {
            Integer count = this.csmCommonService.skillReceivedCount(tenantCode, skillId, true);
            this.redisHelper.set(key, (Object)count, (long)RedisCacheKeyConstant.ONE_DAY.intValue());
        } else {
            this.redisHelper.incr(key, 1L);
        }
    }

    @Override
    @MethodParamVerifyEnable
    public Rsp getOnlineItems(CsmOnlineItemsReqBO itemsReqBO) {
        HashMap<String, Integer> olItemMap = new HashMap<String, Integer>();
        long start = System.currentTimeMillis();
        for (String item : itemsReqBO.getItems()) {
            int signTimeSec = 0;
            signTimeSec = itemsReqBO.getIsCurrent() != false ? this.csmLogCommonService.countCurrentOnlineTime(itemsReqBO.getTenantCode(), itemsReqBO.getCsId(), item) : this.csmLogCommonService.countOnlineTime(itemsReqBO.getTenantCode(), itemsReqBO.getCsId(), item);
            olItemMap.put(item, signTimeSec);
        }
        long end = System.currentTimeMillis();
        log.info("\u5728\u7ebf\u65f6\u957f\u6307\u6807\u7edf\u8ba1-\u8017\u65f6:{} ms,req = {},items = {}", new Object[]{end - start, itemsReqBO, olItemMap});
        return BaseRspUtils.createSuccessRsp(olItemMap);
    }
}

