/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.baomidou.dynamic.datasource.annotation.DS;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.bo.csm.CsmUserQueueContext;
import com.tydic.nicc.common.bo.user.UserAccessLogBO;
import com.tydic.nicc.common.bo.user.UserAccessLogQueryReqBO;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.csm.CsQueueExitType;
import com.tydic.nicc.csm.api.bo.cs.CsReceivingChangeLogBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeContext;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeLogBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeLogSaveReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsStatusChangeQueryReqBO;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.mapper.CsInfoMapper;
import com.tydic.nicc.csm.mapper.CsReceivingChangeLogMapper;
import com.tydic.nicc.csm.mapper.CsSkillGroupQueueLogMapper;
import com.tydic.nicc.csm.mapper.CsStatusChangeLogMapper;
import com.tydic.nicc.csm.mapper.CsStatusExtendMapper;
import com.tydic.nicc.csm.mapper.po.CsInfo;
import com.tydic.nicc.csm.mapper.po.CsReceivingChangeLog;
import com.tydic.nicc.csm.mapper.po.CsSkillGroupQueueLog;
import com.tydic.nicc.csm.mapper.po.CsStatusChangeLog;
import com.tydic.nicc.csm.mapper.po.CsStatusChangeLogQueryCondition;
import com.tydic.nicc.csm.mapper.po.CsStatusExtend;
import com.tydic.nicc.csm.service.handler.CsStatusChangeHandler;
import com.tydic.nicc.dc.base.annotions.MethodParamVerifyEnable;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.entity.RedisLockEntity;
import com.tydic.nicc.dc.boot.starter.redis.RedisHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.user.api.UserAccessLogService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@DS(value="nicc-csm")
@Service
public class CsmLogCommonServiceImpl
implements CsmLogCommonService {
    private static final Logger log = LoggerFactory.getLogger(CsmLogCommonServiceImpl.class);
    @Resource
    private CsReceivingChangeLogMapper csReceivingChangeLogMapper;
    @Resource
    private CsStatusChangeLogMapper csStatusChangeLogMapper;
    @Resource
    private CsStatusExtendMapper csStatusExtendMapper;
    @Resource
    private CsSkillGroupQueueLogMapper csSkillGroupQueueLogMapper;
    @Resource
    private CsInfoMapper csInfoMapper;
    @Resource
    private RedisHelper redisHelper;
    @Resource
    private CsStatusChangeHandler csStatusChangeHandler;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserAccessLogService userAccessLogService;

    @Override
    public RspList getCsStatusChangeLogs(CsStatusChangeQueryReqBO queryReqBO) {
        ArrayList statusChangeLogs = Lists.newArrayList();
        CsStatusChangeLogQueryCondition condition = new CsStatusChangeLogQueryCondition();
        BeanUtils.copyProperties((Object)queryReqBO, (Object)condition);
        log.info("\u67e5\u8be2\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55:{}", (Object)condition);
        Page page = PageHelper.startPage((int)queryReqBO.getPage(), (int)queryReqBO.getLimit());
        this.csStatusChangeLogMapper.selectByCondition(condition);
        if (page.getTotal() > 0L) {
            NiccCommonUtil.copyList((List)page.getResult(), (List)statusChangeLogs, CsStatusChangeLogBO.class);
        }
        return BaseRspUtils.createSuccessRspList((List)statusChangeLogs, (long)page.getTotal());
    }

    @Override
    @Transactional
    @MethodParamVerifyEnable
    public void saveCsStatusChangeLog(CsStatusChangeLogSaveReqBO changeLogBO) {
        log.info("\u4fdd\u5b58\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55:{}", (Object)changeLogBO);
        CsStatusChangeLog currRecord = new CsStatusChangeLog();
        BeanUtils.copyProperties((Object)changeLogBO, (Object)currRecord);
        currRecord.setChangeId(IdWorker.nextAutoIdStr());
        currRecord.setStartTime(changeLogBO.getStartTime());
        currRecord.setLastStatus(CsOnlineStatus.CS_OFFLINE.getName());
        currRecord.setEndTime(changeLogBO.getStartTime());
        currRecord.setKeepSeconds(Integer.valueOf(0));
        Date today = new Date();
        String accessId = this.getAccessLogId(changeLogBO.getTenantCode(), changeLogBO.getCsId());
        currRecord.setLoginId(accessId);
        CsStatusChangeContext context = new CsStatusChangeContext();
        BeanUtils.copyProperties((Object)currRecord, (Object)context);
        this.csStatusChangeHandler.onBeforeHandle(context);
        CsStatusChangeLog lastChangeLog = this.csStatusChangeLogMapper.selectLastStatus(changeLogBO.getTenantCode(), changeLogBO.getCsId(), today);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{lastChangeLog})) {
            if (lastChangeLog.getCurrStatus().equals(currRecord.getCurrStatus())) {
                log.warn("\u4fdd\u5b58\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55:\u5ba2\u670d\u72b6\u6001\u6ca1\u6709\u53d8\u66f4,\u4e0d\u505a\u8bb0\u5f55:{}", (Object)changeLogBO);
                return;
            }
            currRecord.setLastStatus(lastChangeLog.getCurrStatus());
            currRecord.setStartTime(lastChangeLog.getEndTime());
            int keepSec = Math.toIntExact((currRecord.getEndTime().getTime() - currRecord.getStartTime().getTime()) / 1000L);
            if (keepSec < 0) {
                log.warn("\u4fdd\u5b58\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55:\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u65f6\u95f4\u6709\u5f02\u5e38:lastChangeLog = {}, current = {}", (Object)lastChangeLog, (Object)changeLogBO);
                return;
            }
            currRecord.setKeepSeconds(Integer.valueOf(keepSec));
        } else {
            Date lastDay = DateTimeUtil.DateAdd((Date)today, (int)5, (int)-1);
            CsStatusChangeLog lastDayChangeLog = this.csStatusChangeLogMapper.selectLastStatus(changeLogBO.getTenantCode(), changeLogBO.getCsId(), lastDay);
            if (lastDayChangeLog != null) {
                if (lastDayChangeLog.getCurrStatus().equals(currRecord.getCurrStatus())) {
                    log.warn("\u4fdd\u5b58\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55:\u5ba2\u670d\u72b6\u6001\u6ca1\u6709\u53d8\u66f4,\u4e0d\u505a\u8bb0\u5f55:{}", (Object)changeLogBO);
                    return;
                }
                if (!CsOnlineStatus.CS_OFFLINE.getName().equals(lastDayChangeLog.getCurrStatus())) {
                    currRecord.setLastStatus(lastDayChangeLog.getCurrStatus());
                    currRecord.setStartTime(lastDayChangeLog.getEndTime());
                    int keepSec = Math.toIntExact((currRecord.getEndTime().getTime() - currRecord.getStartTime().getTime()) / 1000L);
                    currRecord.setKeepSeconds(Integer.valueOf(keepSec));
                    log.info("\u4fdd\u5b58\u5ba2\u670d\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55,\u8de8\u5929\u6570\u636e:{}", (Object)currRecord);
                    context.setHandleYesterday(true);
                    this.csStatusChangeHandler.onAfterHandle(context);
                    this.csStatusChangeLogMapper.insertSelective(currRecord);
                    return;
                }
            }
        }
        this.csStatusChangeHandler.onAfterHandle(context);
        this.csStatusChangeLogMapper.insertSelective(currRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @MethodParamVerifyEnable
    @Transactional
    public void saveCsReceivingLog(CsReceivingChangeLogBO changeLogBO) {
        if (changeLogBO.getChangeTime() == null) {
            changeLogBO.setChangeTime(new Date());
        }
        String key = "CS_RECEIVING_CHANGE_LOCK_" + changeLogBO.getCsId();
        String lockKey = NiccCommonUtil.getAllotLockKey((String)key);
        String loginId = IdWorker.nextAutoIdStr();
        RedisLockEntity redisLockEntity = RedisLockEntity.builder().lockKey(lockKey).requestId(loginId).build();
        log.info("\u4fdd\u5b58\u5ba2\u670d\u63a5\u5f85\u53d8\u66f4\u8bb0\u5f55-\u52a0\u9501:{}", (Object)redisLockEntity);
        long start = System.currentTimeMillis();
        boolean locked = this.redisHelper.lock(redisLockEntity);
        try {
            if (locked) {
                CsReceivingChangeLog lastOne = this.csReceivingChangeLogMapper.selectLastOneToday(changeLogBO.getTenantCode(), changeLogBO.getCsId());
                long durationTime = 0L;
                if (lastOne != null) {
                    durationTime = (changeLogBO.getChangeTime().getTime() - lastOne.getChangeTime().getTime()) / 1000L;
                }
                CsReceivingChangeLog record = new CsReceivingChangeLog();
                BeanUtils.copyProperties((Object)changeLogBO, (Object)record);
                record.setLogId(loginId);
                record.setDurationTime(Integer.valueOf(Math.toIntExact(durationTime)));
                CsInfo csInfo = this.csInfoMapper.selectByPrimaryKey(changeLogBO.getCsId());
                if (csInfo != null) {
                    record.setLiveStatusCode(csInfo.getLiveStatusCode());
                    record.setStatusChangeTime(csInfo.getStatusChangeTime());
                    if (CsOnlineStatus.CS_OFFLINE.matchCode(csInfo.getLiveOnlineStatus())) {
                        record.setLiveStatusCode(CsOnlineStatus.CS_OFFLINE.getName());
                    }
                }
                String accessId = this.getAccessLogId(changeLogBO.getTenantCode(), changeLogBO.getCsId());
                record.setLoginId(accessId);
                long end = System.currentTimeMillis();
                this.csReceivingChangeLogMapper.insertSelective(record);
                log.info("\u4fdd\u5b58\u5ba2\u670d\u63a5\u5f85\u53d8\u66f4\u8bb0\u5f55-\u5b8c\u6210:{},{} ms", (Object)loginId, (Object)(end - start));
            } else {
                TimeUnit.MILLISECONDS.sleep(50L);
                log.info("\u4fdd\u5b58\u5ba2\u670d\u63a5\u5f85\u53d8\u66f4\u8bb0\u5f55-\u52a0\u9501\u5931\u8d25\uff0c\u91cd\u8bd5:{}", (Object)redisLockEntity);
                this.saveCsReceivingLog(changeLogBO);
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u5ba2\u670d\u63a5\u5f85\u53d8\u66f4\u8bb0\u5f55-\u5f02\u5e38:{}", (Object)e.getMessage());
        }
        finally {
            this.redisHelper.unlockLua(redisLockEntity);
        }
    }

    @Override
    public void saveCsSkillQueueLog(CsmUserQueueContext queueContext, String extType) {
        CsSkillGroupQueueLog record = new CsSkillGroupQueueLog();
        try {
            BeanUtils.copyProperties((Object)queueContext, (Object)record);
            record.setLogId(queueContext.getQueueLogId());
            record.setSkillGroupNo(queueContext.getAllotSkillGid());
            record.setTransferFrom(queueContext.getTransferFromCsId());
            record.setSessionId(queueContext.getSessionId());
            record.setExitType(extType);
            if (queueContext.isVipQueue()) {
                record.setQueueType("vip");
            } else {
                record.setQueueType("common");
            }
            if (CsQueueExitType.QUEUE.getCode().equals(extType)) {
                record.setQueueEnterTime(new Date(queueContext.getQueueInTime()));
                record.setQueueEnterIndex(Integer.valueOf(queueContext.getQueuePosition()));
                this.csSkillGroupQueueLogMapper.insertSelective(record);
            } else {
                record.setQueueExitTime(new Date(queueContext.getQueueOutTime()));
                record.setQueueExitIndex(Integer.valueOf(queueContext.getQueuePosition()));
                this.csSkillGroupQueueLogMapper.updateBySelective(record);
            }
        }
        catch (Exception e) {
            log.error("\u6392\u961f\u65e5\u5fd7\u4fdd\u5b58\u5931\u8d25: queueContext = {}", (Object)queueContext, (Object)e);
        }
    }

    @Override
    public int countSignInTime(String tenantCode, String csId, Integer onlineStatus) {
        CsStatusExtend csStatusExtend;
        CsStatusChangeLog lastChangeLog = this.csStatusChangeLogMapper.selectLastStatus(tenantCode, csId, new Date());
        int count = this.csStatusChangeLogMapper.countTodayOnlineStatusTime(tenantCode, csId, onlineStatus.intValue());
        if (lastChangeLog != null && (csStatusExtend = this.csStatusExtendMapper.selectByTenantCodeAndStatus(tenantCode, lastChangeLog.getCurrStatus())) != null && CsOnlineStatus.CS_SIGN_IN.matchCode(csStatusExtend.getOnlineStatus())) {
            long realTime = (System.currentTimeMillis() - lastChangeLog.getEndTime().getTime()) / 1000L;
            count = (int)((long)count + realTime);
        }
        return count;
    }

    @Override
    public int countOnlineTime(String tenantCode, String csId, String status) {
        CsStatusChangeLog lastChangeLog = this.csStatusChangeLogMapper.selectLastStatus(tenantCode, csId, new Date());
        int count = this.csStatusChangeLogMapper.countTodayOnlineTime(tenantCode, csId, status);
        if (lastChangeLog != null && lastChangeLog.getCurrStatus().equals(status)) {
            long realTime = (System.currentTimeMillis() - lastChangeLog.getEndTime().getTime()) / 1000L;
            count = (int)((long)count + realTime);
        }
        return count;
    }

    @Override
    public int countCurrentOnlineTime(String tenantCode, String csId, String status) {
        CsStatusChangeLog lastChangeLog = this.csStatusChangeLogMapper.selectLastStatus(tenantCode, csId, new Date());
        int count = 0;
        if (lastChangeLog != null && lastChangeLog.getCurrStatus().equals(status)) {
            long realTime = (System.currentTimeMillis() - lastChangeLog.getEndTime().getTime()) / 1000L;
            count = (int)((long)count + realTime);
        }
        return count;
    }

    @Override
    public int countTimeByLoginState(String tenantCode, String csId, List<String> states) {
        log.info("\u7edf\u8ba1\u7528\u6237\u72b6\u6001\u8ba1\u65f6:{}-{}-{}", new Object[]{tenantCode, csId, states});
        if (states == null || states.isEmpty()) {
            log.warn("\u7edf\u8ba1\u7528\u6237\u72b6\u6001\u8ba1\u65f6-\u5f02\u5e38:\u53c2\u6570\u9519\u8bef\uff01");
            return 0;
        }
        long start = System.currentTimeMillis();
        CsStatusChangeLog lastChangeLog = this.csStatusChangeLogMapper.selectLastStatus(tenantCode, csId, new Date());
        int count = this.csStatusChangeLogMapper.countTodayStatusTime(tenantCode, csId, states);
        if (lastChangeLog != null && states.contains(lastChangeLog.getCurrStatus())) {
            long realTime = (System.currentTimeMillis() - lastChangeLog.getEndTime().getTime()) / 1000L;
            count = (int)((long)count + realTime);
        }
        long end = System.currentTimeMillis();
        log.info("\u7edf\u8ba1\u7528\u6237\u72b6\u6001\u8ba1\u65f6:{}-{},{} ms", new Object[]{tenantCode, csId, end - start});
        return count;
    }

    private String getAccessLogId(String tenantCode, String csId) {
        try {
            UserAccessLogQueryReqBO queryReqBO = new UserAccessLogQueryReqBO();
            queryReqBO.setTenantCode(tenantCode);
            queryReqBO.setUserId(csId);
            Date date = DateTimeUtil.DateAddHour((int)-24);
            queryReqBO.setAccessDay(date);
            Rsp accessLogRsp = this.userAccessLogService.getAccessLog(queryReqBO);
            log.info("\u67e5\u8be2\u7528\u6237\u8bbf\u95ee\u8bb0\u5f55:{}", accessLogRsp.getData());
            if (accessLogRsp.isSuccess()) {
                return ((UserAccessLogBO)accessLogRsp.getData()).getAccessId();
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u7528\u6237\u8bbf\u95ee\u8bb0\u5f55\u5f02\u5e38:", (Throwable)e);
        }
        return "";
    }
}

