/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.FileUtils;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.google.common.collect.Lists;
import com.tydic.nicc.common.eums.csm.other.UserEvalType;
import com.tydic.nicc.csm.api.CsmMonitorApi;
import com.tydic.nicc.csm.api.bo.monitor.MonitorServiceRecordReqBO;
import com.tydic.nicc.csm.api.bo.monitor.MonitorServiceRecordRspBO;
import com.tydic.nicc.csm.api.bo.monitor.SessionMsgDetail;
import com.tydic.nicc.csm.busi.CsmReportCommonService;
import com.tydic.nicc.csm.utils.excel.MonitorServiceRecordDTO;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.dc.boot.starter.util.DateTimeUtil;
import com.tydic.nicc.im.admin.api.FileManageService;
import com.tydic.nicc.im.bo.FileUploadRequest;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CsmReportCommonServiceImpl
implements CsmReportCommonService {
    private static final Logger log = LoggerFactory.getLogger(CsmReportCommonServiceImpl.class);
    final CsmMonitorApi csmMonitorApi;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private FileManageService fileManageService;

    public CsmReportCommonServiceImpl(@Autowired CsmMonitorApi csmMonitorApi) {
        this.csmMonitorApi = csmMonitorApi;
    }

    @Override
    public RspList serviceRecordMonitorExport(MonitorServiceRecordReqBO serviceRecordReqBO, HttpServletResponse response) {
        log.info("\u5bfc\u51fa\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u5f00\u59cb:{}", (Object)serviceRecordReqBO);
        long startTime = System.currentTimeMillis();
        serviceRecordReqBO.setLimit(1000);
        ArrayList totalList = Lists.newArrayList();
        try {
            RspList rspList = this.csmMonitorApi.serviceRecordMonitor(serviceRecordReqBO);
            totalList.addAll(rspList.getRows());
            while (rspList.isSuccess() && rspList.getRows().size() == 1000) {
                serviceRecordReqBO.setPage(serviceRecordReqBO.getPage() + 1);
                rspList = this.csmMonitorApi.serviceRecordMonitor(serviceRecordReqBO);
                totalList.addAll(rspList.getRows());
            }
            long endTime = System.currentTimeMillis();
            String fileType = "\u54a8\u8be2\u8bb0\u5f55\u62a5\u8868";
            log.info("\u5bfc\u51fa\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u67e5\u8be2\u5b8c\u6210:{}|{}", (Object)totalList.size(), (Object)(endTime - startTime));
            String filePath = System.getProperty("java.io.tmpdir") + File.separator + "\u54a8\u8be2\u8bb0\u5f55\u62a5\u8868" + System.currentTimeMillis() + ".xlsx";
            ArrayList writeList = Lists.newArrayList();
            for (MonitorServiceRecordRspBO recordRspBO : totalList) {
                MonitorServiceRecordDTO recordDTO = new MonitorServiceRecordDTO();
                BeanUtils.copyProperties((Object)recordRspBO, (Object)recordDTO);
                StringBuffer buffer = new StringBuffer();
                for (SessionMsgDetail detail : recordRspBO.getDetails()) {
                    String msgTime = DateTimeUtil.getTimeShortString((Date)new Date(detail.getMsgTime()), (String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
                    buffer.append(detail.getNickName()).append("\uff08").append(msgTime).append("\uff09").append(":").append(detail.getMsgContent()).append("\r\n");
                }
                recordDTO.setEvaluationContent(UserEvalType.getNameByCode((String)recordRspBO.getUserEvalVal()));
                recordDTO.setDetails(buffer.toString());
                if (buffer.length() > 30000) {
                    recordDTO.setDetails(buffer.substring(0, 30000));
                }
                writeList.add(recordDTO);
            }
            ExcelWriter writer = EasyExcel.write((String)filePath, MonitorServiceRecordDTO.class).build();
            WriteSheet sheet = EasyExcel.writerSheet((String)"\u54a8\u8be2\u8bb0\u5f55\u660e\u7ec6").build();
            writer.write((Collection)writeList, sheet);
            writer.finish();
            File file = new File(filePath);
            FileUploadRequest request = FileUploadRequest.builder().tenantCode(serviceRecordReqBO.getTenantCode()).uploadUser("\u54a8\u8be2\u8bb0\u5f55\u62a5\u8868").fileName(file.getName()).file(FileUtils.readFileToByteArray((File)file)).build();
            return this.fileManageService.fileUploadRequest(request);
        }
        catch (Exception e) {
            e.fillInStackTrace();
            log.error("\u5bfc\u51fa\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55-\u5f02\u5e38:", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u5bfc\u51fa\u5ba2\u670d\u63a5\u5f85\u8bb0\u5f55\u5f02\u5e38,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
        }
    }

    public static void main(String[] args) {
        StringBuffer buffer = new StringBuffer();
        String str = "";
        for (int i = 0; i < 30500; ++i) {
            buffer.append(1);
        }
        if (buffer.length() > 30000) {
            str = buffer.substring(0, 30000);
        }
        System.out.println(str);
    }
}

