/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.tydic.nicc.common.eums.csm.ServiceSyncInvokeType;
import com.tydic.nicc.csm.api.bo.formdata.ServiceSyncRestConfig;
import com.tydic.nicc.csm.busi.ServiceSyncService;
import com.tydic.nicc.csm.mapper.FCommonFormConfigMapper;
import com.tydic.nicc.csm.mapper.ServiceSyncConfigMapper;
import com.tydic.nicc.csm.mapper.po.FCommonFormConfig;
import com.tydic.nicc.csm.mapper.po.ServiceSyncConfig;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.http.RestApiHelper;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.mq.starter.api.KKMqProducerHelper;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

@DS(value="nicc-csm")
@Service
public class ServiceSyncServiceImpl
implements ServiceSyncService {
    private static final Logger log = LoggerFactory.getLogger(ServiceSyncServiceImpl.class);
    @Resource
    private ServiceSyncConfigMapper serviceSyncConfigMapper;
    @Resource
    private FCommonFormConfigMapper fCommonFormConfigMapper;
    @Resource
    private KKMqProducerHelper kkMqProducerHelper;
    @Resource
    private RestApiHelper restApiHelper;

    @Override
    public Rsp doServiceSync(String tenantCode, String formCode, Map<String, Object> formData) {
        log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u5f00\u59cb:formCode = {},formData = {}", (Object)formCode, formData);
        FCommonFormConfig fCommonFormConfig = this.fCommonFormConfigMapper.selectByFormCode(tenantCode, formCode);
        if (fCommonFormConfig != null) {
            try {
                String serviceCode = fCommonFormConfig.getServiceSync();
                ServiceSyncConfig syncConfig = this.serviceSyncConfigMapper.selectByServiceCode(serviceCode);
                if (syncConfig == null) {
                    return BaseRspUtils.createSuccessRsp((Object)("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u670d\u52a1\u672a\u914d\u7f6e:serviceCode = " + serviceCode));
                }
                String baseTpl = syncConfig.getInvokeBaseTmpl();
                String inTpl = syncConfig.getInparamTmpl();
                String outTpl = syncConfig.getOutparamTmpl();
                if (StringUtils.isNotEmpty((CharSequence)baseTpl)) {
                    String invokeResult = "";
                    String inParam = NiccCommonUtil.parseTemplate((String)inTpl, (String)serviceCode, formData);
                    log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u5165\u53c2\u89e3\u6790:inParam = {}", (Object)inParam);
                    if (ServiceSyncInvokeType.HTTP.matchCode(syncConfig.getInvokeType())) {
                        ServiceSyncRestConfig restConfig = (ServiceSyncRestConfig)JSONObject.parseObject((String)baseTpl, ServiceSyncRestConfig.class);
                        HttpHeaders headers = new HttpHeaders();
                        if (restConfig.getHeaders() != null) {
                            for (Map.Entry obj : restConfig.getHeaders().entrySet()) {
                                headers.add((String)obj.getKey(), (String)obj.getValue());
                            }
                        }
                        invokeResult = HttpMethod.GET.matches(restConfig.getMethod()) ? this.restApiHelper.get(restConfig.getUrl(), inParam, null, headers, new MediaType[0]) : this.restApiHelper.post(restConfig.getUrl(), inParam, headers, new MediaType[0]);
                        if (StringUtils.isNotEmpty((CharSequence)outTpl)) {
                            Map resultMap = (Map)JSONObject.parseObject((String)invokeResult, Map.class);
                            log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u51fa\u53c2\u89e3\u6790:outParam = {} -> outTpl = {}", (Object)invokeResult, (Object)outTpl);
                            return NiccCommonUtil.parseRspTemplate((String)outTpl, (String)serviceCode, (Map)resultMap);
                        }
                        log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1(http)-\u7ed3\u675f:param = {},response = {}", (Object)inParam, (Object)invokeResult);
                        return BaseRspUtils.createSuccessRsp((Object)invokeResult, (String)"http\u540c\u6b65\u5b8c\u6210");
                    }
                    if (ServiceSyncInvokeType.MQ.matchCode(syncConfig.getInvokeType())) {
                        log.info("\u6570\u636e\u540c\u6b65\u670d\u52a1(mq)-\u7ed3\u675f:topic = {},param = {}", (Object)baseTpl, (Object)inParam);
                        this.kkMqProducerHelper.sendMsg(baseTpl, (Object)inParam);
                        return BaseRspUtils.createSuccessRsp((Object)inParam, (String)"mq\u540c\u6b65\u5b8c\u6210");
                    }
                    if (ServiceSyncInvokeType.DUBBO.matchCode(syncConfig.getInvokeType())) {
                        return BaseRspUtils.createSuccessRsp((Object)invokeResult, (String)"dubbo\u540c\u6b65\u5b8c\u6210");
                    }
                    log.warn("\u6570\u636e\u540c\u6b65\u670d\u52a1,\u672a\u5b9e\u73b0:invokeType = {}", (Object)syncConfig.getInvokeType());
                }
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u540c\u6b65\u5f02\u5e38:", (Throwable)e);
                return BaseRspUtils.createErrorRsp((String)("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u540c\u6b65\u5f02\u5e38:" + e.getMessage()));
            }
        }
        return BaseRspUtils.createSuccessRsp((Object)("\u6570\u636e\u540c\u6b65\u670d\u52a1-\u8868\u5355\u4e0d\u5b58\u5728:formCode = " + formCode));
    }
}

