/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.rocketmq.CsmCsAllotReqContext;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="CSM_CS_ALLOT_CID", topic="CSM_CS_ALLOT")
@Component
public class CsAllotConsumer
implements KKMqConsumerListener<CsmCsAllotReqContext> {
    private static final Logger log = LoggerFactory.getLogger(CsAllotConsumer.class);
    @Resource
    private CsmCsAllotProcessService csmCsAllotProcessService;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;

    public void onMessage(CsmCsAllotReqContext context) {
        long start = System.currentTimeMillis();
        String requestId = IdWorker.nextAutoIdStr();
        context.setAllotRequestId(requestId);
        log.info("\u8f6c\u4eba\u5de5\u6d88\u606f\u5904\u7406-\u5f00\u59cb:requestId = {},context = {}", (Object)requestId, (Object)context);
        Rsp<CsmAllotRspContext> rsp = this.csmCsAllotProcessService.processCsmAllot(context);
        this.csmCsAllotHelper.clearAllotRequestFlag(context.getTenantCode(), context.getUserId());
        long end = System.currentTimeMillis();
        log.info("\u8f6c\u4eba\u5de5\u6d88\u606f\u5904\u7406-\u5b8c\u6210:requestId = {},result = {},\u8017\u65f6 {} ms", new Object[]{requestId, rsp, end - start});
    }
}

