/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.alibaba.fastjson.JSONObject;
import com.tydic.nicc.common.bo.csm.CsmAllotRspContext;
import com.tydic.nicc.common.bo.rocketmq.CsFreeEventContext;
import com.tydic.nicc.common.bo.user.UserAuthInfo;
import com.tydic.nicc.common.constants.ImCoreConstants;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.common.eums.csm.CsFreeType;
import com.tydic.nicc.common.eums.csm.CsOnlineStatus;
import com.tydic.nicc.common.eums.im.ImMsgType;
import com.tydic.nicc.common.eums.im.MsgChatType;
import com.tydic.nicc.common.eums.im.MsgFormType;
import com.tydic.nicc.common.eums.session.SessionCloseType;
import com.tydic.nicc.common.msg.ImMessage;
import com.tydic.nicc.common.msg.ImMessageBody;
import com.tydic.nicc.common.msg.ImUserMessageBody;
import com.tydic.nicc.csm.api.CsEvaluationApi;
import com.tydic.nicc.csm.api.bo.cs.CsAllotRecordUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsAutoReplyConfigBO;
import com.tydic.nicc.csm.api.bo.cs.CsConfigMatcher;
import com.tydic.nicc.csm.api.bo.cs.CsInfoBO;
import com.tydic.nicc.csm.api.bo.cs.CsReceivingChangeLogBO;
import com.tydic.nicc.csm.api.bo.evaluation.InviteUserEvaluationReqBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.service.CsmCsAllotProcessService;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.framework.utils.ImMessageBuilder;
import com.tydic.nicc.framework.utils.NiccCommonUtil;
import com.tydic.nicc.im.core.api.ImMessageService;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import com.tydic.nicc.user.api.UserOptionService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="CSM_CS_FREE_CID", topic="CSM_CS_FREE")
@Component
public class CsFreeEventConsumer
implements KKMqConsumerListener<CsFreeEventContext> {
    private static final Logger log = LoggerFactory.getLogger(CsFreeEventConsumer.class);
    @Resource
    private CsmCsAllotProcessService csmCsAllotProcessService;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmLogCommonService csmLogCommonService;
    @Resource
    private CsEvaluationApi csEvaluationApi;
    @Resource
    private NiccCsmConfigProperties niccCsmConfigProperties;
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private ImMessageService imMessageService;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    public void onMessage(CsFreeEventContext csFreeEventContext) {
        block7: {
            try {
                int count;
                log.info("\u6536\u5230\u5ba2\u670d\u7a7a\u95f2\u6d88\u606f:{}", (Object)csFreeEventContext);
                CsInfoBO csInfoBO = this.csmCommonService.getCsInfo(csFreeEventContext.getCsId());
                if (csInfoBO == null) {
                    log.warn("\u6536\u5230\u5ba2\u670d\u7a7a\u95f2\u6d88\u606f-\u67e5\u8be2\u5ba2\u670d\u4fe1\u606f\u5931\u8d25:{}", (Object)csFreeEventContext);
                    return;
                }
                if (CsFreeType.SESSION_CLOSE.getCode().equals(csFreeEventContext.getFreeType())) {
                    InviteUserEvaluationReqBO evaluationReqBO = new InviteUserEvaluationReqBO();
                    BeanUtils.copyProperties((Object)csFreeEventContext, (Object)evaluationReqBO);
                    log.info("\u6536\u5230\u5ba2\u670d\u7a7a\u95f2\u6d88\u606f-\u89e6\u53d1\u9080\u8bf7\u8bc4\u4ef7:{}", (Object)evaluationReqBO);
                    Rsp rsp1 = this.csEvaluationApi.inviteUserEvaluation(evaluationReqBO);
                    log.info("\u6536\u5230\u5ba2\u670d\u7a7a\u95f2\u6d88\u606f-\u9080\u8bf7\u8bc4\u4ef7\u7ed3\u679c:{}", (Object)rsp1);
                    if (this.niccCsmConfigProperties.getAutoCleanUserForm().booleanValue()) {
                        this.csmCommonService.delFormDataByUserId(csFreeEventContext.getUserId());
                    }
                    count = this.csmCommonService.receivingCount(csFreeEventContext.getTenantCode(), csFreeEventContext.getCsId());
                    CsReceivingChangeLogBO changeLogBO = new CsReceivingChangeLogBO();
                    changeLogBO.setTenantCode(csFreeEventContext.getTenantCode());
                    changeLogBO.setCsId(csFreeEventContext.getCsId());
                    changeLogBO.setChangeTime(new Date());
                    changeLogBO.setCurrReceptionNum(Integer.valueOf(count));
                    changeLogBO.setLastReceptionNum(Integer.valueOf(count + 1));
                    this.csmLogCommonService.saveCsReceivingLog(changeLogBO);
                    if (csFreeEventContext.getSessionEndTime() == null) {
                        csFreeEventContext.setSessionEndTime(new Date());
                    }
                    CsAllotRecordUpdateReqBO updateReqBO = new CsAllotRecordUpdateReqBO();
                    updateReqBO.setTenantCode(csFreeEventContext.getTenantCode());
                    updateReqBO.setSkillGid(csFreeEventContext.getSkillGid());
                    updateReqBO.setAllotCsId(csFreeEventContext.getCsId());
                    updateReqBO.setSessionId(csFreeEventContext.getSessionId());
                    updateReqBO.setServiceEndTime(csFreeEventContext.getSessionEndTime());
                    this.csmCommonService.updateCsAllotServiceEnd(updateReqBO);
                    this.noticeSessionClose(csFreeEventContext, csInfoBO);
                }
                if (!CsOnlineStatus.CS_SIGN_IN.matchCode(csInfoBO.getLiveOnlineStatus())) break block7;
                int maxAllot = 0;
                while (++maxAllot < 10) {
                    Rsp<CsmAllotRspContext> rsp = this.csmCsAllotProcessService.processCsmFreeAllot(csFreeEventContext);
                    count = this.csmCommonService.receivingCount(csFreeEventContext.getTenantCode(), csFreeEventContext.getCsId());
                    if (count < csInfoBO.getReceiveLimit() && (rsp.isSuccess() || rsp.getData() != null)) continue;
                    break;
                }
            }
            catch (Exception e) {
                log.error("\u5ba2\u670d\u7a7a\u95f2\u4e8b\u4ef6\u5904\u7406\u5931\u8d25:", (Throwable)e);
            }
        }
    }

    private void noticeSessionClose(CsFreeEventContext csFreeEventContext, CsInfoBO csInfoBO) {
        String nickName = "\u8bbf\u5ba2";
        String userName = "\u8bbf\u5ba2";
        AutoReplyType replyType = null;
        if (SessionCloseType.USER_CLOSE.getCode().equals(csFreeEventContext.getCloseType())) {
            replyType = AutoReplyType.USER_CLOSE_SESSION;
            Rsp userRsp = this.userOptionService.getUserAuthInfo(csFreeEventContext.getTenantCode(), csFreeEventContext.getUserId());
            if (userRsp.isSuccess()) {
                userName = ((UserAuthInfo)userRsp.getData()).getUserName();
                nickName = ((UserAuthInfo)userRsp.getData()).getNickName();
                if (StringUtils.isEmpty((CharSequence)userName)) {
                    userName = ((UserAuthInfo)userRsp.getData()).getNickName();
                }
            }
        } else if (SessionCloseType.CS_CLOSE.getCode().equals(csFreeEventContext.getCloseType())) {
            replyType = AutoReplyType.CS_CLOSE_SESSION;
            nickName = csInfoBO.getNickName();
            userName = csInfoBO.getCsName();
        } else {
            replyType = SessionCloseType.CS_OFFLINE_LEAVE_CLOSE.getCode().equals(csFreeEventContext.getCloseType()) ? AutoReplyType.CS_LEAVE_CLOSE_SESSION : (SessionCloseType.USER_LEAVE_CLOSE.getCode().equals(csFreeEventContext.getCloseType()) ? AutoReplyType.USER_LEAVE_CLOSE_SESSION : AutoReplyType.SYS_CLOSE_SESSION);
        }
        List<CsAutoReplyConfigBO> replyConfigs = this.csmCommonService.getAutoReplyConfig(csFreeEventContext.getTenantCode(), replyType.getCode());
        String chatKey = NiccCommonUtil.getC2bChatKey((String)csFreeEventContext.getTenantCode(), (String)csFreeEventContext.getUserId());
        CsConfigMatcher csConfigMatcher = new CsConfigMatcher();
        csConfigMatcher.setTenantCode(csFreeEventContext.getTenantCode());
        csConfigMatcher.setSkillGid(csFreeEventContext.getSkillGid());
        CsAutoReplyConfigBO replyConfig = this.csmCsAllotHelper.matchAutoReplyConfig(replyConfigs, csConfigMatcher);
        String replyContent = "";
        replyContent = replyConfig != null && StringUtils.isNotEmpty((CharSequence)replyConfig.getReplyContent()) ? replyConfig.getReplyContent() : AutoReplyType.checkReplyText((String)replyType.getCode(), (String)replyContent);
        if (StringUtils.isNotEmpty((CharSequence)replyContent)) {
            replyContent = replyContent.replace("#userName", userName).replace("#nickName", nickName).replace("#csCode", csInfoBO.getCsCode());
            ImMessage message = ImMessageBuilder.buildBlankMessage((String)ImMsgType.AUTO_REPLY.getCode(), (String)MsgChatType.C2B.getCode());
            message.setTenantCode(csFreeEventContext.getTenantCode());
            message.setFromNo(ImCoreConstants.getSystemUser((String)csFreeEventContext.getTenantCode()));
            message.setToNo(csInfoBO.getCsId());
            message.setSessionId(csFreeEventContext.getSessionId());
            ImUserMessageBody messageBody = new ImUserMessageBody(MsgFormType.NOTICE_MSG.getCode(), replyContent);
            message.setMsgBody((ImMessageBody)messageBody);
            log.info("\u4f1a\u8bdd\u5173\u95ed,\u63a8\u9001\u5ba2\u670d\u7cfb\u7edf\u63d0\u793a:{}", (Object)JSONObject.toJSONString((Object)message));
            this.imMessageService.sendMessageToUser(message, message.getToNo(), chatKey);
        }
    }
}

