/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.tydic.nicc.common.bo.rocketmq.CsImStateChangeContext;
import com.tydic.nicc.common.eums.im.ImChangeStatus;
import com.tydic.nicc.csm.api.CsInfoApi;
import com.tydic.nicc.csm.api.bo.cs.CsInfoUpdateReqBO;
import com.tydic.nicc.csm.api.bo.cs.CsReceivingChangeLogBO;
import com.tydic.nicc.csm.busi.CsmCommonService;
import com.tydic.nicc.csm.busi.CsmLogCommonService;
import com.tydic.nicc.csm.utils.CsOfflineQueueManagerUtil;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="CSM_CS_IM_STATE_CHANGE_CID", topic="CSM_CS_IM_STATE_CHANGE")
@Component
public class CsImStateChangeConsumer
implements KKMqConsumerListener<CsImStateChangeContext> {
    private static final Logger log = LoggerFactory.getLogger(CsImStateChangeConsumer.class);
    @Resource
    private CsInfoApi csInfoApi;
    @Resource
    private CsmCommonService csmCommonService;
    @Resource
    private CsmLogCommonService csmLogCommonService;

    public void onMessage(CsImStateChangeContext stateChangeContext) {
        log.info("\u6536\u5230\u5ba2\u670dim\u72b6\u6001\u53d8\u66f4\u6d88\u606f:{}", (Object)stateChangeContext);
        CsInfoUpdateReqBO csInfoUpdateReqBO = new CsInfoUpdateReqBO();
        csInfoUpdateReqBO.setTenantCode(stateChangeContext.getTenantCode());
        csInfoUpdateReqBO.setCsId(stateChangeContext.getCsId());
        Rsp rsp = null;
        if (ImChangeStatus.ONLINE.getCode().equals(stateChangeContext.getChangeState())) {
            CsOfflineQueueManagerUtil.remove(stateChangeContext.getCsId());
            log.info("\u6536\u5230\u5ba2\u670dim\u72b6\u6001\u53d8\u66f4\u6d88\u606f-\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0a\u7ebf:{}", (Object)csInfoUpdateReqBO);
            rsp = this.csInfoApi.updateCsOnline(csInfoUpdateReqBO);
            if (rsp.isSuccess()) {
                int count = this.csmCommonService.receivingCount(stateChangeContext.getTenantCode(), stateChangeContext.getCsId());
                CsReceivingChangeLogBO changeLogBO = new CsReceivingChangeLogBO();
                changeLogBO.setTenantCode(stateChangeContext.getTenantCode());
                changeLogBO.setCsId(stateChangeContext.getCsId());
                changeLogBO.setChangeTime(new Date());
                changeLogBO.setCurrReceptionNum(Integer.valueOf(count));
                changeLogBO.setLastReceptionNum(Integer.valueOf(count));
                this.csmLogCommonService.saveCsReceivingLog(changeLogBO);
            }
        }
        if (ImChangeStatus.OFFLINE.getCode().equals(stateChangeContext.getChangeState())) {
            CsOfflineQueueManagerUtil.offer(stateChangeContext);
            log.info("\u6536\u5230\u5ba2\u670dim\u72b6\u6001\u53d8\u66f4\u6d88\u606f-\u66f4\u65b0\u5ba2\u670d\u72b6\u6001\u4e0b\u7ebf:{}", (Object)csInfoUpdateReqBO);
            rsp = this.csInfoApi.updateCsOffline(csInfoUpdateReqBO);
        }
        log.info("\u6536\u5230\u5ba2\u670dim\u72b6\u6001\u53d8\u66f4\u6d88\u606f-\u5ba2\u670d\u72b6\u6001\u66f4\u65b0\u6210\u529f:{}", rsp);
    }
}

