/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.tydic.nicc.common.bo.rocketmq.SessionIdleCheckContext;
import com.tydic.nicc.common.eums.csm.AutoReplyType;
import com.tydic.nicc.csm.utils.AutoReplyNoticeHelper;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="SESSION_IDLE_CHECK_CID", topic="SESSION_IDLE_CHECK")
@Component
public class SessionIdleNoticeConsumer
implements KKMqConsumerListener<SessionIdleCheckContext> {
    private static final Logger log = LoggerFactory.getLogger(SessionIdleNoticeConsumer.class);
    @Resource
    private AutoReplyNoticeHelper autoReplyNoticeHelper;

    public void onMessage(SessionIdleCheckContext context) {
        log.info("\u4f1a\u8bdd\u7a7a\u95f2\u68c0\u6d4b-\u5f00\u59cb:{}", (Object)context);
        long lastTime = context.getLastTime().getTime();
        long nowTime = System.currentTimeMillis();
        long diffTime = (nowTime - lastTime) / 1000L;
        if (diffTime >= 180L && diffTime < 300L) {
            this.autoReplyNoticeHelper.pushUserWaitingNotice(context, AutoReplyType.CS_MSG_TIMEOUT_03.getCode(), lastTime);
        }
        if (diffTime >= 300L && diffTime < 600L) {
            this.autoReplyNoticeHelper.pushUserWaitingNotice(context, AutoReplyType.CS_MSG_TIMEOUT_05.getCode(), lastTime);
        }
        if (diffTime >= 600L) {
            this.autoReplyNoticeHelper.pushUserWaitingNotice(context, AutoReplyType.CS_MSG_TIMEOUT_10.getCode(), lastTime);
        }
    }
}

