/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.common.bo.rocketmq.ImTenantModifyContext;
import com.tydic.nicc.csm.config.NiccCsmConfigProperties;
import com.tydic.nicc.csm.mapper.CsmExecSqlMapper;
import com.tydic.nicc.dc.boot.starter.util.FileUtils;
import com.tydic.nicc.dc.boot.starter.util.IdWorker;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.utils.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@KKMqConsumer(consumerGroup="IM_TENANT_MODIFY_CID", topic="IM_TENANT_MODIFY")
@Component
public class TenantModifyConsumer
implements KKMqConsumerListener<ImTenantModifyContext> {
    private static final Logger log = LoggerFactory.getLogger(TenantModifyConsumer.class);
    @Resource
    CsmExecSqlMapper csmExecSqlMapper;
    @Resource
    NiccCsmConfigProperties niccCsmConfigProperties;
    @Value(value="${spring.datasource.url}")
    private String url;

    @Transactional
    public void onMessage(ImTenantModifyContext tenantModifyContext) {
        log.info("init tenant receive message \uff1a{}", (Object)JSON.toJSONString((Object)tenantModifyContext));
        Assert.notNull((Object)tenantModifyContext.getTenantCode(), (String)"\u79df\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)tenantModifyContext.getTenantName(), (String)"\u79df\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        String content = null;
        try {
            ClassPathResource resource = new ClassPathResource("script/sqlScript.sql");
            if ("PostgreSQL".equals(this.niccCsmConfigProperties.getDbType())) {
                resource = new ClassPathResource("script/pgsqlScript.sql");
            } else if (this.url.startsWith("jdbc:dm")) {
                resource = new ClassPathResource("script/dmsqlScript.sql");
            }
            InputStream inputStream = resource.getInputStream();
            content = FileUtils.readFileContent((InputStream)inputStream);
        }
        catch (IOException e) {
            log.error("read file error ", (Throwable)e);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)content)) {
            log.info("sql content is empty!");
            return;
        }
        content = content.replace("$csAutoReplyConfigId", "" + IdWorker.nextAutoId());
        content = content.replace("$csAutoReplyConfigId2", "" + IdWorker.nextAutoId());
        content = content.replace("$tenantCode", tenantModifyContext.getTenantCode());
        log.info("sql content:{}", (Object)content);
        for (String sql : content.split(";")) {
            if (StringUtils.isEmpty((CharSequence)sql.trim())) continue;
            sql = sql.replace("$autoId", IdWorker.nextAutoIdStr());
            this.csmExecSqlMapper.initTenantInfo(sql);
        }
        log.info("init tenant over!");
    }
}

