/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.consumer;

import com.tydic.nicc.common.bo.rocketmq.CsmUserQueueExitContext;
import com.tydic.nicc.common.eums.csm.CsQueueExitType;
import com.tydic.nicc.common.eums.im.ImOnlineStatus;
import com.tydic.nicc.csm.utils.CsmCsAllotHelper;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.mq.starter.annotation.KKMqConsumer;
import com.tydic.nicc.mq.starter.api.KKMqConsumerListener;
import com.tydic.nicc.user.api.UserOptionService;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@KKMqConsumer(consumerGroup="CSM_USER_EXIT_QUEUE_CID", topic="CSM_USER_EXIT_QUEUE")
@Component
public class UserQueueExitConsumer
implements KKMqConsumerListener<CsmUserQueueExitContext> {
    private static final Logger log = LoggerFactory.getLogger(UserQueueExitConsumer.class);
    @Resource
    private CsmCsAllotHelper csmCsAllotHelper;
    @DubboReference(version="${nicc-dc-config.dubbo-provider.version}", group="${nicc-dc-config.dubbo-provider.group}", check=false)
    private UserOptionService userOptionService;

    public void onMessage(CsmUserQueueExitContext queueExitContext) {
        log.info("\u6536\u5230\u7528\u6237\u9000\u51fa\u6392\u961f\u6d88\u606f:{}", (Object)queueExitContext);
        try {
            Rsp usrOnlineRsp = this.userOptionService.getOnlineStatus(queueExitContext.getTenantCode(), queueExitContext.getUserId());
            if (!usrOnlineRsp.isSuccess() || ((String)usrOnlineRsp.getData()).equals(ImOnlineStatus.OFFLINE.getCode())) {
                log.info("\u7528\u6237\u5f53\u524d\u4e0d\u5728\u7ebf\uff0c\u79fb\u51fa\u6392\u961f\u961f\u5217!");
                boolean result = this.csmCsAllotHelper.cancelQueue(queueExitContext.getUserId(), CsQueueExitType.SYS_EXIT.getCode());
                log.info("\u7528\u6237\u9000\u51fa\u6392\u961f\u7ed3\u679c:{}", (Object)result);
            }
        }
        catch (Exception e) {
            log.info("\u7528\u6237\u9000\u51fa\u6392\u961f\u6d88\u606f\u5904\u7406\u5f02\u5e38:", (Throwable)e);
        }
    }
}

