/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.nicc.csm.controller;

import com.alibaba.fastjson.JSON;
import com.tydic.nicc.csm.api.bo.sentence.DelCommSentenceReqBO;
import com.tydic.nicc.csm.api.bo.sentence.QueryCommSentencePageListReqBO;
import com.tydic.nicc.csm.api.bo.sentence.SaveCommSentenceReq;
import com.tydic.nicc.csm.api.bo.sentence.UpdateCommSentenceReq;
import com.tydic.nicc.csm.api.bo.sentence.xlsx.ExportCommSentReqBo;
import com.tydic.nicc.csm.api.bo.sentence.xlsx.ImportCommSentReqBO;
import com.tydic.nicc.csm.api.sentence.CommSentenceApi;
import com.tydic.nicc.csm.api.sentence.CommSentenceBatchApi;
import com.tydic.nicc.dc.base.bo.Rsp;
import com.tydic.nicc.dc.base.bo.RspList;
import com.tydic.nicc.dc.boot.starter.util.BaseRspUtils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/csm-center"})
public class CommSentenceController {
    private static final Logger log = LoggerFactory.getLogger(CommSentenceController.class);
    @Resource
    private CommSentenceApi commSentenceApi;
    @Resource
    private CommSentenceBatchApi commSentenceBatchApi;

    @PostMapping(value={"/sentence/save"})
    public Rsp saveCommSentence(@RequestBody SaveCommSentenceReq req) {
        return this.commSentenceApi.saveCommSentence(req);
    }

    @PostMapping(value={"/sentence/update"})
    public Rsp updateCommSentence(@RequestBody UpdateCommSentenceReq req) {
        return this.commSentenceApi.updateCommSentence(req);
    }

    @PostMapping(value={"/sentence/del"})
    public RspList deleteCommSentence(@RequestBody DelCommSentenceReqBO req) {
        return this.commSentenceApi.deleteCommSentence(req);
    }

    @PostMapping(value={"/sentence/query"})
    public RspList getCommSentencePageList(@RequestBody QueryCommSentencePageListReqBO req) {
        log.info("\u5206\u9875\u67e5\u8be2\u5e38\u7528\u8bed: {}", (Object)JSON.toJSONString((Object)req));
        return this.commSentenceApi.getCommSentencePageList(req);
    }

    @PostMapping(value={"/sentence/export"})
    public RspList exportCommSentList(@RequestBody ExportCommSentReqBo req) {
        return this.commSentenceBatchApi.exportCommSentList(req);
    }

    @PostMapping(value={"/sentence/import"})
    public RspList exportCommSentList(HttpServletRequest request, @RequestBody ImportCommSentReqBO req) {
        try {
            return this.commSentenceBatchApi.importCommSentList(req);
        }
        catch (Exception e) {
            log.error("error :", (Throwable)e);
            return BaseRspUtils.createErrorRspList((String)"\u5bfc\u5165\u5931\u8d25");
        }
    }
}

